/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.databaseconnector;

import java.sql.Connection;
import java.util.Map;
import java.util.Objects;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.InformationSchemaViewsBuilder;
import schemacrawler.schemacrawler.LimitOptionsBuilder;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaRetrievalOptionsBuilder;
import schemacrawler.schemacrawler.exceptions.ConfigurationException;
import schemacrawler.tools.databaseconnector.DatabaseConnectionOptions;
import schemacrawler.tools.databaseconnector.DatabaseConnectorOptions;
import schemacrawler.tools.databaseconnector.DatabaseServerHostConnectionOptions;
import schemacrawler.tools.databaseconnector.DatabaseUrlConnectionOptions;
import schemacrawler.tools.executable.commandline.PluginCommand;
import us.fatehi.utility.Utility;
import us.fatehi.utility.datasource.DatabaseConnectionSource;
import us.fatehi.utility.datasource.DatabaseConnectionSourceBuilder;
import us.fatehi.utility.datasource.DatabaseServerType;
import us.fatehi.utility.datasource.UserCredentials;

public abstract class DatabaseConnector {
    private final DatabaseConnectorOptions options;

    protected DatabaseConnector(DatabaseConnectorOptions options) {
        this.options = Objects.requireNonNull(options, "No database connector options provided");
    }

    public final DatabaseServerType getDatabaseServerType() {
        return this.options.dbServerType();
    }

    public final PluginCommand getHelpCommand() {
        return this.options.helpCommand();
    }

    public final SchemaRetrievalOptionsBuilder getSchemaRetrievalOptionsBuilder(Connection connection) {
        DatabaseConnectionSourceBuilder dbConnectionSourceBuilder = this.options.dbConnectionSourceBuildProcess().get();
        InformationSchemaViews informationSchemaViews = InformationSchemaViewsBuilder.builder().withFunction(this.options.informationSchemaViewsBuildProcess(), connection).toOptions();
        SchemaRetrievalOptionsBuilder schemaRetrievalOptionsBuilder = SchemaRetrievalOptionsBuilder.builder().withDatabaseServerType(this.options.dbServerType()).withInformationSchemaViews(informationSchemaViews).withConnectionInitializer(dbConnectionSourceBuilder.getConnectionInitializer()).fromConnnection(connection);
        this.options.schemaRetrievalOptionsBuildProcess().accept(schemaRetrievalOptionsBuilder, connection);
        return schemaRetrievalOptionsBuilder;
    }

    public final DatabaseConnectionSource newDatabaseConnectionSource(DatabaseConnectionOptions connectionOptions, UserCredentials userCredentials) {
        DatabaseConnectionSourceBuilder dbConnectionSourceBuilder;
        Objects.requireNonNull(connectionOptions, "No database connection options provided");
        if (connectionOptions instanceof DatabaseUrlConnectionOptions) {
            DatabaseUrlConnectionOptions databaseUrlConnectionOptions = (DatabaseUrlConnectionOptions)connectionOptions;
            String connectionUrl = databaseUrlConnectionOptions.connectionUrl();
            dbConnectionSourceBuilder = DatabaseConnectionSourceBuilder.builder(connectionUrl);
        } else if (connectionOptions instanceof DatabaseServerHostConnectionOptions) {
            DatabaseServerHostConnectionOptions serverHostConnectionOptions = (DatabaseServerHostConnectionOptions)connectionOptions;
            String host = serverHostConnectionOptions.host();
            Integer port = serverHostConnectionOptions.port();
            String database = serverHostConnectionOptions.database();
            Map<String, String> urlx = serverHostConnectionOptions.urlx();
            dbConnectionSourceBuilder = this.databaseConnectionSourceBuilder();
            dbConnectionSourceBuilder.withHost(host);
            dbConnectionSourceBuilder.withPort(port);
            dbConnectionSourceBuilder.withDatabase(database);
            dbConnectionSourceBuilder.withUrlx(urlx);
        } else {
            throw new ConfigurationException("Could not create new database connection source");
        }
        dbConnectionSourceBuilder.withUserCredentials(userCredentials);
        DatabaseConnectionSource databaseConnectionSource = dbConnectionSourceBuilder.build();
        return databaseConnectionSource;
    }

    public final boolean supportsUrl(String url) {
        if (Utility.isBlank(url)) {
            return false;
        }
        return this.options.supportsUrl().test(url);
    }

    public final String toString() {
        if (this.options.dbServerType().isUnknownDatabaseSystem()) {
            return "Database connector for unknown database system type";
        }
        return "Database connector for " + String.valueOf(this.options.dbServerType());
    }

    public final SchemaCrawlerOptions withSchemaCrawlerOptionsDefaults(SchemaCrawlerOptions schemaCrawlerOptions) {
        LimitOptionsBuilder limitOptionsBuilder = LimitOptionsBuilder.builder().fromOptions(schemaCrawlerOptions.limitOptions());
        this.options.limitOptionsBuildProcess().accept(limitOptionsBuilder);
        return schemaCrawlerOptions.withLimitOptions(limitOptionsBuilder.toOptions());
    }

    protected DatabaseConnectionSourceBuilder databaseConnectionSourceBuilder() {
        return this.options.dbConnectionSourceBuildProcess().get();
    }
}

