/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.IsPrimitiveNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import com.oracle.truffle.js.nodes.cast.OrdinaryToPrimitiveNodeGen;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.interop.ForeignObjectPrototypeNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;

@GenerateUncached
@ImportStatic(value={JSConfig.class, JSToPrimitiveNode.Hint.class, Strings.class})
public abstract class OrdinaryToPrimitiveNode
extends JavaScriptBaseNode {
    protected OrdinaryToPrimitiveNode() {
    }

    public abstract Object execute(Object var1, JSToPrimitiveNode.Hint var2);

    @Specialization
    protected static Object doObject(JSObject object, JSToPrimitiveNode.Hint hint, @Bind Node node, @Cached.Shared @Cached(value="createGetMethod(TO_STRING, getJSContext())", uncached="getNullNode()") PropertyGetNode getToStringNode, @Cached.Shared @Cached(value="createGetMethod(VALUE_OF, getJSContext())", uncached="getNullNode()") PropertyGetNode getValueOfNode, @Cached.Shared @Cached IsCallableNode isCallableNode, @Cached.Shared @Cached IsPrimitiveNode isPrimitiveNode, @Cached.Shared @Cached(value="createCall()", uncached="getUncachedCall()") JSFunctionCallNode callToStringNode, @Cached.Shared @Cached(value="createCall()", uncached="getUncachedCall()") JSFunctionCallNode callValueOfNode) {
        Object result;
        JSFunctionCallNode methodCall2;
        JSFunctionCallNode methodCall1;
        PropertyGetNode getMethod2;
        PropertyGetNode getMethod1;
        TruffleString propertyKey2;
        TruffleString propertyKey1;
        if (hint == JSToPrimitiveNode.Hint.String) {
            propertyKey1 = Strings.TO_STRING;
            propertyKey2 = Strings.VALUE_OF;
            getMethod1 = getToStringNode;
            getMethod2 = getValueOfNode;
            methodCall1 = callToStringNode;
            methodCall2 = callValueOfNode;
        } else {
            assert (hint == JSToPrimitiveNode.Hint.Number);
            propertyKey1 = Strings.VALUE_OF;
            propertyKey2 = Strings.TO_STRING;
            getMethod1 = getValueOfNode;
            getMethod2 = getToStringNode;
            methodCall1 = callValueOfNode;
            methodCall2 = callToStringNode;
        }
        Object method = JSToPrimitiveNode.getMethod(object, propertyKey1, getMethod1);
        if (isCallableNode.executeBoolean(method) && isPrimitiveNode.executeBoolean(result = methodCall1.executeCall(JSArguments.createZeroArg((Object)object, method)))) {
            return result;
        }
        method = JSToPrimitiveNode.getMethod(object, propertyKey2, getMethod2);
        if (isCallableNode.executeBoolean(method) && isPrimitiveNode.executeBoolean(result = methodCall2.executeCall(JSArguments.createZeroArg((Object)object, method)))) {
            return result;
        }
        throw Errors.createTypeErrorCannotConvertToPrimitiveValue(node);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"isForeignObject(object)"}, limit="InteropLibraryLimit")
    protected static Object doForeign(Object object, JSToPrimitiveNode.Hint hint, @Bind Node node, @Cached.Shared @Cached(value="createGetMethod(TO_STRING, getJSContext())", uncached="getNullNode()") PropertyGetNode getToStringNode, @Cached.Shared @Cached(value="createGetMethod(VALUE_OF, getJSContext())", uncached="getNullNode()") PropertyGetNode getValueOfNode, @Cached.Shared @Cached IsCallableNode isCallableNode, @Cached.Shared @Cached IsPrimitiveNode isPrimitiveNode, @Cached.Shared @Cached(value="createCall()", uncached="getUncachedCall()") JSFunctionCallNode callToStringNode, @Cached.Shared @Cached(value="createCall()", uncached="getUncachedCall()") JSFunctionCallNode callValueOfNode, @Cached.Shared @Cached ForeignObjectPrototypeNode foreignObjectPrototypeNode, @CachedLibrary(value="object") InteropLibrary interop) {
        JSFunctionCallNode methodCall2;
        JSFunctionCallNode methodCall1;
        PropertyGetNode getMethod2;
        PropertyGetNode getMethod1;
        String stringKey2;
        String stringKey1;
        TruffleString propertyKey2;
        TruffleString propertyKey1;
        if (hint == JSToPrimitiveNode.Hint.String) {
            propertyKey1 = Strings.TO_STRING;
            propertyKey2 = Strings.VALUE_OF;
            stringKey1 = "toString";
            stringKey2 = "valueOf";
            getMethod1 = getToStringNode;
            getMethod2 = getValueOfNode;
            methodCall1 = callToStringNode;
            methodCall2 = callValueOfNode;
        } else {
            assert (hint == JSToPrimitiveNode.Hint.Number);
            propertyKey1 = Strings.VALUE_OF;
            propertyKey2 = Strings.TO_STRING;
            stringKey1 = "valueOf";
            stringKey2 = "toString";
            getMethod1 = getValueOfNode;
            getMethod2 = getToStringNode;
            methodCall1 = callValueOfNode;
            methodCall2 = callToStringNode;
        }
        Object result = OrdinaryToPrimitiveNode.tryInvokeForeignMethod(object, stringKey1, interop, isPrimitiveNode);
        if (result != null) {
            return result;
        }
        JSDynamicObject proto = foreignObjectPrototypeNode.execute(object);
        Object method = JSToPrimitiveNode.getPrototypeMethod(proto, object, propertyKey1, getMethod1);
        if (isCallableNode.executeBoolean(method) && isPrimitiveNode.executeBoolean(result = methodCall1.executeCall(JSArguments.createZeroArg(object, method)))) {
            return result;
        }
        result = OrdinaryToPrimitiveNode.tryInvokeForeignMethod(object, stringKey2, interop, isPrimitiveNode);
        if (result != null) {
            return result;
        }
        method = JSToPrimitiveNode.getPrototypeMethod(proto, object, propertyKey2, getMethod2);
        if (isCallableNode.executeBoolean(method) && isPrimitiveNode.executeBoolean(result = methodCall2.executeCall(JSArguments.createZeroArg(object, method)))) {
            return result;
        }
        throw Errors.createTypeErrorCannotConvertToPrimitiveValue(node);
    }

    @NeverDefault
    public static OrdinaryToPrimitiveNode create() {
        return OrdinaryToPrimitiveNodeGen.create();
    }

    @HostCompilerDirectives.InliningCutoff
    private static Object tryInvokeForeignMethod(Object object, String methodName, InteropLibrary interop, IsPrimitiveNode isPrimitiveNode) {
        if (interop.hasMembers(object) && interop.isMemberInvocable(object, methodName)) {
            if (OrdinaryToPrimitiveNode.isJavaArray(object, interop)) {
                return null;
            }
            try {
                Object result = JSRuntime.importValue(interop.invokeMember(object, methodName, new Object[0]));
                if (isPrimitiveNode.executeBoolean(result)) {
                    return result;
                }
            }
            catch (InteropException interopException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isJavaArray(Object object, InteropLibrary interop) {
        return JSRealm.get((Node)interop).getEnv().isHostObject(object) && interop.hasArrayElements(object) && interop.isMemberReadable(object, "length");
    }
}

