/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.multiprocessing;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.multiprocessing.MultiprocessingModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.runtime.PosixSupport;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(defineModule="_multiprocessing")
public class MultiprocessingModuleBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return MultiprocessingModuleBuiltinsFactory.getFactories();
    }

    @Builtin(name="sem_unlink", parameterNames={"name"})
    @GenerateNodeFactory
    static abstract class SemUnlink
    extends PythonUnaryBuiltinNode {
        SemUnlink() {
        }

        @Specialization
        PNone doit(VirtualFrame frame, TruffleString name, @Bind(value="getPosixSupport()") PosixSupport posixSupport, @CachedLibrary(value="posixSupport") PosixSupportLibrary posixLib, @Bind Node inliningTarget, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                posixLib.semUnlink(posixSupport, posixLib.createPathFromString(posixSupport, name));
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            return PNone.NONE;
        }
    }
}

