/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.lint;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import schemacrawler.schema.NamedObjectKey;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.Options;
import schemacrawler.tools.lint.Lint;
import schemacrawler.tools.lint.LintUtility;
import us.fatehi.utility.Multimap;

public final class Lints
implements Options,
Iterable<Lint<? extends Serializable>> {
    private final List<Lint<? extends Serializable>> allLints;
    private final Multimap<NamedObjectKey, Lint<?>> lintsByObject;

    public Lints(Collection<Lint<? extends Serializable>> lints) {
        Objects.requireNonNull(lints, "No lints provided");
        this.allLints = new ArrayList<Lint<? extends Serializable>>(lints);
        this.allLints.sort(LintUtility.LINT_COMPARATOR);
        this.lintsByObject = new Multimap();
        for (Lint<? extends Serializable> lint : lints) {
            this.lintsByObject.add((Object)lint.getObjectKey(), lint);
        }
    }

    public List<Lint<?>> getCatalogLints() {
        return this.getLints(new NamedObjectKey(new String[]{"catalog"}));
    }

    public List<Lint<? extends Serializable>> getLints() {
        return new ArrayList<Lint<? extends Serializable>>(this.allLints);
    }

    public List<Lint<?>> getLints(Table table) {
        Objects.requireNonNull(table, "No table provided");
        return this.getLints(table.key());
    }

    public boolean isEmpty() {
        return this.allLints.isEmpty();
    }

    @Override
    public Iterator<Lint<? extends Serializable>> iterator() {
        return this.getLints().iterator();
    }

    public int size() {
        return this.allLints.size();
    }

    public Stream<Lint<? extends Serializable>> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    private List<Lint<?>> getLints(NamedObjectKey key) {
        List lintsForKey = (List)this.lintsByObject.get((Object)key);
        if (lintsForKey == null) {
            return Collections.emptyList();
        }
        ArrayList lints = new ArrayList(lintsForKey);
        lints.sort(LintUtility.LINT_COMPARATOR);
        return lints;
    }
}

