/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.server.oracle;

import java.sql.Connection;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import us.fatehi.utility.database.SqlScript;
import us.fatehi.utility.string.StringFormat;

public final class OracleConnectionInitializer
implements Consumer<Connection> {
    private static final Logger LOGGER = Logger.getLogger(OracleConnectionInitializer.class.getName());

    @Override
    public void accept(Connection connection) {
        LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Initializing Oracle connection <%s>", new Object[]{connection}));
        SqlScript.executeScriptFromResource((String)"/schemacrawler-oracle.before.sql", (Connection)connection);
        LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Initialized connection <%s>", new Object[]{connection}));
    }
}

