/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.trace;

import com.ibm.db2.cmx.runtime.internal.CentralStore;
import com.ibm.db2.cmx.runtime.internal.CentralStoreKey;
import com.ibm.db2.cmx.runtime.internal.DataProperties;
import com.ibm.db2.cmx.runtime.internal.PdqServiceThreadProvider;
import com.ibm.db2.cmx.runtime.internal.repository.api.RepositoryVersion;
import com.ibm.db2.cmx.runtime.internal.repository.manager.RepositoryVersionImpl;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class DatabaseLogHandler
extends Handler {
    static final int MAX_QUE_CAPACITY = 99;
    static Thread logInserter_ = null;
    static BlockingQueue<LogRecord> logRecordQueue_;
    static Boolean loggingSupported_;
    static volatile int numWaitingLogs__;
    private volatile boolean shutdown__;
    private static CentralStoreKey centralStoreKey_;

    @Override
    public void close() throws SecurityException {
    }

    @Override
    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord logRecord) {
        Object object;
        if (centralStoreKey_ == null && DataProperties.getGlobalCentralStoreKey() != null) {
            object = DataProperties.getGlobalCentralStoreKey();
            synchronized (object) {
                if (centralStoreKey_ == null) {
                    centralStoreKey_ = DataProperties.getGlobalCentralStoreKey().cloneKey();
                }
            }
        }
        if (centralStoreKey_ != null) {
            if (centralStoreKey_.getKeyType() == CentralStoreKey.CentralStoreKeyType.FILE_SYSTEM) {
                if (loggingSupported_ != Boolean.FALSE) {
                    Log.getGlobalLogger().log(Level.CONFIG, Messages.getText("ERR_CANT_LOG_FILESYSTEM", logRecord.getMessage()));
                    loggingSupported_ = Boolean.FALSE;
                    Log.getDatabaseLogger().setLevel(Level.OFF);
                }
            } else {
                if (loggingSupported_ != null && loggingSupported_ == Boolean.FALSE) {
                    return;
                }
                object = this;
                synchronized (object) {
                    if (logInserter_ == null) {
                        if (!PdqServiceThreadProvider.isThreadingEnabled()) {
                            loggingSupported_ = Boolean.FALSE;
                            Log.getGlobalLogger().logp(Level.CONFIG, "DatabaseLogHandler", "publish", Messages.getText("ERR_NO_THREAD_NO_LOGGING", new Object[0]));
                            return;
                        }
                        logRecordQueue_ = new ArrayBlockingQueue<LogRecord>(99);
                        logInserter_ = new Thread((Runnable)new LogInserter(logRecordQueue_, 100), "pdqlogger");
                        logInserter_.setDaemon(true);
                        logInserter_.start();
                        Thread thread = new Thread((Runnable)new LogWaiterForShutdown(logInserter_), PdqServiceThreadProvider.getNextThreadName("pdqloggersh"));
                        Runtime.getRuntime().addShutdownHook(thread);
                    }
                }
                if (logInserter_.isAlive()) {
                    try {
                        logRecordQueue_.offer(logRecord, 3L, TimeUnit.SECONDS);
                        ++numWaitingLogs__;
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        } else if (loggingSupported_ != Boolean.FALSE) {
            Log.getGlobalLogger().log(Level.CONFIG, Messages.getText("ERR_CANT_LOG_NOTDB", logRecord.getMessage()));
            loggingSupported_ = Boolean.FALSE;
            Log.getDatabaseLogger().setLevel(Level.OFF);
        }
    }

    static {
        loggingSupported_ = null;
        numWaitingLogs__ = 0;
        centralStoreKey_ = null;
    }

    class LogInserter
    implements Runnable {
        private final BlockingQueue<LogRecord> queue_;
        private int maxBatchSize_;
        private ArrayList<LogRecord> logRecordsBatch_;

        LogInserter(BlockingQueue<LogRecord> blockingQueue, int n2) {
            this.queue_ = blockingQueue;
            this.maxBatchSize_ = n2;
            this.logRecordsBatch_ = new ArrayList(n2);
        }

        @Override
        public void run() {
            try {
                DatabaseLogHandler.this.shutdown__ = false;
                while (!DatabaseLogHandler.this.shutdown__ || numWaitingLogs__ > 0) {
                    this.consumeLogQueue();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void consumeLogQueue() throws InterruptedException {
            Object object;
            if (centralStoreKey_ == null && DataProperties.getGlobalCentralStoreKey() != null) {
                object = DataProperties.getGlobalCentralStoreKey();
                synchronized (object) {
                    if (centralStoreKey_ == null) {
                        centralStoreKey_ = DataProperties.getGlobalCentralStoreKey().cloneKey();
                    }
                }
            }
            if (loggingSupported_ == null) {
                try {
                    object = CentralStore.getRepositoryVersion(centralStoreKey_);
                    RepositoryVersionImpl repositoryVersionImpl = new RepositoryVersionImpl(object.getComponent(), RepositoryVersion.dbmsLoggingVersion.getVersion(), RepositoryVersion.dbmsLoggingVersion.getRelease(), RepositoryVersion.dbmsLoggingVersion.getMod());
                    loggingSupported_ = object.compareTo(repositoryVersionImpl) >= 0;
                    if (!loggingSupported_.booleanValue()) {
                        Log.getGlobalLogger().logp(Level.CONFIG, "LogInserter", "consumeLogQueue", Messages.getText("ERR_REPOSITORY_VERSION_NO_LOGGING", object.toString()));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.logRecordsBatch_.clear();
            object = this.queue_.take();
            this.logRecordsBatch_.add((LogRecord)object);
            this.queue_.drainTo(this.logRecordsBatch_, this.maxBatchSize_ - 1);
            try {
                if (loggingSupported_ == Boolean.TRUE) {
                    CentralStore.logToRepository(centralStoreKey_, this.logRecordsBatch_);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            numWaitingLogs__ -= this.logRecordsBatch_.size();
        }
    }

    class LogWaiterForShutdown
    implements Runnable {
        Thread logInserter_;

        LogWaiterForShutdown(Thread thread) {
            this.logInserter_ = thread;
        }

        @Override
        public void run() {
            try {
                if (numWaitingLogs__ > 0) {
                    DatabaseLogHandler.this.shutdown__ = true;
                    this.logInserter_.join(3000L);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

