/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.database;

import java.util.Objects;
import us.fatehi.utility.Utility;
import us.fatehi.utility.property.BaseProductVersion;

public final class JdbcDriverInformation
extends BaseProductVersion {
    private static final long serialVersionUID = 7192167974028174124L;
    private final String connectionUrl;
    private final int driverMajorVersion;
    private final int driverMinorVersion;
    private final int jdbcMajorVersion;
    private final int jdbcMinorVersion;
    private final String driverClassName;
    private final boolean jdbcCompliant;

    public JdbcDriverInformation(String driverName, String driverClassName, String driverVersion, int driverMajorVersion, int driverMinorVersion, int jdbcMajorVersion, int jdbcMinorVersion, boolean jdbcCompliant, String connectionUrl) {
        super(driverName, driverVersion);
        this.driverClassName = Objects.requireNonNull(driverClassName, "No database driver Java class name provided");
        this.driverMajorVersion = driverMajorVersion;
        this.driverMinorVersion = driverMinorVersion;
        this.jdbcMajorVersion = jdbcMajorVersion;
        this.jdbcMinorVersion = jdbcMinorVersion;
        this.jdbcCompliant = jdbcCompliant;
        this.connectionUrl = Utility.requireNotBlank(connectionUrl, "No database connection URL provided");
    }

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public int getDriverMajorVersion() {
        return this.driverMajorVersion;
    }

    public int getDriverMinorVersion() {
        return this.driverMinorVersion;
    }

    public String getDriverName() {
        return this.getProductName();
    }

    public String getDriverVersion() {
        return this.getProductVersion();
    }

    public int getJdbcMajorVersion() {
        return this.jdbcMajorVersion;
    }

    public int getJdbcMinorVersion() {
        return this.jdbcMinorVersion;
    }

    public boolean hasDriverClassName() {
        return !Utility.isBlank(this.driverClassName);
    }

    public boolean isJdbcCompliant() {
        return this.jdbcCompliant;
    }

    @Override
    public String toString() {
        StringBuilder info = new StringBuilder(1024);
        info.append("-- driver: ").append(this.getProductName()).append(' ').append(this.getProductVersion()).append(System.lineSeparator());
        info.append("-- driver class: ").append(this.getDriverClassName()).append(System.lineSeparator());
        info.append("-- url: ").append(this.getConnectionUrl()).append(System.lineSeparator());
        return info.toString();
    }
}

