/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.profiler;

import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.tools.profiler.CPUSampler;
import com.oracle.truffle.tools.profiler.ProfilerNode;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.LongSummaryStatistics;
import java.util.Map;

public final class CPUSamplerData {
    final int contextIndex;
    final WeakReference<TruffleContext> contextRef;
    final Map<Thread, Collection<ProfilerNode<CPUSampler.Payload>>> threadData;
    final LongSummaryStatistics biasStatistics;
    final LongSummaryStatistics durationStatistics;
    final long samplesTaken;
    final long intervalMs;
    final long missedSamples;

    CPUSamplerData(int contextIndex, TruffleContext context, Map<Thread, Collection<ProfilerNode<CPUSampler.Payload>>> threadData, LongSummaryStatistics biasStatistics, LongSummaryStatistics durationStatistics, long samplesTaken, long intervalMs, long missedSamples) {
        this.contextIndex = contextIndex;
        this.contextRef = new WeakReference<TruffleContext>(context);
        this.threadData = threadData;
        this.biasStatistics = biasStatistics;
        this.durationStatistics = durationStatistics;
        this.samplesTaken = samplesTaken;
        this.intervalMs = intervalMs;
        this.missedSamples = missedSamples;
    }

    public int getContextIndex() {
        return this.contextIndex;
    }

    @Deprecated
    public TruffleContext getContext() {
        return (TruffleContext)this.contextRef.get();
    }

    public Map<Thread, Collection<ProfilerNode<CPUSampler.Payload>>> getThreadData() {
        return Collections.unmodifiableMap(this.threadData);
    }

    public long getSamples() {
        return this.samplesTaken;
    }

    public long getSampleInterval() {
        return this.intervalMs;
    }

    public LongSummaryStatistics getSampleBias() {
        LongSummaryStatistics statistics = new LongSummaryStatistics();
        statistics.combine(this.biasStatistics);
        return statistics;
    }

    public LongSummaryStatistics getSampleDuration() {
        LongSummaryStatistics statistics = new LongSummaryStatistics();
        statistics.combine(this.durationStatistics);
        return statistics;
    }

    public long missedSamples() {
        return this.missedSamples;
    }
}

