/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FieldDataProvider;
import org.firebirdsql.jdbc.field.TypeConversionException;

final class FBNullField
extends FBField {
    private static final String NULL_CONVERSION_ERROR = "Received non-NULL value of a NULL field.";
    private static final byte[] DUMMY_OBJECT = new byte[0];

    FBNullField(FieldDescriptor fieldDescriptor, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        super(fieldDescriptor, dataProvider, requiredType);
    }

    @Override
    public Object getObject() throws SQLException {
        return this.getAsNull();
    }

    @Override
    public void setObject(Object value) throws SQLException {
        if (value == null) {
            this.setNull();
        } else {
            this.setDummyObject();
        }
    }

    private void setDummyObject() {
        this.setFieldData(DUMMY_OBJECT);
    }

    private void checkNull() throws SQLException {
        if (this.isNull()) {
            throw new TypeConversionException(NULL_CONVERSION_ERROR);
        }
    }

    private <T> T getAsNull() throws SQLException {
        this.checkNull();
        return null;
    }

    @Override
    public byte getByte() throws SQLException {
        this.checkNull();
        return 0;
    }

    @Override
    public short getShort() throws SQLException {
        this.checkNull();
        return 0;
    }

    @Override
    public int getInt() throws SQLException {
        this.checkNull();
        return 0;
    }

    @Override
    public long getLong() throws SQLException {
        this.checkNull();
        return 0L;
    }

    @Override
    public BigDecimal getBigDecimal() throws SQLException {
        return (BigDecimal)this.getAsNull();
    }

    @Override
    public float getFloat() throws SQLException {
        this.checkNull();
        return 0.0f;
    }

    @Override
    public double getDouble() throws SQLException {
        this.checkNull();
        return 0.0;
    }

    @Override
    public boolean getBoolean() throws SQLException {
        this.checkNull();
        return false;
    }

    @Override
    public String getString() throws SQLException {
        return (String)this.getAsNull();
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return (InputStream)this.getAsNull();
    }

    @Override
    public byte[] getBytes() throws SQLException {
        return (byte[])this.getAsNull();
    }

    @Override
    public Date getDate(Calendar cal) throws SQLException {
        return (Date)this.getAsNull();
    }

    @Override
    public Date getDate() throws SQLException {
        return (Date)this.getAsNull();
    }

    @Override
    public Time getTime(Calendar cal) throws SQLException {
        return (Time)this.getAsNull();
    }

    @Override
    public Time getTime() throws SQLException {
        return (Time)this.getAsNull();
    }

    @Override
    public Timestamp getTimestamp(Calendar cal) throws SQLException {
        return (Timestamp)this.getAsNull();
    }

    @Override
    public Timestamp getTimestamp() throws SQLException {
        return (Timestamp)this.getAsNull();
    }

    @Override
    public void setByte(byte value) throws SQLException {
        this.setDummyObject();
    }

    @Override
    public void setShort(short value) throws SQLException {
        this.setDummyObject();
    }

    @Override
    public void setInteger(int value) throws SQLException {
        this.setDummyObject();
    }

    @Override
    public void setLong(long value) throws SQLException {
        this.setDummyObject();
    }

    @Override
    public void setFloat(float value) throws SQLException {
        this.setDummyObject();
    }

    @Override
    public void setDouble(double value) throws SQLException {
        this.setDummyObject();
    }

    @Override
    public void setBigDecimal(BigDecimal value) throws SQLException {
        this.setObject(value);
    }

    @Override
    public void setBoolean(boolean value) throws SQLException {
        this.setDummyObject();
    }

    @Override
    protected void setBinaryStreamInternal(InputStream in, long length) throws SQLException {
        if (this.setWhenNull(in)) {
            return;
        }
        this.setDummyObject();
    }

    @Override
    protected void setCharacterStreamInternal(Reader in, long length) throws SQLException {
        if (this.setWhenNull(in)) {
            return;
        }
        this.setDummyObject();
    }

    @Override
    public void setBytes(byte[] value) throws SQLException {
        this.setObject(value);
    }

    @Override
    public void setDate(Date value, Calendar cal) throws SQLException {
        this.setObject(value);
    }

    @Override
    public void setDate(Date value) throws SQLException {
        this.setObject(value);
    }

    @Override
    public void setTime(Time value, Calendar cal) throws SQLException {
        this.setObject(value);
    }

    @Override
    public void setTime(Time value) throws SQLException {
        this.setObject(value);
    }

    @Override
    public void setTimestamp(Timestamp value, Calendar cal) throws SQLException {
        this.setObject(value);
    }

    @Override
    public void setTimestamp(Timestamp value) throws SQLException {
        this.setObject(value);
    }

    @Override
    public void setString(String value) throws SQLException {
        this.setObject(value);
    }
}

