/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.crypt;

import java.util.Objects;

public final class EncryptionIdentifier {
    public static final String TYPE_SYMMETRIC = "Symmetric";
    private final String type;
    private final String pluginName;
    private final int hashCode;

    public EncryptionIdentifier(String type, String pluginName) {
        this.type = Objects.requireNonNull(type, "type");
        this.pluginName = Objects.requireNonNull(pluginName, "pluginName");
        this.hashCode = Objects.hash(type, pluginName);
    }

    public String getType() {
        return this.type;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public boolean isTypeSymmetric() {
        return TYPE_SYMMETRIC.equals(this.type);
    }

    public boolean equals(Object o) {
        if (!(o instanceof EncryptionIdentifier)) {
            return false;
        }
        EncryptionIdentifier other = (EncryptionIdentifier)o;
        return this == other || this.type.equals(other.type) && this.pluginName.equals(other.pluginName);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.type + "/" + this.pluginName;
    }
}

