/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.sql.SQLException;
import org.firebirdsql.gds.VaxEncoding;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.InfoProcessor;
import org.firebirdsql.gds.ng.SqlCountHolder;

public final class SqlCountProcessor
implements InfoProcessor<SqlCountHolder> {
    private static final byte[] RECORD_COUNT_INFO_ITEMS = new byte[]{23, 1};

    @Override
    public SqlCountHolder process(byte[] infoResponse) throws SQLException {
        if (infoResponse.length == 0) {
            throw FbExceptionBuilder.forException(337248307).messageParameter("sql").toSQLException();
        }
        int pos = 0;
        if (infoResponse[pos++] == 23) {
            byte t;
            pos += 2;
            long updateCount = 0L;
            long insertCount = 0L;
            long deleteCount = 0L;
            long selectCount = 0L;
            while ((t = infoResponse[pos++]) != 1) {
                int countLength = VaxEncoding.iscVaxInteger2(infoResponse, pos);
                long count = VaxEncoding.iscVaxLong(infoResponse, pos += 2, countLength);
                switch (t) {
                    case 13: {
                        selectCount = count;
                        break;
                    }
                    case 14: {
                        insertCount = count;
                        break;
                    }
                    case 15: {
                        updateCount = count;
                        break;
                    }
                    case 16: {
                        deleteCount = count;
                        break;
                    }
                    default: {
                        throw FbExceptionBuilder.forException(335544341).messageParameter(t).toSQLException();
                    }
                }
                pos += countLength;
            }
            return new SqlCountHolder(updateCount, deleteCount, insertCount, selectCount);
        }
        if (infoResponse[0] == 1) {
            return new SqlCountHolder(0L, 0L, 0L, 0L);
        }
        throw new FbExceptionBuilder().exception(337248306).messageParameter("sql", "isc_info_sql_records or isc_info_end", "23 or 1", infoResponse[0]).toSQLException();
    }

    public byte[] getRecordCountInfoItems() {
        return (byte[])RECORD_COUNT_INFO_ITEMS.clone();
    }
}

