/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.jdbc;

import com.amazon.redshift.RedshiftProperty;
import com.amazon.redshift.util.GT;
import com.amazon.redshift.util.RedshiftException;
import com.amazon.redshift.util.RedshiftState;
import java.util.Properties;

public enum SslMode {
    DISABLE("disable"),
    ALLOW("allow"),
    PREFER("prefer"),
    REQUIRE("require"),
    VERIFY_CA("verify-ca"),
    VERIFY_FULL("verify-full");

    public static final SslMode[] VALUES;
    public final String value;

    private SslMode(String value) {
        this.value = value;
    }

    public boolean requireEncryption() {
        return this.compareTo(REQUIRE) >= 0;
    }

    public boolean verifyCertificate() {
        return this == VERIFY_CA || this == VERIFY_FULL;
    }

    public boolean verifyPeerName() {
        return this == VERIFY_FULL;
    }

    public static SslMode of(Properties info) throws RedshiftException {
        String sslmode;
        String sslmodeProp = RedshiftProperty.SSL_MODE.get(info);
        String authMechProp = RedshiftProperty.AUTH_MECH.get(info);
        String string = sslmode = sslmodeProp != null ? sslmodeProp : authMechProp;
        if (sslmode == null) {
            if (RedshiftProperty.SSL.getBoolean(info) || "".equals(RedshiftProperty.SSL.get(info))) {
                return VERIFY_CA;
            }
            String iamAuthStr = RedshiftProperty.IAM_AUTH.get(info);
            Boolean iamAuth = iamAuthStr == null ? false : Boolean.parseBoolean(iamAuthStr);
            return iamAuth != false ? PREFER : DISABLE;
        }
        for (SslMode sslMode : VALUES) {
            if (!sslMode.value.equalsIgnoreCase(sslmode)) continue;
            return sslMode;
        }
        throw new RedshiftException(GT.tr("Invalid sslmode value: {0}", sslmode), RedshiftState.CONNECTION_UNABLE_TO_CONNECT);
    }

    static {
        VALUES = SslMode.values();
    }
}

