/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.dfa;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.regex.tregex.automaton.TransitionOp;
import com.oracle.truffle.regex.tregex.nodes.dfa.CounterTracker;
import com.oracle.truffle.regex.tregex.nodes.dfa.CounterTrackerData;
import com.oracle.truffle.regex.util.BitSets;
import java.util.Arrays;
import java.util.PrimitiveIterator;

public final class CounterTrackerLong
extends CounterTracker {
    private final int min;
    private final int max;
    private final long maskLtMax;
    private final long maskGeMin;
    private final long maskLtMin;
    private final long saturateMinMask;
    private final int fixedOffset;

    public CounterTrackerLong(int min, int max, int numberOfCells, CounterTrackerData.Builder dataBuilder) {
        this.min = min;
        this.max = max;
        this.maskLtMax = BitSets.getRange(0, max - 2);
        this.maskGeMin = BitSets.getRange(min - 1, Math.max(min, max) - 1);
        this.maskLtMin = min > 1 ? BitSets.getRange(0, min - 2) : 0L;
        this.fixedOffset = dataBuilder.getFixedDataSize();
        this.saturateMinMask = max == -1 ? 1L << min - 1 : 0L;
        dataBuilder.requestFixedSize(numberOfCells);
    }

    @Override
    @ExplodeLoop
    public void apply(long op, long[] data, int[][] intArrays) {
        CompilerAsserts.partialEvaluationConstant((long)op);
        int dst = this.mapId(TransitionOp.getTarget(op));
        int kind = TransitionOp.getKind(op);
        int modifier = TransitionOp.getModifier(op);
        if (kind == 2) {
            if (modifier == 1) {
                data[dst] = 1L;
            } else {
                assert (modifier == 2);
                int n = dst;
                data[n] = data[n] | 1L;
            }
        } else {
            int src = this.mapId(TransitionOp.getSource(op));
            long bits = data[src];
            switch (kind) {
                case 1: {
                    long shifted;
                    long l = shifted = this.max == -1 ? bits << 1 | bits & this.saturateMinMask : bits << 1;
                    if (modifier == 1) {
                        data[dst] = shifted;
                        break;
                    }
                    assert (modifier == 2);
                    int n = dst;
                    data[n] = data[n] | shifted;
                    break;
                }
                case 0: {
                    if (modifier == 3) {
                        data[src] = data[dst];
                        data[dst] = bits;
                        break;
                    }
                    if (modifier == 1) {
                        data[dst] = bits;
                        break;
                    }
                    int n = dst;
                    data[n] = data[n] | bits;
                }
            }
        }
    }

    @Override
    public void init(long[] fixedData, int[][] intArrays) {
    }

    @Override
    public boolean support(long operation) {
        return true;
    }

    private int mapId(int sId) {
        return sId + this.fixedOffset;
    }

    @Override
    protected boolean anyLtMax(int sId, long[] fixedData, int[][] intArrays) {
        if (this.max == -1) {
            return true;
        }
        return this.intersect(sId, fixedData, this.maskLtMax);
    }

    @Override
    protected boolean anyGeMin(int sId, long[] fixedData, int[][] intArrays) {
        assert (this.min != 0);
        return this.intersect(sId, fixedData, this.maskGeMin);
    }

    @Override
    protected boolean anyLtMin(int sId, long[] fixedData, int[][] intArrays) {
        assert (this.min != 0);
        return this.intersect(sId, fixedData, this.maskLtMin);
    }

    private boolean intersect(int sId, long[] fixedData, long mask) {
        return (fixedData[this.mapId(sId)] & mask) != 0L;
    }

    @Override
    public String dumpState(int sId, long[] fixedData, int[][] intArrays) {
        long[] bs = new long[]{fixedData[this.mapId(sId)] & BitSets.getRange(0, this.max - 1)};
        int[] values = new int[BitSets.size(bs)];
        PrimitiveIterator.OfInt it = BitSets.iterator(bs);
        for (int i = values.length - 1; i >= 0; --i) {
            values[i] = it.nextInt() + 1;
        }
        return "BitsetLong, current values: " + Arrays.toString(values);
    }
}

