/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.formatter.diagram;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import schemacrawler.loader.counts.TableRowCountsUtility;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.DatabaseInfo;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.DependantObject;
import schemacrawler.schema.Identifiers;
import schemacrawler.schema.Index;
import schemacrawler.schema.IndexType;
import schemacrawler.schema.JdbcDriverInfo;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.Routine;
import schemacrawler.schema.Sequence;
import schemacrawler.schema.Synonym;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableConstraint;
import schemacrawler.schema.TableConstraintType;
import schemacrawler.schema.TableReference;
import schemacrawler.schemacrawler.exceptions.NotLoadedException;
import schemacrawler.tools.command.text.diagram.options.DiagramOptions;
import schemacrawler.tools.command.text.schema.options.HideDatabaseObjectNamesType;
import schemacrawler.tools.command.text.schema.options.HideDependantDatabaseObjectsType;
import schemacrawler.tools.command.text.schema.options.SchemaTextDetailType;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.formatter.diagram.BaseDotFormatter;
import schemacrawler.tools.traversal.SchemaTraversalHandler;
import schemacrawler.utility.MetaDataUtility;
import schemacrawler.utility.NamedObjectSort;
import us.fatehi.utility.Color;
import us.fatehi.utility.Utility;
import us.fatehi.utility.html.Alignment;
import us.fatehi.utility.html.Tag;
import us.fatehi.utility.html.TagBuilder;
import us.fatehi.utility.html.TagOutputFormat;

public final class SchemaDotFormatter
extends BaseDotFormatter
implements SchemaTraversalHandler {
    private final int tableColspan;

    public SchemaDotFormatter(SchemaTextDetailType schemaTextDetailType, DiagramOptions options, OutputOptions outputOptions, Identifiers identifiers) {
        super(schemaTextDetailType, options, outputOptions, identifiers);
        this.tableColspan = options.isShowOrdinalNumbers() ? 4 : 3;
    }

    public void handle(ColumnDataType columnDataType) {
    }

    public void handleInfo(DatabaseInfo dbInfo) {
    }

    public void handleInfo(JdbcDriverInfo driverInfo) {
    }

    public void handle(Routine routine) {
    }

    public void handle(Sequence sequence) {
    }

    public void handle(Synonym synonym) {
    }

    public void handle(Table table) {
        String tableName = this.quoteName((DatabaseObject)table);
        String tableType = "[" + String.valueOf(table.getTableType()) + "]";
        Color tableNameBgColor = this.colorMap.getColor((DatabaseObject)table);
        this.formattingHelper.append("  /* ").append(table.getFullName()).append(" -=-=-=-=-=-=-=-=-=-=-=-=-=- */").println();
        this.formattingHelper.append("  \"").append(this.nodeId((DatabaseObject)table)).append("\" [").println();
        this.formattingHelper.append("    label=<").println();
        this.formattingHelper.append("      <table border=\"1\" cellborder=\"0\" cellspacing=\"0\" color=\"#888888\">").println();
        this.formattingHelper.append(TagBuilder.tableRow().make().addInnerTag(TagBuilder.tableCell().withEscapedText(tableName).withAlignment(Alignment.left).withEmphasis(true).withBackground(tableNameBgColor).withColumnSpan(this.tableColspan - 1).make()).addInnerTag(TagBuilder.tableCell().withEscapedText(tableType).withBackground(tableNameBgColor).withAlignment(Alignment.right).make()).render(TagOutputFormat.html)).println();
        this.printTableRemarks(table);
        if (!((DiagramOptions)this.options).is(HideDependantDatabaseObjectsType.hideTableColumns)) {
            this.printTableColumns(table.getColumns());
            if (this.isVerbose()) {
                this.printTableColumns(new ArrayList<Column>(table.getHiddenColumns()));
            }
        }
        if (this.isVerbose()) {
            this.printIndexes(table);
        }
        this.printAlternateKeys(table);
        this.printTableRowCount(table);
        this.formattingHelper.append("      </table>").println();
        this.formattingHelper.append("    >").println();
        this.formattingHelper.append("  ];").println();
        this.formattingHelper.println();
        this.printForeignKeys(table);
        this.printWeakAssociations(table);
        this.formattingHelper.println();
        this.formattingHelper.println();
    }

    public void handleColumnDataTypesEnd() {
    }

    public void handleColumnDataTypesStart() {
    }

    public void handleInfoEnd() {
    }

    public void handleInfoStart() {
    }

    public void handleRoutinesEnd() {
    }

    public void handleRoutinesStart() {
    }

    public void handleSequencesEnd() {
    }

    public void handleSequencesStart() {
    }

    public void handleSynonymsEnd() {
    }

    public void handleSynonymsStart() {
    }

    public void handleTablesEnd() {
    }

    public void handleTablesStart() {
    }

    private String arrowheadFk(MetaDataUtility.ForeignKeyCardinality connectivity) {
        if (!((DiagramOptions)this.options).isShowForeignKeyCardinality()) {
            return "none";
        }
        switch (connectivity) {
            case zero_one: {
                return "teeodot";
            }
            case zero_many: {
                return "crowodot";
            }
            case one_one: {
                return "teetee";
            }
        }
        return "box";
    }

    private String arrowheadPk() {
        String pkSymbol = ((DiagramOptions)this.options).isShowPrimaryKeyCardinality() ? "teetee" : "none";
        return pkSymbol;
    }

    private String columnReferenceLineStyle(boolean isForeignKey) {
        String style = isForeignKey ? "solid" : "dashed";
        return style;
    }

    private String[] getPortIds(Column column, boolean isNewNode) {
        String[] portIds = new String[2];
        if (!isNewNode) {
            portIds[0] = "\"%s\":\"%s.start\"".formatted(this.nodeId((DatabaseObject)column.getParent()), this.nodeId((DatabaseObject)column));
            portIds[1] = "\"%s\":\"%s.end\"".formatted(this.nodeId((DatabaseObject)column.getParent()), this.nodeId((DatabaseObject)column));
        } else {
            String nodeId;
            portIds[0] = nodeId = this.printNewNode(column);
            portIds[1] = nodeId;
        }
        return portIds;
    }

    private void printAlternateKeys(Table table) {
        if (table == null || ((DiagramOptions)this.options).is(HideDependantDatabaseObjectsType.hideAlternateKeys)) {
            return;
        }
        Collection alternateKeys = table.getAlternateKeys();
        if (alternateKeys == null || alternateKeys.isEmpty()) {
            return;
        }
        this.formattingHelper.append("\t<hr/>").append(System.lineSeparator());
        for (TableConstraint alternateKey : alternateKeys) {
            String name = this.identifiers.quoteName((NamedObject)alternateKey);
            String akName = !((DiagramOptions)this.options).is(HideDatabaseObjectNamesType.hideAlternateKeyNames) ? name : "";
            Object columnsList = MetaDataUtility.getColumnsListAsString((TableConstraint)alternateKey, (Identifiers)this.identifiers);
            if (!Utility.isBlank((String)columnsList)) {
                columnsList = " (" + (String)columnsList + ")";
            }
            String constraintText = "\u2022 %s%s [alternate key]".formatted(akName, columnsList);
            this.formattingHelper.append(TagBuilder.tableRow().make().addInnerTag(TagBuilder.tableCell().withEscapedText(constraintText).withAlignment(Alignment.left).withColumnSpan(this.tableColspan).make()).render(TagOutputFormat.html)).println();
            if (!alternateKey.hasRemarks()) continue;
            this.formattingHelper.append(TagBuilder.tableRow().make().addInnerTag(TagBuilder.tableCell().withEscapedText(alternateKey.getRemarks()).withAlignment(Alignment.left).withBackground(Color.fromRGB((int)244, (int)244, (int)244)).withColumnSpan(this.tableColspan).make()).render(TagOutputFormat.html)).println();
        }
    }

    private String printColumnReference(boolean isForeignKey, String fkName, ColumnReference columnRef, MetaDataUtility.ForeignKeyCardinality fkCardinality, boolean isPkColumnFiltered, boolean isFkColumnFiltered, boolean showRemarks, String remarks) {
        Object label;
        Column primaryKeyColumn = columnRef.getPrimaryKeyColumn();
        Column foreignKeyColumn = columnRef.getForeignKeyColumn();
        boolean isPkColumnSignificant = this.isColumnSignificant(primaryKeyColumn);
        boolean isFkColumnSignificant = this.isColumnSignificant(foreignKeyColumn);
        if (!isPkColumnSignificant || !((DiagramOptions)this.options).isShowFilteredTables() && !isFkColumnSignificant) {
            return "";
        }
        String[] pkPortIds = this.getPortIds(primaryKeyColumn, isPkColumnFiltered);
        String[] fkPortIds = this.getPortIds(foreignKeyColumn, isFkColumnFiltered || !isFkColumnSignificant);
        String pkSymbol = this.arrowheadPk();
        String fkSymbol = this.arrowheadFk(fkCardinality);
        String lineStyle = this.columnReferenceLineStyle(isForeignKey);
        String associationName = isForeignKey && ((DiagramOptions)this.options).is(HideDatabaseObjectNamesType.hideForeignKeyNames) || !isForeignKey && ((DiagramOptions)this.options).is(HideDatabaseObjectNamesType.hideWeakAssociationNames) ? "" : fkName;
        if (showRemarks) {
            String remarksLines = remarks.replaceAll("\\R", "<br/>");
            label = associationName + "<br/>" + remarksLines;
        } else {
            label = associationName;
        }
        return "  %s:w -> %s:e [label=<%s> style=\"%s\" dir=\"both\" arrowhead=\"%s\" arrowtail=\"%s\"];%n".formatted(fkPortIds[0], pkPortIds[1], label, lineStyle, pkSymbol, fkSymbol);
    }

    private void printForeignKeys(Table table) {
        if (table == null || ((DiagramOptions)this.options).is(HideDependantDatabaseObjectsType.hideForeignKeys)) {
            return;
        }
        this.printForeignKeys(table, table.getForeignKeys());
    }

    private <R extends ColumnReference> void printForeignKeys(Table table, Collection<? extends TableReference> foreignKeys) {
        if (foreignKeys.isEmpty()) {
            return;
        }
        for (TableReference tableReference : foreignKeys) {
            boolean isForeignKey = tableReference.getType() == TableConstraintType.foreign_key;
            MetaDataUtility.ForeignKeyCardinality fkCardinality = MetaDataUtility.findForeignKeyCardinality((TableReference)tableReference);
            boolean showRemarks = !((DiagramOptions)this.options).isHideRemarks() && tableReference.hasRemarks();
            for (ColumnReference columnRef : tableReference) {
                Table referencedTable = (Table)columnRef.getPrimaryKeyColumn().getParent();
                Table dependentTable = (Table)columnRef.getForeignKeyColumn().getParent();
                boolean isPkColumnFiltered = this.isTableFiltered(referencedTable);
                boolean isFkColumnFiltered = this.isTableFiltered(dependentTable);
                if (!((DiagramOptions)this.options).isShowFilteredTables() && (isPkColumnFiltered || isFkColumnFiltered)) continue;
                String remarks = showRemarks ? tableReference.getRemarks() : "";
                if (table.equals(referencedTable) || isPkColumnFiltered && table.equals(dependentTable)) {
                    this.formattingHelper.append(this.printColumnReference(isForeignKey, this.identifiers.quoteName(tableReference.getName()), columnRef, fkCardinality, isPkColumnFiltered, isFkColumnFiltered, showRemarks, remarks));
                }
                showRemarks = false;
            }
        }
    }

    private void printIndexes(Table table) {
        if (table == null || ((DiagramOptions)this.options).is(HideDependantDatabaseObjectsType.hideIndexes)) {
            return;
        }
        Collection indexes = table.getIndexes();
        if (indexes == null || indexes.isEmpty()) {
            return;
        }
        this.formattingHelper.append("\t<hr/>").append(System.lineSeparator());
        for (Index index : indexes) {
            String name = this.identifiers.quoteName((NamedObject)index);
            String indexName = !((DiagramOptions)this.options).is(HideDatabaseObjectNamesType.hideIndexNames) ? name : "";
            IndexType indexType = index.getIndexType();
            Object indexTypeString = "";
            if (indexType != IndexType.unknown && indexType != IndexType.other) {
                indexTypeString = indexType.toString() + " ";
            }
            String indexDetails = (index.isUnique() ? "" : "non-") + "unique " + (String)indexTypeString + "index";
            Object columnsList = MetaDataUtility.getColumnsListAsString((Index)index, (Identifiers)this.identifiers);
            if (!Utility.isBlank((String)columnsList)) {
                columnsList = " (" + (String)columnsList + ")";
            }
            String constraintText = "\u2022 %s%s [%s]".formatted(indexName, columnsList, indexDetails);
            this.formattingHelper.append(TagBuilder.tableRow().make().addInnerTag(TagBuilder.tableCell().withEscapedText(constraintText).withAlignment(Alignment.left).withBackground(Color.fromRGB((int)244, (int)244, (int)244)).withColumnSpan(this.tableColspan).make()).render(TagOutputFormat.html)).println();
            if (!index.hasRemarks()) continue;
            this.formattingHelper.append(TagBuilder.tableRow().make().addInnerTag(TagBuilder.tableCell().withEscapedText(index.getRemarks()).withAlignment(Alignment.left).withBackground(Color.fromRGB((int)244, (int)244, (int)244)).withColumnSpan(3).make()).render(TagOutputFormat.html)).println();
        }
    }

    private String printNewNode(Column column) {
        String nodeId = "\"" + this.nodeId((DatabaseObject)column) + "\"";
        String columnName = ((DiagramOptions)this.options).isShowUnqualifiedNames() ? this.identifiers.quoteShortName((DependantObject)column) : this.identifiers.quoteFullName((DependantObject)column);
        String columnNode = "  %s [label=<%s>];%n".formatted(nodeId, columnName);
        this.formattingHelper.append(columnNode);
        return nodeId;
    }

    private void printTableColumnAutoIncremented(Column column) {
        if (column == null) {
            return;
        }
        try {
            if (!column.isAutoIncremented()) {
                return;
            }
        }
        catch (NotLoadedException e) {
            return;
        }
        Tag row = TagBuilder.tableRow().make();
        if (((DiagramOptions)this.options).isShowOrdinalNumbers()) {
            row.addInnerTag(TagBuilder.tableCell().withAlignment(Alignment.right).make());
        }
        row.addInnerTag(TagBuilder.tableCell().withAlignment(Alignment.left).make()).addInnerTag(TagBuilder.tableCell().withText(" ").withAlignment(Alignment.left).make()).addInnerTag(TagBuilder.tableCell().withEscapedText("auto-incremented").withAlignment(Alignment.left).make());
        this.formattingHelper.append(row.render(TagOutputFormat.html)).println();
    }

    private void printTableColumnEnumValues(Column column) {
        if (column == null || !column.isColumnDataTypeKnown() || !column.getColumnDataType().isEnumerated()) {
            return;
        }
        String enumValues = "'%s'".formatted(String.join((CharSequence)"', ", column.getColumnDataType().getEnumValues()));
        Tag row = TagBuilder.tableRow().make();
        if (((DiagramOptions)this.options).isShowOrdinalNumbers()) {
            row.addInnerTag(TagBuilder.tableCell().withAlignment(Alignment.right).make());
        }
        row.addInnerTag(TagBuilder.tableCell().withAlignment(Alignment.left).make()).addInnerTag(TagBuilder.tableCell().withEscapedText(" ").withAlignment(Alignment.left).make()).addInnerTag(TagBuilder.tableCell().withEscapedText(enumValues).withAlignment(Alignment.left).make());
        this.formattingHelper.append(row.render(TagOutputFormat.html)).println();
    }

    private void printTableColumnGenerated(Column column) {
        if (column == null) {
            return;
        }
        try {
            if (!column.isGenerated()) {
                return;
            }
        }
        catch (NotLoadedException e) {
            return;
        }
        Tag row = TagBuilder.tableRow().make();
        if (((DiagramOptions)this.options).isShowOrdinalNumbers()) {
            row.addInnerTag(TagBuilder.tableCell().withAlignment(Alignment.right).make());
        }
        row.addInnerTag(TagBuilder.tableCell().withAlignment(Alignment.left).make()).addInnerTag(TagBuilder.tableCell().withAlignment(Alignment.left).make()).addInnerTag(TagBuilder.tableCell().withEscapedText("generated").withAlignment(Alignment.left).make());
        this.formattingHelper.append(row.render(TagOutputFormat.html)).println();
    }

    private void printTableColumnHidden(Column column) {
        if (column == null) {
            return;
        }
        try {
            if (!column.isHidden()) {
                return;
            }
        }
        catch (NotLoadedException e) {
            return;
        }
        Tag row = TagBuilder.tableRow().make();
        if (((DiagramOptions)this.options).isShowOrdinalNumbers()) {
            row.addInnerTag(TagBuilder.tableCell().withAlignment(Alignment.right).make());
        }
        row.addInnerTag(TagBuilder.tableCell().withAlignment(Alignment.left).make()).addInnerTag(TagBuilder.tableCell().withEscapedText(" ").withAlignment(Alignment.left).make()).addInnerTag(TagBuilder.tableCell().withEscapedText("hidden").withAlignment(Alignment.left).make());
        this.formattingHelper.append(row.render(TagOutputFormat.html)).println();
    }

    private void printTableColumnRemarks(Column column) {
        if (column == null || !column.hasRemarks() || ((DiagramOptions)this.options).isHideRemarks()) {
            return;
        }
        Tag remarksRow = TagBuilder.tableRow().make();
        if (((DiagramOptions)this.options).isShowOrdinalNumbers()) {
            remarksRow.addInnerTag(TagBuilder.tableCell().withAlignment(Alignment.right).make());
        }
        remarksRow.addInnerTag(TagBuilder.tableCell().withAlignment(Alignment.left).make()).addInnerTag(TagBuilder.tableCell().withEscapedText(" ").withAlignment(Alignment.left).make()).addInnerTag(TagBuilder.tableCell().withEscapedText(column.getRemarks()).withAlignment(Alignment.left).make());
        this.formattingHelper.append(remarksRow.render(TagOutputFormat.html)).println();
    }

    private void printTableColumns(List<Column> columnsCollection) {
        if (columnsCollection.isEmpty()) {
            return;
        }
        ArrayList<Column> columns = new ArrayList<Column>(columnsCollection);
        Collections.sort(columns, NamedObjectSort.getNamedObjectSort((boolean)((DiagramOptions)this.options).isAlphabeticalSortForTableColumns()));
        for (Column column : columns) {
            if (!this.isColumnSignificant(column)) continue;
            String columnTypeName = ((DiagramOptions)this.options).isShowStandardColumnTypeNames() ? column.getColumnDataType().getStandardTypeName() : column.getColumnDataType().getDatabaseSpecificTypeName();
            String columnType = columnTypeName + column.getWidth();
            String nullable = this.columnNullable(columnTypeName, column.isNullable());
            String columnDetails = columnType + nullable;
            boolean emphasize = column.isPartOfPrimaryKey();
            Tag row = TagBuilder.tableRow().make();
            if (((DiagramOptions)this.options).isShowOrdinalNumbers()) {
                String ordinalNumberString = String.valueOf(column.getOrdinalPosition());
                row.addInnerTag(TagBuilder.tableCell().withEscapedText(ordinalNumberString).withAlignment(Alignment.right).make());
            }
            row.addInnerTag(TagBuilder.tableCell().withEscapedText(this.identifiers.quoteName(column.getName())).withAlignment(Alignment.left).withEmphasis(emphasize).make()).addInnerTag(TagBuilder.tableCell().withEscapedText(" ").withAlignment(Alignment.left).make()).addInnerTag(TagBuilder.tableCell().withEscapedText(columnDetails).withAlignment(Alignment.left).make());
            row.firstInnerTag().addAttribute("port", this.nodeId((DatabaseObject)column) + ".start");
            row.lastInnerTag().addAttribute("port", this.nodeId((DatabaseObject)column) + ".end");
            this.formattingHelper.append(row.render(TagOutputFormat.html)).println();
            this.printTableColumnEnumValues(column);
            this.printTableColumnHidden(column);
            this.printTableColumnAutoIncremented(column);
            this.printTableColumnGenerated(column);
            this.printTableColumnRemarks(column);
        }
    }

    private void printTableRemarks(Table table) {
        if (table == null || !table.hasRemarks() || ((DiagramOptions)this.options).isHideRemarks()) {
            return;
        }
        this.formattingHelper.append(TagBuilder.tableRow().make().addInnerTag(TagBuilder.tableCell().withEscapedText(table.getRemarks()).withAlignment(Alignment.left).withColumnSpan(this.tableColspan).make()).render(TagOutputFormat.html)).println();
    }

    private void printTableRowCount(Table table) {
        if (((DiagramOptions)this.options).isHideTableRowCounts() || !TableRowCountsUtility.hasRowCount((Table)table)) {
            return;
        }
        this.formattingHelper.append("\t<hr/>").append(System.lineSeparator());
        this.formattingHelper.append(TagBuilder.tableRow().make().addInnerTag(TagBuilder.tableCell().withEscapedText(TableRowCountsUtility.getRowCountMessage((Table)table)).withAlignment(Alignment.right).withColumnSpan(this.tableColspan).make()).render(TagOutputFormat.html)).println();
    }

    private void printWeakAssociations(Table table) {
        if (table == null || ((DiagramOptions)this.options).is(HideDependantDatabaseObjectsType.hideWeakAssociations)) {
            return;
        }
        Collection weakFks = table.getWeakAssociations();
        this.printForeignKeys(table, weakFks);
    }
}

