// !!! This is a file automatically generated by hipify!!!
#pragma once

#include <c10/hip/HIPStream.h>
#include <iostream>
#include <utility>

// HIP Graphs utils used by c10 and aten.
// aten/cuda/HIPGraphsUtils.cuh adds utils used by aten only.

namespace c10::hip {

// RAII guard for "hipStreamCaptureMode", a thread-local value
// that controls the error-checking strictness of a capture.
struct C10_HIP_API HIPStreamCaptureModeGuard {
  HIPStreamCaptureModeGuard(hipStreamCaptureMode desired)
      : strictness_(desired) {
    C10_HIP_CHECK(hipThreadExchangeStreamCaptureMode(&strictness_));
  }
  HIPStreamCaptureModeGuard(const HIPStreamCaptureModeGuard&) = delete;
  HIPStreamCaptureModeGuard(HIPStreamCaptureModeGuard&&) = delete;
  HIPStreamCaptureModeGuard& operator=(const HIPStreamCaptureModeGuard&) =
      delete;
  HIPStreamCaptureModeGuard& operator=(HIPStreamCaptureModeGuard&&) = delete;
  ~HIPStreamCaptureModeGuard() {
    C10_HIP_CHECK_WARN(hipThreadExchangeStreamCaptureMode(&strictness_));
  }

 private:
  hipStreamCaptureMode strictness_;
};

// Protects against enum hipStreamCaptureStatus implementation changes.
// Some compilers seem not to like static_assert without the messages.
static_assert(
    int(hipStreamCaptureStatus::hipStreamCaptureStatusNone) == 0,
    "unexpected int(hipStreamCaptureStatusNone) value");
static_assert(
    int(hipStreamCaptureStatus::hipStreamCaptureStatusActive) == 1,
    "unexpected int(hipStreamCaptureStatusActive) value");
static_assert(
    int(hipStreamCaptureStatus::hipStreamCaptureStatusInvalidated) == 2,
    "unexpected int(hipStreamCaptureStatusInvalidated) value");

enum class CaptureStatus : int {
  None = int(hipStreamCaptureStatus::hipStreamCaptureStatusNone),
  Active = int(hipStreamCaptureStatus::hipStreamCaptureStatusActive),
  Invalidated = int(hipStreamCaptureStatus::hipStreamCaptureStatusInvalidated)
};

inline std::ostream& operator<<(std::ostream& os, CaptureStatus status) {
  switch (status) {
    case CaptureStatus::None:
      os << "hipStreamCaptureStatusNone";
      break;
    case CaptureStatus::Active:
      os << "hipStreamCaptureStatusActive";
      break;
    case CaptureStatus::Invalidated:
      os << "hipStreamCaptureStatusInvalidated";
      break;
    default:
      TORCH_INTERNAL_ASSERT(
          false, "Unknown HIP graph CaptureStatus", int(status));
  }
  return os;
}

// Use this version where you're sure a HIP context exists already.
inline CaptureStatus currentStreamCaptureStatusMayInitCtx() {
  hipStreamCaptureStatus is_capturing{hipStreamCaptureStatusNone};
  C10_HIP_CHECK(
      hipStreamIsCapturing(c10::hip::getCurrentHIPStream(), &is_capturing));
  return CaptureStatus(is_capturing);
}

} // namespace c10::hip
