/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.DateChecker;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.Semantics;
import ai.grazie.rules.en.SpellingRules;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.TextRange;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EnglishDateChecker
extends DateChecker {
    static final NodePattern dayOfMonth = NodePattern.or(EnglishTreePatterns.ordinalWithSuffix, NodePattern.N.form("\\d\\d?"));
    static final EnglishDateChecker INSTANCE = new EnglishDateChecker();
    final NodePattern month;
    final NodePattern dayOfWeek;
    private final NodePattern spelledMonthDate;
    private static final Pattern slashDate = Pattern.compile("([0-9][0-9])/([0-9][0-9])(/([123][0-9]{3}))?");
    static final NodePattern slashDateNode = NodePattern.N.form(slashDate.pattern());
    private static final NodePattern perfect = NodePattern.N.pos("VBN").withDependent("aux", NodePattern.N.lemma("have")).noDependents("aux", NodePattern.N.lemma("will"));
    private static final NodePattern pastVerb = NodePattern.or(perfect, NodePattern.N.pos("VBD")).message("The future date disagrees with the past '$_'");
    private static final NodePattern pastClause = NodePattern.or(pastVerb, NodePattern.N.withDependent("cop", pastVerb));

    EnglishDateChecker() {
        super(Locale.ENGLISH, "MMMM d, uuuu", "MMMM d");
        this.month = NodePattern.N.form(StreamEx.of((Collection)this.monthNames).flatCollection(s -> List.of(s, s.substring(0, 3), s.substring(0, 3) + "\\.")).joining((CharSequence)"|"));
        this.dayOfWeek = NodePattern.N.form(StreamEx.of((Collection)this.dayNames).flatCollection(s -> List.of(s, s.substring(0, 2), s.substring(0, 3))).joining((CharSequence)"|"));
        this.spelledMonthDate = NodePattern.or(this.month.markAs("Month").directlyBefore(dayOfMonth.markAs("Day").andOptionally(CommonPatterns.beforeSkipping(CommonPatterns.comma, EnglishTreePatterns.singleYearCD.markAs("Year")))), dayOfMonth.markAs("Day").directlyBefore(this.month.markAs("Month")).andOptionally(NodePattern.N.withNeighbor(2, EnglishTreePatterns.singleYearCD.markAs("Year"))));
    }

    private Month findMonth(Node node) {
        return Month.of(EnglishDateChecker.findStarting(EnglishDateChecker.trimDot(node.lowForm()), this.monthNames) + 1);
    }

    @Override
    protected String weekdayExampleSentence(String date, String day) {
        return "Today is <b>" + day + ", " + date.replaceFirst("(\\d+)", "$1</b>");
    }

    @Override
    protected String wrongWeekdayMessage(LocalDate date, DayOfWeek day, String sentenceText, DateChecker.YearStrategy strategy) {
        String prefix = strategy == DateChecker.YearStrategy.current ? "Did you mean the current year? " : "";
        return prefix + this.canonicalDateFormat.format(date) + " is not a " + this.fullDayFormat.format(day);
    }

    NodePattern absolutePattern() {
        return NodePattern.or(this.wrongWeekday(DateChecker.YearStrategy.absolute), this.invalidDate(), this.fiveDigitYear());
    }

    NodePattern relativePattern() {
        return NodePattern.or(this.futureDatePastVerb(), this.dateFromLastYear(), this.wrongWeekday(DateChecker.YearStrategy.current));
    }

    private NodePattern dateFromLastYear() {
        return NodePattern.or(this.spelledMonthDate.and(NodePattern.markedNodeMatches("Year", NodePattern.N.includeIntoReport())), dashDate, slashDateNode).andNot(NodePattern.N.after(this.dayOfWeek)).andNot(NodePattern.N.withDependent("cop").noDependents("case")).andNot(CommonPatterns.possiblySkipUp("compound", NodePattern.N.withDependent("case", NodePattern.N.form("since|from|after")))).and((node, match) -> this.checkDateFromLastYear(node, match, this.extractFullDate(node, DateChecker.YearStrategy.absolute), "Did you mean the new year %s?"));
    }

    private NodePattern futureDatePastVerb() {
        return NodePattern.or(NodePattern.or(this.spelledMonthDate.reportEverythingTouched(), slashDateNode).directlyAfter(NodePattern.N.form("on")).and(node -> {
            DateChecker.ParsedDate date = this.extractFullDate((Node)node, DateChecker.YearStrategy.absolute);
            return date != null && date.isInFuture();
        }), year.andOptionally(NodePattern.N.directlyAfter(this.month.markAs("Month"))).reportEverythingTouched().and((node, match) -> {
            Node prev;
            Node month = match.findMarkedNode("Month");
            Node node2 = prev = month != null ? month.prevNode() : node.prevNode();
            if (prev == null || !prev.hasForm("in")) {
                return null;
            }
            LocalDate date = EnglishDateChecker.validDate(Integer.parseInt(node.form()), month == null ? Month.JANUARY : this.findMonth(month), 1);
            return date != null && date.isAfter(EnglishDateChecker.now()) ? match : null;
        })).and(CommonPatterns.skipUp("nummod|nmod:tmod", CommonPatterns.skipUp("obl", pastClause)));
    }

    private NodePattern fiveDigitYear() {
        return NodePattern.or(NodePattern.N.withHead("nummod|nmod:tmod", NodePattern.or(this.month, Semantics.season, NodePattern.N.withDependent("compound", Semantics.season))).afterHead(), EnglishTreePatterns.compound, NodePattern.N.withHead("nummod", NodePattern.N.onlyPos("NN").withHeadRelation("nsubj(:pass|:outer)?|csubj(:pass)?"))).and(EnglishDateChecker.fiveDigitYear("Did you mean a year number?"));
    }

    private NodePattern wrongWeekday(DateChecker.YearStrategy strategy) {
        return this.dayOfWeek.and((weekday, match) -> {
            Node next = weekday.nextNode();
            if (next != null && next == weekday.head() && weekday.hasHeadRelation("compound")) {
                next = next.nextNode();
            }
            if (CommonPatterns.comma.matches(next)) {
                next = next.nextNode();
            }
            DateChecker.ParsedDate date = next == null ? null : this.extractFullDate(next, strategy);
            return date == null ? null : this.checkWeekday(weekday, match, date, strategy);
        });
    }

    private NodePattern invalidDate() {
        return this.month.and(CommonPatterns.beforeSkipping(CommonPatterns.comma, NodePattern.N.form("\\d+").markAs("Day").andOr(CommonPatterns.beforeSkipping(CommonPatterns.comma, EnglishTreePatterns.singleYearCD.markAs("Year")), NodePattern.N.directlyBefore(NodePattern.or(CommonPatterns.HYPHEN_NODE, CommonPatterns.DASH_NODE)).withNeighbor(2, NodePattern.N.form("\\d+").markAs("RangeEnd").and(CommonPatterns.beforeSkipping(CommonPatterns.comma, EnglishTreePatterns.singleYearCD.markAs("Year"))))))).reportEverythingTouched().and((node, match) -> {
            String end;
            Node endNode = match.findMarkedNode("RangeEnd");
            String start = match.getMarkedNode("Day").form();
            String string = end = endNode == null ? null : endNode.form();
            if (end != null && Integer.parseInt(start) >= Integer.parseInt(end)) {
                return match.withMessage("The starting date should be before the ending date");
            }
            Month month = this.findMonth(node);
            String year = match.getMarkedNode("Year").form();
            int maxDays = month.length(EnglishDateChecker.isLeapYear(year));
            if (Integer.parseInt(start) > maxDays || end != null && Integer.parseInt(end) > maxDays) {
                if (month == Month.FEBRUARY) {
                    return match.withMessage("February " + year + " has only " + maxDays + " days");
                }
                return match.withMessage(this.renderMonth(month) + " has only " + maxDays + " days");
            }
            return null;
        });
    }

    @Nullable
    private DateChecker.ParsedDate extractFullDate(@NotNull Node start, DateChecker.YearStrategy strategy) {
        NodeMatch match = this.spelledMonthDate.match(start);
        if (match != null) {
            Node dayNode = match.getMarkedNode("Day");
            Node monthNode = match.getMarkedNode("Month");
            Node yearNode = match.findMarkedNode("Year");
            Integer year = strategy.nodeYear(yearNode);
            Month month = this.findMonth(monthNode);
            return year == null || month == null ? null : new DateChecker.ParsedDate(start.tree(), TextRange.fromLength(dayNode.startOffset(), EnglishDateChecker.trimOrdinalSuffix(dayNode.lowForm())), monthNode.textRange(), yearNode == null ? null : yearNode.textRange(), month, year);
        }
        Matcher matcher = slashDate.matcher(start.form());
        if (matcher.matches()) {
            int yearStart = matcher.start(4);
            return DateChecker.ParsedDate.fromAmbiguousDate(start.tree(), new TextRange(matcher.start(1), matcher.end(1)).shiftRight(start.startOffset()), new TextRange(matcher.start(2), matcher.end(2)).shiftRight(start.startOffset()), yearStart < 0 ? null : new TextRange(yearStart, matcher.end(4)).shiftRight(start.startOffset()), strategy);
        }
        if (dashDate.matches(start) && strategy == DateChecker.YearStrategy.absolute) {
            return DateChecker.ParsedDate.fromAmbiguousDate(start.tree(), start.neighbor(2).textRange(), start.neighbor(4).textRange(), start.textRange(), strategy);
        }
        return null;
    }

    private static int trimOrdinalSuffix(String ordinal) {
        return (int)ordinal.chars().filter(Character::isDigit).count();
    }

    @Override
    protected NodeCorrector monthDayCorrector(DateChecker.ParsedDate date, int dayOfMonth) {
        TextRange range = date.dayOfMonth();
        Node node = date.tree().findNodeAt(range.start());
        if (EnglishDateChecker.dayOfMonth.matches(node) && EnglishDateChecker.trimOrdinalSuffix(node.form()) < node.form().length()) {
            return NodeCorrector.replace(node, dayOfMonth + SpellingRules.expectedSuffix(dayOfMonth));
        }
        return super.monthDayCorrector(date, dayOfMonth);
    }

    @Override
    protected boolean hasPastTenseAround(Node dayName) {
        return dayName.hierarchy().anyMatch(pastClause::matches);
    }
}

