/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.semantics;

import androidx.collection.IntObjectMap;
import androidx.collection.MutableObjectList;
import androidx.collection.ObjectList;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.semantics.EmptySemanticsModifier;
import androidx.compose.ui.semantics.SemanticsConfiguration;
import androidx.compose.ui.semantics.SemanticsInfo;
import androidx.compose.ui.semantics.SemanticsListener;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.semantics.SemanticsNodeKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B'\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u0019\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0080\u0002\u00a2\u0006\u0002\b\u001cJ\u001f\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00162\b\u0010 \u001a\u0004\u0018\u00010!H\u0000\u00a2\u0006\u0002\b\"J\u0015\u0010#\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b$J\u001f\u0010%\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00162\b\u0010 \u001a\u0004\u0018\u00010!H\u0000\u00a2\u0006\u0002\b&J\u001f\u0010'\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00162\b\u0010 \u001a\u0004\u0018\u00010!H\u0000\u00a2\u0006\u0002\b(R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006)"}, d2={"Landroidx/compose/ui/semantics/SemanticsOwner;", "", "rootNode", "Landroidx/compose/ui/node/LayoutNode;", "outerSemanticsNode", "Landroidx/compose/ui/semantics/EmptySemanticsModifier;", "nodes", "Landroidx/collection/IntObjectMap;", "<init>", "(Landroidx/compose/ui/node/LayoutNode;Landroidx/compose/ui/semantics/EmptySemanticsModifier;Landroidx/collection/IntObjectMap;)V", "rootSemanticsNode", "Landroidx/compose/ui/semantics/SemanticsNode;", "getRootSemanticsNode", "()Landroidx/compose/ui/semantics/SemanticsNode;", "unmergedRootSemanticsNode", "getUnmergedRootSemanticsNode", "listeners", "Landroidx/collection/MutableObjectList;", "Landroidx/compose/ui/semantics/SemanticsListener;", "getListeners$ui", "()Landroidx/collection/MutableObjectList;", "rootInfo", "Landroidx/compose/ui/semantics/SemanticsInfo;", "getRootInfo$ui", "()Landroidx/compose/ui/semantics/SemanticsInfo;", "get", "semanticsId", "", "get$ui", "notifySemanticsChange", "", "semanticsInfo", "previousSemanticsConfiguration", "Landroidx/compose/ui/semantics/SemanticsConfiguration;", "notifySemanticsChange$ui", "notifySemanticsAdded", "notifySemanticsAdded$ui", "notifySemanticsRemoved", "notifySemanticsRemoved$ui", "notifySemanticsDeactivated", "notifySemanticsDeactivated$ui", "ui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSemanticsOwner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SemanticsOwner.kt\nandroidx/compose/ui/semantics/SemanticsOwner\n+ 2 ObjectList.kt\nandroidx/collection/ObjectList\n*L\n1#1,266:1\n287#2,6:267\n287#2,6:273\n287#2,6:279\n287#2,6:285\n*S KotlinDebug\n*F\n+ 1 SemanticsOwner.kt\nandroidx/compose/ui/semantics/SemanticsOwner\n*L\n75#1:267,6\n79#1:273,6\n86#1:279,6\n93#1:285,6\n*E\n"})
public final class SemanticsOwner {
    @NotNull
    private final LayoutNode rootNode;
    @NotNull
    private final EmptySemanticsModifier outerSemanticsNode;
    @NotNull
    private final IntObjectMap<LayoutNode> nodes;
    @NotNull
    private final MutableObjectList<SemanticsListener> listeners;
    public static final int $stable = 8;

    public SemanticsOwner(@NotNull LayoutNode rootNode, @NotNull EmptySemanticsModifier outerSemanticsNode, @NotNull IntObjectMap<LayoutNode> nodes) {
        Intrinsics.checkNotNullParameter((Object)rootNode, (String)"rootNode");
        Intrinsics.checkNotNullParameter((Object)outerSemanticsNode, (String)"outerSemanticsNode");
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        this.rootNode = rootNode;
        this.outerSemanticsNode = outerSemanticsNode;
        this.nodes = nodes;
        this.listeners = new MutableObjectList(3);
    }

    @NotNull
    public final SemanticsNode getRootSemanticsNode() {
        return SemanticsNodeKt.SemanticsNode(this.rootNode, true);
    }

    @NotNull
    public final SemanticsNode getUnmergedRootSemanticsNode() {
        EmptySemanticsModifier emptySemanticsModifier = this.outerSemanticsNode;
        LayoutNode layoutNode = this.rootNode;
        SemanticsConfiguration semanticsConfiguration = new SemanticsConfiguration();
        return new SemanticsNode(emptySemanticsModifier, false, layoutNode, semanticsConfiguration);
    }

    @NotNull
    public final MutableObjectList<SemanticsListener> getListeners$ui() {
        return this.listeners;
    }

    @NotNull
    public final SemanticsInfo getRootInfo$ui() {
        return this.rootNode;
    }

    @Nullable
    public final SemanticsInfo get$ui(int semanticsId) {
        return (SemanticsInfo)this.nodes.get(semanticsId);
    }

    public final void notifySemanticsChange$ui(@NotNull SemanticsInfo semanticsInfo, @Nullable SemanticsConfiguration previousSemanticsConfiguration) {
        Intrinsics.checkNotNullParameter((Object)semanticsInfo, (String)"semanticsInfo");
        ObjectList this_$iv = (ObjectList)this.listeners;
        boolean $i$f$forEach = false;
        Object[] content$iv = this_$iv.content;
        int n = this_$iv._size;
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            SemanticsListener it = (SemanticsListener)content$iv[i$iv];
            boolean bl = false;
            it.onSemanticsChanged(semanticsInfo, previousSemanticsConfiguration);
        }
    }

    public final void notifySemanticsAdded$ui(@NotNull SemanticsInfo semanticsInfo) {
        Intrinsics.checkNotNullParameter((Object)semanticsInfo, (String)"semanticsInfo");
        ObjectList this_$iv = (ObjectList)this.listeners;
        boolean $i$f$forEach = false;
        Object[] content$iv = this_$iv.content;
        int n = this_$iv._size;
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            SemanticsListener it = (SemanticsListener)content$iv[i$iv];
            boolean bl = false;
            it.onSemanticsAdded(semanticsInfo);
        }
    }

    public final void notifySemanticsRemoved$ui(@NotNull SemanticsInfo semanticsInfo, @Nullable SemanticsConfiguration previousSemanticsConfiguration) {
        Intrinsics.checkNotNullParameter((Object)semanticsInfo, (String)"semanticsInfo");
        ObjectList this_$iv = (ObjectList)this.listeners;
        boolean $i$f$forEach = false;
        Object[] content$iv = this_$iv.content;
        int n = this_$iv._size;
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            SemanticsListener it = (SemanticsListener)content$iv[i$iv];
            boolean bl = false;
            it.onSemanticsRemoved(semanticsInfo, previousSemanticsConfiguration);
        }
    }

    public final void notifySemanticsDeactivated$ui(@NotNull SemanticsInfo semanticsInfo, @Nullable SemanticsConfiguration previousSemanticsConfiguration) {
        Intrinsics.checkNotNullParameter((Object)semanticsInfo, (String)"semanticsInfo");
        ObjectList this_$iv = (ObjectList)this.listeners;
        boolean $i$f$forEach = false;
        Object[] content$iv = this_$iv.content;
        int n = this_$iv._size;
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            SemanticsListener it = (SemanticsListener)content$iv[i$iv];
            boolean bl = false;
            it.onSemanticsDeactivated(semanticsInfo, previousSemanticsConfiguration);
        }
    }
}

