/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.rt.execution;

import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class ForkedDebuggerHelper {
    public static final String JVM_DEBUG_SETUP_PREFIX = "-agentlib:jdwp=transport=dt_socket,server=n,suspend=y,address=";
    public static final String DEBUG_FORK_SOCKET_PARAM = "-forkSocket";
    public static final String DEBUG_SERVER_PORT_KEY = "DEBUG_SERVER_PORT";
    public static final String RUNTIME_MODULE_DIR_KEY = "MODULE_DIR";
    public static final String PARAMETERS_SEPARATOR = ";";
    public static final String FINISH_PARAMS = "FINISH_PARAMS";
    public static final String DISPATCH_PORT_SYS_PROP = "idea.debugger.dispatch.port";
    public static final String DISPATCH_ADDR_SYS_PROP = "idea.debugger.dispatch.addr";

    public static int setupDebugger(String debuggerId, String processName, String processParameters, String moduleDir) {
        return ForkedDebuggerHelper.setupDebugger(debuggerId, processName, processParameters, ForkedDebuggerHelper.getPortFromProperty(), moduleDir);
    }

    public static int setupDebugger(String debuggerId, String processName, String processParameters, int dispatchPort, String moduleDir) {
        int port = 0;
        try {
            port = ForkedDebuggerHelper.findAvailableSocketPort();
            processParameters = processParameters == null || processParameters.isEmpty() ? "" : processParameters + PARAMETERS_SEPARATOR;
            processParameters = processParameters + DEBUG_SERVER_PORT_KEY + "=" + port + PARAMETERS_SEPARATOR;
            processParameters = processParameters + RUNTIME_MODULE_DIR_KEY + "=" + moduleDir;
            ForkedDebuggerHelper.send(debuggerId, processName, processParameters, dispatchPort);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return port;
    }

    public static HashMap<String, String> splitParameters(@NotNull String processParameters) {
        String[] envVars;
        if (processParameters == null) {
            ForkedDebuggerHelper.$$$reportNull$$$0(0);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (String envVar : envVars = processParameters.split(PARAMETERS_SEPARATOR)) {
            int idx = envVar.indexOf(61);
            if (idx <= -1) continue;
            result.put(envVar.substring(0, idx), idx < envVar.length() - 1 ? envVar.substring(idx + 1) : "");
        }
        return result;
    }

    public static void signalizeFinish(String debuggerId, String processName) {
        ForkedDebuggerHelper.signalizeFinish(debuggerId, processName, ForkedDebuggerHelper.getPortFromProperty());
    }

    public static void signalizeFinish(String debuggerId, String processName, int dispatchPort) {
        try {
            ForkedDebuggerHelper.send(debuggerId, processName, FINISH_PARAMS, dispatchPort);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void send(String debuggerId, String processName, String processParameters, int dispatchPort) throws IOException {
        String dispatchAddr = ForkedDebuggerHelper.getAddrFromProperty();
        try (Socket socket = new Socket(dispatchAddr, dispatchPort);
             DataOutputStream stream = new DataOutputStream(socket.getOutputStream());){
            stream.writeUTF(debuggerId);
            stream.writeUTF(processName);
            stream.writeUTF(processParameters);
            int n = socket.getInputStream().read();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int findAvailableSocketPort() throws IOException {
        try (ServerSocket serverSocket = new ServerSocket(0);){
            int port = serverSocket.getLocalPort();
            ServerSocket serverSocket2 = serverSocket;
            synchronized (serverSocket2) {
                try {
                    serverSocket.wait(1L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (port <= -1) {
                throw new IOException("Failed to find available port");
            }
            int n = port;
            return n;
        }
    }

    public static String getAddrFromProperty() {
        return System.getProperty(DISPATCH_ADDR_SYS_PROP, "127.0.0.1");
    }

    private static int getPortFromProperty() {
        String property = System.getProperty(DISPATCH_PORT_SYS_PROP);
        try {
            if (property == null || property.trim().isEmpty()) {
                throw new IllegalStateException("System property 'idea.debugger.dispatch.port' is not set");
            }
            return Integer.parseInt(property);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("System property 'idea.debugger.dispatch.port' has invalid value: " + property, e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processParameters", "com/intellij/openapi/externalSystem/rt/execution/ForkedDebuggerHelper", "splitParameters"));
    }
}

