/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.mergerequest.file;

import com.intellij.collaboration.file.codereview.CodeReviewDiffVirtualFile;
import com.intellij.diff.impl.DiffEditorViewer;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileEditor.impl.EditorTabTitleProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.editor.ComplexPathVirtualFileSystem;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.api.GitLabProjectCoordinates;
import org.jetbrains.plugins.gitlab.mergerequest.file.GitLabMergeRequestDiffFileKt;
import org.jetbrains.plugins.gitlab.mergerequest.file.GitLabMergeRequestDiffService;
import org.jetbrains.plugins.gitlab.mergerequest.file.GitLabVirtualFile;
import org.jetbrains.plugins.gitlab.mergerequest.file.GitLabVirtualFileSystem;
import org.jetbrains.plugins.gitlab.util.GitLabBundle;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\b\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\"B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\u000bJ\f\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0004H\u0016J\b\u0010\u0011\u001a\u00020\u0004H\u0016J\b\u0010\u0012\u001a\u00020\u0004H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\t\u0010\u0017\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00c2\u0003J\t\u0010\u0019\u001a\u00020\bH\u00c2\u0003J\t\u0010\u001a\u001a\u00020\u0004H\u00c2\u0003J1\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u00142\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\u0004H\u00d6\u0001R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/file/GitLabMergeRequestDiffFile;", "Lcom/intellij/collaboration/file/codereview/CodeReviewDiffVirtualFile;", "Lorg/jetbrains/plugins/gitlab/mergerequest/file/GitLabVirtualFile;", "connectionId", "", "project", "Lcom/intellij/openapi/project/Project;", "glProject", "Lorg/jetbrains/plugins/gitlab/api/GitLabProjectCoordinates;", "mergeRequestIid", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/gitlab/api/GitLabProjectCoordinates;Ljava/lang/String;)V", "getConnectionId", "()Ljava/lang/String;", "getFileSystem", "Lcom/intellij/vcs/editor/ComplexPathVirtualFileSystem;", "getPath", "getPresentablePath", "getPresentableName", "isValid", "", "createViewer", "Lcom/intellij/diff/impl/DiffEditorViewer;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "hashCode", "", "toString", "TitleProvider", "intellij.vcs.gitlab"})
@SourceDebugExtension(value={"SMAP\nGitLabMergeRequestDiffFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLabMergeRequestDiffFile.kt\norg/jetbrains/plugins/gitlab/mergerequest/file/GitLabMergeRequestDiffFile\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,146:1\n30#2,2:147\n*S KotlinDebug\n*F\n+ 1 GitLabMergeRequestDiffFile.kt\norg/jetbrains/plugins/gitlab/mergerequest/file/GitLabMergeRequestDiffFile\n*L\n60#1:147,2\n*E\n"})
public final class GitLabMergeRequestDiffFile
extends CodeReviewDiffVirtualFile
implements GitLabVirtualFile {
    @NotNull
    private final String connectionId;
    @NotNull
    private final Project project;
    @NotNull
    private final GitLabProjectCoordinates glProject;
    @NotNull
    private final String mergeRequestIid;

    public GitLabMergeRequestDiffFile(@NotNull String connectionId, @NotNull Project project, @NotNull GitLabProjectCoordinates glProject, @NotNull String mergeRequestIid) {
        Intrinsics.checkNotNullParameter((Object)connectionId, (String)"connectionId");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)glProject, (String)"glProject");
        Intrinsics.checkNotNullParameter((Object)mergeRequestIid, (String)"mergeRequestIid");
        super(GitLabMergeRequestDiffFileKt.access$getFileName(mergeRequestIid));
        this.connectionId = connectionId;
        this.project = project;
        this.glProject = glProject;
        this.mergeRequestIid = mergeRequestIid;
    }

    @Override
    @NotNull
    public String getConnectionId() {
        return this.connectionId;
    }

    @NotNull
    public ComplexPathVirtualFileSystem<?> getFileSystem() {
        return GitLabVirtualFileSystem.Companion.getInstance();
    }

    @NotNull
    public String getPath() {
        ComplexPathVirtualFileSystem<?> complexPathVirtualFileSystem = this.getFileSystem();
        Intrinsics.checkNotNull(complexPathVirtualFileSystem, (String)"null cannot be cast to non-null type org.jetbrains.plugins.gitlab.mergerequest.file.GitLabVirtualFileSystem");
        return ((GitLabVirtualFileSystem)complexPathVirtualFileSystem).getPath(this.getConnectionId(), this.project, this.glProject, this.mergeRequestIid, true);
    }

    @NotNull
    public String getPresentablePath() {
        return GitLabMergeRequestDiffFileKt.access$getPresentablePath(this.glProject, this.mergeRequestIid);
    }

    @NotNull
    public String getPresentableName() {
        Object[] objectArray = new Object[]{this.mergeRequestIid};
        return GitLabBundle.message("merge.request.diff.file.name", objectArray);
    }

    public boolean isValid() {
        return GitLabMergeRequestDiffFileKt.access$isFileValid(this.project, this.getConnectionId());
    }

    @NotNull
    public DiffEditorViewer createViewer(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<GitLabMergeRequestDiffService> serviceClass$iv = GitLabMergeRequestDiffService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return ((GitLabMergeRequestDiffService)object).createGitLabDiffRequestProcessor(this.getConnectionId(), this.mergeRequestIid);
    }

    @NotNull
    public final String component1() {
        return this.connectionId;
    }

    private final Project component2() {
        return this.project;
    }

    private final GitLabProjectCoordinates component3() {
        return this.glProject;
    }

    private final String component4() {
        return this.mergeRequestIid;
    }

    @NotNull
    public final GitLabMergeRequestDiffFile copy(@NotNull String connectionId, @NotNull Project project, @NotNull GitLabProjectCoordinates glProject, @NotNull String mergeRequestIid) {
        Intrinsics.checkNotNullParameter((Object)connectionId, (String)"connectionId");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)glProject, (String)"glProject");
        Intrinsics.checkNotNullParameter((Object)mergeRequestIid, (String)"mergeRequestIid");
        return new GitLabMergeRequestDiffFile(connectionId, project, glProject, mergeRequestIid);
    }

    public static /* synthetic */ GitLabMergeRequestDiffFile copy$default(GitLabMergeRequestDiffFile gitLabMergeRequestDiffFile, String string, Project project, GitLabProjectCoordinates gitLabProjectCoordinates, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = gitLabMergeRequestDiffFile.connectionId;
        }
        if ((n & 2) != 0) {
            project = gitLabMergeRequestDiffFile.project;
        }
        if ((n & 4) != 0) {
            gitLabProjectCoordinates = gitLabMergeRequestDiffFile.glProject;
        }
        if ((n & 8) != 0) {
            string2 = gitLabMergeRequestDiffFile.mergeRequestIid;
        }
        return gitLabMergeRequestDiffFile.copy(string, project, gitLabProjectCoordinates, string2);
    }

    @NotNull
    public String toString() {
        return "GitLabMergeRequestDiffFile(connectionId=" + this.connectionId + ", project=" + this.project + ", glProject=" + this.glProject + ", mergeRequestIid=" + this.mergeRequestIid + ")";
    }

    public int hashCode() {
        int result2 = this.connectionId.hashCode();
        result2 = result2 * 31 + this.project.hashCode();
        result2 = result2 * 31 + this.glProject.hashCode();
        result2 = result2 * 31 + this.mergeRequestIid.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GitLabMergeRequestDiffFile)) {
            return false;
        }
        GitLabMergeRequestDiffFile gitLabMergeRequestDiffFile = (GitLabMergeRequestDiffFile)other;
        if (!Intrinsics.areEqual((Object)this.connectionId, (Object)gitLabMergeRequestDiffFile.connectionId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.project, (Object)gitLabMergeRequestDiffFile.project)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.glProject, (Object)gitLabMergeRequestDiffFile.glProject)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.mergeRequestIid, (Object)gitLabMergeRequestDiffFile.mergeRequestIid);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/file/GitLabMergeRequestDiffFile$TitleProvider;", "Lcom/intellij/openapi/fileEditor/impl/EditorTabTitleProvider;", "<init>", "()V", "getEditorTabTitle", "", "Lcom/intellij/openapi/util/NlsContexts$TabTitle;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.vcs.gitlab"})
    public static final class TitleProvider
    implements EditorTabTitleProvider {
        @Nullable
        public String getEditorTabTitle(@NotNull Project project, @NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return file instanceof GitLabMergeRequestDiffFile ? ((GitLabMergeRequestDiffFile)file).getPresentableName() : null;
        }
    }
}

