/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.details;

import com.intellij.collaboration.messages.CollaborationToolsBundle;
import com.intellij.collaboration.ui.CollaborationToolsUIUtil;
import com.intellij.collaboration.ui.CollaborationToolsUIUtilKt;
import com.intellij.collaboration.ui.HtmlEditorPaneUtilKt;
import com.intellij.collaboration.ui.codereview.CodeReviewProgressTreeModel;
import com.intellij.collaboration.ui.codereview.CodeReviewProgressTreeModelFromDetails;
import com.intellij.collaboration.ui.codereview.changes.CodeReviewChangeListComponentFactory;
import com.intellij.collaboration.ui.codereview.details.CodeReviewDetailsBranchComponentFactory;
import com.intellij.collaboration.ui.codereview.details.CodeReviewDetailsCommitInfoComponentFactory;
import com.intellij.collaboration.ui.codereview.details.CodeReviewDetailsCommitsComponentFactory;
import com.intellij.collaboration.ui.codereview.details.CodeReviewDetailsTitleComponentFactory;
import com.intellij.collaboration.ui.codereview.details.CommitPresentation;
import com.intellij.collaboration.ui.codereview.details.ReviewDetailsUIUtil;
import com.intellij.collaboration.ui.codereview.details.data.ReviewRequestState;
import com.intellij.collaboration.ui.codereview.details.model.CodeReviewBranchesViewModel;
import com.intellij.collaboration.ui.codereview.details.model.CodeReviewChangeListViewModel;
import com.intellij.collaboration.ui.codereview.details.model.CodeReviewChangesViewModel;
import com.intellij.collaboration.ui.codereview.details.model.CodeReviewDetailsViewModel;
import com.intellij.collaboration.ui.codereview.list.error.ErrorStatusPanelFactory;
import com.intellij.collaboration.ui.codereview.list.error.ErrorStatusPresenter;
import com.intellij.collaboration.ui.util.MigLayoutUtilKt;
import com.intellij.collaboration.ui.util.SwingBindingsKt;
import com.intellij.collaboration.util.ComputedResult;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ui.AsyncChangesTree;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.panels.Wrapper;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.data.GHCommit;
import org.jetbrains.plugins.github.api.data.GHGitActor;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.comment.GHMarkdownToHtmlConverterKt;
import org.jetbrains.plugins.github.pullrequest.ui.GHApiLoadingErrorHandler;
import org.jetbrains.plugins.github.pullrequest.ui.details.GHPRDetailsActionsComponentFactory;
import org.jetbrains.plugins.github.pullrequest.ui.details.GHPRStatusChecksComponentFactory;
import org.jetbrains.plugins.github.pullrequest.ui.details.model.GHPRChangeListViewModel;
import org.jetbrains.plugins.github.pullrequest.ui.details.model.impl.GHPRChangesViewModel;
import org.jetbrains.plugins.github.pullrequest.ui.details.model.impl.GHPRDetailsViewModel;
import org.jetbrains.plugins.github.ui.util.GHHtmlPaneUtilKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ \u0010\f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0016\u0010\u0018\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001aJ\u0014\u0010\u001b\u001a\u00020\u0005*\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0002\u00a8\u0006!"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRDetailsComponentFactory;", "", "<init>", "()V", "create", "Ljavax/swing/JComponent;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "project", "Lcom/intellij/openapi/project/Project;", "detailsVm", "Lorg/jetbrains/plugins/github/pullrequest/ui/details/model/impl/GHPRDetailsViewModel;", "createCommitsInfoComponent", "cs", "createCommitsAndBranchesComponent", "showTimelineAction", "", "parentComponent", "createCommitsPopupPresenter", "Lcom/intellij/collaboration/ui/codereview/details/CommitPresentation;", "commit", "Lorg/jetbrains/plugins/github/api/data/GHCommit;", "ghostUser", "Lorg/jetbrains/plugins/github/api/data/GHUser;", "createCommitFilesBrowserComponent", "changesVm", "Lorg/jetbrains/plugins/github/pullrequest/ui/details/model/impl/GHPRChangesViewModel;", "createChangesPanel", "changeListVm", "Lorg/jetbrains/plugins/github/pullrequest/ui/details/model/GHPRChangeListViewModel;", "createChangesErrorComponent", "error", "", "intellij.vcs.github"})
@ApiStatus.Internal
public final class GHPRDetailsComponentFactory {
    @NotNull
    public static final GHPRDetailsComponentFactory INSTANCE = new GHPRDetailsComponentFactory();

    private GHPRDetailsComponentFactory() {
    }

    @NotNull
    public final JComponent create(@NotNull CoroutineScope scope, @NotNull Project project, @NotNull GHPRDetailsViewModel detailsVm2) {
        JPanel jPanel;
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)detailsVm2, (String)"detailsVm");
        AnAction anAction = ActionManager.getInstance().getAction("Github.PullRequest.Details.Popup");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        ActionGroup actionGroup = (ActionGroup)anAction;
        CodeReviewDetailsViewModel codeReviewDetailsViewModel = detailsVm2;
        String string = GithubBundle.message("open.on.github.action", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        JComponent title = CodeReviewDetailsTitleComponentFactory.INSTANCE.create(scope, codeReviewDetailsViewModel, string, actionGroup, GHPRDetailsComponentFactory::create$lambda$0);
        String string2 = CollaborationToolsBundle.message((String)"review.details.view.timeline.action", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        ActionLink timelineLink = new ActionLink(string2, GHPRDetailsComponentFactory::create$lambda$1);
        JComponent commitsAndBranches = this.createCommitsAndBranchesComponent(project, scope, detailsVm2);
        JComponent statusChecks = GHPRStatusChecksComponentFactory.INSTANCE.create(scope, project, detailsVm2);
        JComponent actionsComponent = GHPRDetailsActionsComponentFactory.INSTANCE.create(scope, project, (Flow<? extends ReviewRequestState>)detailsVm2.getReviewRequestState(), detailsVm2.getReviewFlowVm());
        JPanel $this$create_u24lambda_u242 = jPanel = new JPanel((LayoutManager)new MigLayout(MigLayoutUtilKt.emptyBorders((LC)new LC()).fill().flowY().noGrid().hideMode(3)));
        boolean bl = false;
        $this$create_u24lambda_u242.setOpaque(false);
        Component component = ReviewDetailsUIUtil.INSTANCE.createTitlePanel(title, (JComponent)timelineLink);
        CC cC = new CC().growX();
        Intrinsics.checkNotNullExpressionValue((Object)cC, (String)"growX(...)");
        $this$create_u24lambda_u242.add(component, MigLayoutUtilKt.gap((CC)cC, (Insets)ReviewDetailsUIUtil.INSTANCE.getTITLE_GAPS()));
        Component component2 = commitsAndBranches;
        CC cC2 = new CC().growX();
        Intrinsics.checkNotNullExpressionValue((Object)cC2, (String)"growX(...)");
        $this$create_u24lambda_u242.add(component2, MigLayoutUtilKt.gap((CC)cC2, (Insets)ReviewDetailsUIUtil.INSTANCE.getCOMMIT_POPUP_BRANCHES_GAPS()));
        Component component3 = INSTANCE.createCommitsInfoComponent(project, scope, detailsVm2);
        CC cC3 = new CC().growX();
        Intrinsics.checkNotNullExpressionValue((Object)cC3, (String)"growX(...)");
        $this$create_u24lambda_u242.add(component3, MigLayoutUtilKt.gap((CC)cC3, (Insets)ReviewDetailsUIUtil.INSTANCE.getCOMMIT_INFO_GAPS()));
        $this$create_u24lambda_u242.add((Component)INSTANCE.createCommitFilesBrowserComponent(scope, detailsVm2.getChangesVm()), new CC().grow().shrinkPrioY(200));
        Component component4 = statusChecks;
        CC cC4 = new CC().growX();
        Intrinsics.checkNotNullExpressionValue((Object)cC4, (String)"growX(...)");
        $this$create_u24lambda_u242.add(component4, MigLayoutUtilKt.gap((CC)cC4, (Insets)ReviewDetailsUIUtil.INSTANCE.getSTATUSES_GAPS()).maxHeight(String.valueOf(ReviewDetailsUIUtil.INSTANCE.getSTATUSES_MAX_HEIGHT())));
        Component component5 = actionsComponent;
        CC cC5 = new CC().growX().pushX();
        Intrinsics.checkNotNullExpressionValue((Object)cC5, (String)"pushX(...)");
        $this$create_u24lambda_u242.add(component5, MigLayoutUtilKt.gap((CC)cC5, (Insets)ReviewDetailsUIUtil.INSTANCE.getACTIONS_GAPS()).minHeight("pref"));
        PopupHandler.installPopupMenu((JComponent)$this$create_u24lambda_u242, (ActionGroup)actionGroup, (String)"popup");
        return jPanel;
    }

    private final JComponent createCommitsInfoComponent(Project project, CoroutineScope cs, GHPRDetailsViewModel detailsVm2) {
        return CodeReviewDetailsCommitInfoComponentFactory.INSTANCE.create(cs, (Flow)detailsVm2.getChangesVm().getSelectedCommit(), arg_0 -> GHPRDetailsComponentFactory.createCommitsInfoComponent$lambda$3(project, detailsVm2, arg_0), () -> GHPRDetailsComponentFactory.createCommitsInfoComponent$lambda$5(detailsVm2));
    }

    @NotNull
    public final JComponent createCommitsAndBranchesComponent(@NotNull Project project, @NotNull CoroutineScope cs, @NotNull GHPRDetailsViewModel detailsVm2) {
        JPanel jPanel;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        Intrinsics.checkNotNullParameter((Object)detailsVm2, (String)"detailsVm");
        JPanel $this$createCommitsAndBranchesComponent_u24lambda_u247 = jPanel = new JPanel((LayoutManager)new MigLayout(MigLayoutUtilKt.emptyBorders((LC)new LC()).fill(), new AC().gap("push")));
        boolean bl = false;
        $this$createCommitsAndBranchesComponent_u24lambda_u247.setOpaque(false);
        $this$createCommitsAndBranchesComponent_u24lambda_u247.add(CodeReviewDetailsCommitsComponentFactory.INSTANCE.create(cs, (CodeReviewChangesViewModel)detailsVm2.getChangesVm(), arg_0 -> GHPRDetailsComponentFactory.createCommitsAndBranchesComponent$lambda$7$lambda$6(project, detailsVm2, arg_0)));
        $this$createCommitsAndBranchesComponent_u24lambda_u247.add(CodeReviewDetailsBranchComponentFactory.INSTANCE.create(cs, (CodeReviewBranchesViewModel)detailsVm2.getBranchesVm()));
        return jPanel;
    }

    private final void showTimelineAction(JComponent parentComponent) {
        AnAction anAction = ActionManager.getInstance().getAction("Github.PullRequest.Timeline.Show");
        if (anAction == null) {
            return;
        }
        AnAction action = anAction;
        ActionUtil.invokeAction((AnAction)action, (Component)parentComponent, (String)"unknown", null, null);
    }

    private final CommitPresentation createCommitsPopupPresenter(Project project, GHCommit commit, GHUser ghostUser) {
        String string = GHMarkdownToHtmlConverterKt.convertToHtml(commit.getMessageHeadline(), project);
        String string2 = GHMarkdownToHtmlConverterKt.convertToHtml(commit.getMessageBody(), project);
        Object object = commit.getAuthor();
        if (object == null || (object = ((GHGitActor)object).getUser()) == null) {
            object = ghostUser;
        }
        return new CommitPresentation(string, string2, ((GHUser)object).getPresentableName(), commit.getCommittedDate());
    }

    @NotNull
    public final JComponent createCommitFilesBrowserComponent(@NotNull CoroutineScope cs, @NotNull GHPRChangesViewModel changesVm2) {
        Wrapper wrapper;
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        Intrinsics.checkNotNullParameter((Object)changesVm2, (String)"changesVm");
        Wrapper $this$createCommitFilesBrowserComponent_u24lambda_u2412 = wrapper = new Wrapper((JComponent)CollaborationToolsUIUtilKt.LoadingLabel$default(null, (int)1, null));
        boolean bl = false;
        SwingBindingsKt.bindContentIn((Wrapper)$this$createCommitFilesBrowserComponent_u24lambda_u2412, (CoroutineScope)cs, (Flow)((Flow)changesVm2.getChangeListVm()), (arg_0, arg_1) -> GHPRDetailsComponentFactory.createCommitFilesBrowserComponent$lambda$12$lambda$11(changesVm2, arg_0, arg_1));
        return (JComponent)wrapper;
    }

    private final JComponent createChangesPanel(CoroutineScope $this$createChangesPanel, GHPRChangeListViewModel changeListVm) {
        CodeReviewProgressTreeModelFromDetails progressModel = new CodeReviewProgressTreeModelFromDetails($this$createChangesPanel, (CodeReviewChangeListViewModel.WithDetails)changeListVm);
        CodeReviewChangeListViewModel codeReviewChangeListViewModel = (CodeReviewChangeListViewModel)changeListVm;
        CodeReviewProgressTreeModel codeReviewProgressTreeModel = (CodeReviewProgressTreeModel)progressModel;
        String string = GithubBundle.message("pull.request.does.not.contain.changes", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        AsyncChangesTree tree = CodeReviewChangeListComponentFactory.INSTANCE.createIn($this$createChangesPanel, codeReviewChangeListViewModel, codeReviewProgressTreeModel, string);
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)((Component)tree), (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"createScrollPane(...)");
        JScrollPane scrollPane2 = jScrollPane;
        DataManager.registerDataProvider((JComponent)scrollPane2, arg_0 -> GHPRDetailsComponentFactory.createChangesPanel$lambda$13(tree, changeListVm, arg_0));
        AnAction anAction = ActionManager.getInstance().getAction("Github.PullRequest.Changes.Popup");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        tree.installPopupHandler((ActionGroup)anAction);
        return scrollPane2;
    }

    private final JComponent createChangesErrorComponent(GHPRChangesViewModel changesVm2, Throwable error) {
        String string = GithubBundle.message("cannot.load.changes", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ErrorStatusPresenter.Text errorPresenter2 = ErrorStatusPresenter.Companion.simple$default((ErrorStatusPresenter.Companion)ErrorStatusPresenter.Companion, (String)string, null, (Function1)((Function1)new Function1<Throwable, Action>((Object)changesVm2.getChangesLoadingErrorHandler()){

            public final Action invoke(Throwable p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((GHApiLoadingErrorHandler)this.receiver).getActionForError(p0);
            }
        }), (int)2, null);
        JComponent errorPanel2 = ErrorStatusPanelFactory.create$default((ErrorStatusPanelFactory)ErrorStatusPanelFactory.INSTANCE, (Object)error, (ErrorStatusPresenter)((ErrorStatusPresenter)errorPresenter2), null, (int)4, null);
        return CollaborationToolsUIUtil.INSTANCE.moveToCenter(errorPanel2);
    }

    private static final JEditorPane create$lambda$0() {
        return HtmlEditorPaneUtilKt.SimpleHtmlPane$default(null, (boolean)false, null, null, null, (int)31, null);
    }

    private static final Unit create$lambda$1(ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = it.getSource();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.JComponent");
        INSTANCE.showTimelineAction((JComponent)object);
        return Unit.INSTANCE;
    }

    private static final CommitPresentation createCommitsInfoComponent$lambda$3(Project $project, GHPRDetailsViewModel $detailsVm, GHCommit commit) {
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
        return INSTANCE.createCommitsPopupPresenter($project, commit, $detailsVm.getSecurityService().getGhostUser());
    }

    private static final JEditorPane createCommitsInfoComponent$lambda$5(GHPRDetailsViewModel $detailsVm) {
        JEditorPane jEditorPane;
        JEditorPane $this$createCommitsInfoComponent_u24lambda_u245_u24lambda_u244 = jEditorPane = HtmlEditorPaneUtilKt.SimpleHtmlPane$default(null, (boolean)false, null, null, null, (int)29, null);
        boolean bl = false;
        GHHtmlPaneUtilKt.addGithubHyperlinkListener($this$createCommitsInfoComponent_u24lambda_u245_u24lambda_u244, (Function1<? super Long, Unit>)((Function1)new Function1<Long, Unit>((Object)$detailsVm){

            public final void invoke(long p0) {
                ((GHPRDetailsViewModel)this.receiver).openPullRequestInfoAndTimeline(p0);
            }
        }));
        return jEditorPane;
    }

    private static final CommitPresentation createCommitsAndBranchesComponent$lambda$7$lambda$6(Project $project, GHPRDetailsViewModel $detailsVm, GHCommit commit) {
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
        return INSTANCE.createCommitsPopupPresenter($project, commit, $detailsVm.getSecurityService().getGhostUser());
    }

    private static final JComponent createCommitFilesBrowserComponent$lambda$12$lambda$11(GHPRChangesViewModel $changesVm, CoroutineScope $this$bindContentIn, ComputedResult res) {
        Object object;
        block6: {
            block5: {
                JComponent jComponent;
                Intrinsics.checkNotNullParameter((Object)$this$bindContentIn, (String)"$this$bindContentIn");
                object = res.unbox-impl();
                if (object == null) break block5;
                Object it = object.unbox-impl();
                boolean bl = false;
                Object object2 = it;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                if (throwable == null) {
                    GHPRChangeListViewModel it2 = (GHPRChangeListViewModel)object2;
                    boolean bl2 = false;
                    jComponent = INSTANCE.createChangesPanel($this$bindContentIn, it2);
                } else {
                    Throwable it3 = throwable;
                    boolean bl3 = false;
                    jComponent = INSTANCE.createChangesErrorComponent($changesVm, it3);
                }
                object = jComponent;
                if (jComponent != null) break block6;
            }
            object = CollaborationToolsUIUtilKt.LoadingLabel$default(null, (int)1, null);
        }
        return object;
    }

    private static final Object createChangesPanel$lambda$13(AsyncChangesTree $tree, GHPRChangeListViewModel $changeListVm, String dataId) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        if ($tree.isShowing()) {
            if ((GHPRChangeListViewModel.Companion.getDATA_KEY().is(dataId) ? $changeListVm : (object = CodeReviewChangeListViewModel.Companion.getDATA_KEY().is(dataId) ? $changeListVm : null)) == null) {
                object = $tree.getData(dataId);
            }
        } else {
            object = null;
        }
        return object;
    }
}

