/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.ide.inspection.grammar.quickfix;

import com.intellij.codeInsight.intention.CustomizableIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.ide.fus.GrazieFUSCounter;
import com.intellij.grazie.ide.inspection.grammar.quickfix.GrazieAddExceptionQuickFix;
import com.intellij.grazie.ide.ui.components.dsl.SwingKTKt;
import com.intellij.grazie.ide.ui.grammar.GrazieConfigurable;
import com.intellij.grazie.text.Rule;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\b\u0012\u0004\u0012\u00020\u00050\u0004B\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0007H\u0016J\b\u0010\u0013\u001a\u00020\u0007H\u0016J\b\u0010\u0014\u001a\u00020\rH\u0016J\u0011\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0005H\u0096\u0002J$\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/grazie/ide/inspection/grammar/quickfix/GrazieRuleSettingsAction;", "Lcom/intellij/codeInspection/IntentionAndQuickFixAction;", "Lcom/intellij/openapi/util/Iconable;", "Lcom/intellij/codeInsight/intention/CustomizableIntentionAction;", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "ruleName", "", "rule", "Lcom/intellij/grazie/text/Rule;", "<init>", "(Ljava/lang/String;Lcom/intellij/grazie/text/Rule;)V", "isShowSubmenu", "", "getIcon", "Ljavax/swing/Icon;", "flags", "", "getName", "getFamilyName", "startInWriteAction", "compareTo", "other", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "psiFile", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "analyzeStateChange", "state1", "Lcom/intellij/grazie/GrazieConfig$State;", "state2", "intellij.grazie.core"})
public final class GrazieRuleSettingsAction
extends IntentionAndQuickFixAction
implements Iconable,
CustomizableIntentionAction,
Comparable<IntentionAction> {
    @NotNull
    private final String ruleName;
    @NotNull
    private final Rule rule;

    public GrazieRuleSettingsAction(@NotNull String ruleName, @NotNull Rule rule) {
        Intrinsics.checkNotNullParameter((Object)ruleName, (String)"ruleName");
        Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
        this.ruleName = ruleName;
        this.rule = rule;
    }

    public boolean isShowSubmenu() {
        return false;
    }

    @NotNull
    public Icon getIcon(int flags) {
        Icon icon = AllIcons.Actions.Edit;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Edit");
        return icon;
    }

    @NotNull
    public String getName() {
        String[] stringArray = new String[]{this.ruleName};
        return SwingKTKt.msg("grazie.grammar.quickfix.open.rule.text", stringArray);
    }

    @NotNull
    public String getFamilyName() {
        return SwingKTKt.msg("grazie.grammar.quickfix.open.rule.family", new String[0]);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public int compareTo(@NotNull IntentionAction other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return other instanceof GrazieAddExceptionQuickFix ? 1 : 0;
    }

    public void applyFix(@NotNull Project project, @Nullable PsiFile psiFile, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GrazieConfig.State state1 = GrazieConfig.Companion.get();
        boolean ok = false;
        Navigatable navigatable = this.rule.editSettings();
        if (navigatable != null && navigatable.canNavigate()) {
            navigatable.navigate(true);
            ok = true;
        } else {
            GrazieConfigurable configurable = new GrazieConfigurable();
            String string = this.rule.getGlobalId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getGlobalId(...)");
            configurable.selectRule$intellij_grazie_core(string);
            ok = ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable);
        }
        String result = !ok ? "canceled" : this.analyzeStateChange(state1, GrazieConfig.Companion.get());
        GrazieFUSCounter.INSTANCE.settingsUpdated("rule.settings:" + result, this.rule, project);
    }

    private final String analyzeStateChange(GrazieConfig.State state1, GrazieConfig.State state2) {
        if (Intrinsics.areEqual((Object)state1, (Object)state2)) {
            return "unmodified";
        }
        ArrayList<String> changes = new ArrayList<String>();
        if (state1.getCheckingContext().languagesDiffer(state2.getCheckingContext())) {
            changes.add("languages");
        }
        if (state1.getCheckingContext().domainsDiffer(state2.getCheckingContext())) {
            changes.add("domains");
        }
        if (!Intrinsics.areEqual(state1.getUserDisabledRules(), state2.getUserDisabledRules()) || !Intrinsics.areEqual(state1.getUserEnabledRules(), state2.getUserEnabledRules())) {
            changes.add("rules");
        }
        if (changes.isEmpty()) {
            changes.add("unclassified");
        }
        return "changes:" + CollectionsKt.joinToString$default((Iterable)changes, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
    }
}

