/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.security;

import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.security.ExitCallHook;
import org.assertj.swing.security.NoExitSecurityManager;

public class NoExitSecurityManagerInstaller {
    private final SecurityManager oldManager = System.getSecurityManager();

    @Nonnull
    public static NoExitSecurityManagerInstaller installNoExitSecurityManager() {
        return new NoExitSecurityManagerInstaller(new NoExitSecurityManager());
    }

    @Nonnull
    public static NoExitSecurityManagerInstaller installNoExitSecurityManager(@Nonnull ExitCallHook hook) {
        return new NoExitSecurityManagerInstaller(new NoExitSecurityManager(hook));
    }

    private NoExitSecurityManagerInstaller(@Nonnull NoExitSecurityManager newManager) {
        System.setSecurityManager(newManager);
    }

    public void uninstall() {
        System.setSecurityManager(this.oldManager);
    }
}

