/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions.ref;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.vcs.git.shared.actions.GitSingleRefActions;
import git4idea.GitLocalBranch;
import git4idea.GitReference;
import git4idea.GitTag;
import git4idea.actions.branch.GitBranchActionsDataKeys;
import git4idea.actions.branch.GitBranchActionsUtil;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRefUtil;
import git4idea.repo.GitRepository;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KClasses;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\b&\u0018\u0000 '*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001'B\u001a\u0012\u0011\u0010\u0004\u001a\r\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J3\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u001dJ3\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dJ#\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00028\u00002\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0014\u00a2\u0006\u0002\u0010\"J%\u0010#\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002\u00a2\u0006\u0002\u0010$J1\u0010%\u001a\u00020 2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001a2\b\u0010!\u001a\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0002\u0010&R \u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0094\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006("}, d2={"Lgit4idea/actions/ref/GitSingleRefAction;", "T", "Lgit4idea/GitReference;", "Lcom/intellij/openapi/project/DumbAwareAction;", "dynamicText", "Ljava/util/function/Supplier;", "", "Lcom/intellij/openapi/util/NlsActions$ActionText;", "<init>", "(Ljava/util/function/Supplier;)V", "refClass", "Lkotlin/reflect/KClass;", "getRefClass$annotations", "()V", "getRefClass", "()Lkotlin/reflect/KClass;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "reference", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;Lcom/intellij/openapi/project/Project;Ljava/util/List;Lgit4idea/GitReference;)V", "updateIfEnabledAndVisible", "isEnabledForRef", "", "ref", "(Lgit4idea/GitReference;Ljava/util/List;)Z", "getRef", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;Ljava/util/List;)Lgit4idea/GitReference;", "isEnabledAndVisible", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Lgit4idea/GitReference;)Z", "Companion", "intellij.vcs.git"})
public abstract class GitSingleRefAction<T extends GitReference>
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KClass<T> refClass;

    public GitSingleRefAction(@NotNull Supplier<String> dynamicText) {
        Intrinsics.checkNotNullParameter(dynamicText, (String)"dynamicText");
        super(dynamicText);
        this.refClass = Reflection.getOrCreateKotlinClass(GitReference.class);
    }

    @NotNull
    protected KClass<T> getRefClass() {
        return this.refClass;
    }

    protected static /* synthetic */ void getRefClass$annotations() {
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public final void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        List<GitRepository> repositories = GitBranchActionsUtil.getAffectedRepositories(e);
        T ref = this.getRef(e, repositories);
        e.getPresentation().setEnabledAndVisible(this.isEnabledAndVisible(project, repositories, ref));
        DvcsUtil.disableActionIfAnyRepositoryIsFresh((AnActionEvent)e, (Collection)repositories, (String)GitBundle.message("action.not.possible.in.fresh.repo.generic", new Object[0]));
        if (e.getPresentation().isEnabledAndVisible()) {
            Project project2 = project;
            Intrinsics.checkNotNull((Object)project2);
            T t = ref;
            Intrinsics.checkNotNull(t);
            this.updateIfEnabledAndVisible(e, project2, repositories, t);
        }
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        List<GitRepository> repositories = GitBranchActionsUtil.getAffectedRepositories(e);
        T t = this.getRef(e, repositories);
        if (t == null) {
            return;
        }
        T ref = t;
        this.actionPerformed(e, project2, repositories, ref);
    }

    public abstract void actionPerformed(@NotNull AnActionEvent var1, @NotNull Project var2, @NotNull List<? extends GitRepository> var3, @NotNull T var4);

    public void updateIfEnabledAndVisible(@NotNull AnActionEvent e, @NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull T reference) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        Intrinsics.checkNotNullParameter(reference, (String)"reference");
    }

    protected boolean isEnabledForRef(@NotNull T ref, @NotNull List<? extends GitRepository> repositories) {
        Intrinsics.checkNotNullParameter(ref, (String)"ref");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        return true;
    }

    private final T getRef(AnActionEvent e, List<? extends GitRepository> repositories) {
        GitReference explicitRefFromCtx = (GitReference)e.getData(GitSingleRefActions.SELECTED_REF_DATA_KEY);
        GitReference gitReference = explicitRefFromCtx;
        if (gitReference == null) {
            if (Intrinsics.areEqual((Object)e.getData(GitBranchActionsDataKeys.USE_CURRENT_BRANCH), (Object)true)) {
                GitRepository gitRepository = (GitRepository)CollectionsKt.singleOrNull(repositories);
                gitReference = gitRepository != null ? gitRepository.getCurrentBranch() : null;
            } else {
                gitReference = null;
            }
        }
        GitReference ref = gitReference;
        return (T)((GitReference)KClasses.safeCast(this.getRefClass(), (Object)ref));
    }

    private final boolean isEnabledAndVisible(Project project, List<? extends GitRepository> repositories, T ref) {
        Collection collection;
        return project == null || (collection = (Collection)repositories) == null || collection.isEmpty() || ref == null ? false : this.isEnabledForRef(ref, repositories);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0000\u00a2\u0006\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lgit4idea/actions/ref/GitSingleRefAction$Companion;", "", "<init>", "()V", "isCurrentRefInAnyRepo", "", "ref", "Lgit4idea/GitReference;", "repositories", "", "Lgit4idea/repo/GitRepository;", "isCurrentRefInAnyRepo$intellij_vcs_git", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitSingleRefAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitSingleRefAction.kt\ngit4idea/actions/ref/GitSingleRefAction$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n1761#2,3:85\n*S KotlinDebug\n*F\n+ 1 GitSingleRefAction.kt\ngit4idea/actions/ref/GitSingleRefAction$Companion\n*L\n75#1:85,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isCurrentRefInAnyRepo$intellij_vcs_git(@NotNull GitReference ref, @NotNull List<? extends GitRepository> repositories) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
                Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
                Iterable $this$any$iv = repositories;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        GitRepository it = (GitRepository)element$iv;
                        boolean bl2 = false;
                        GitReference gitReference = ref;
                        boolean bl3 = gitReference instanceof GitLocalBranch ? Intrinsics.areEqual((Object)it.getCurrentBranch(), (Object)ref) : (gitReference instanceof GitTag ? it.getState() == Repository.State.DETACHED && Intrinsics.areEqual((Object)GitRefUtil.getCurrentReference(it), (Object)ref) : false);
                        if (!bl3) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

