/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.settings;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvFormats;
import com.intellij.database.csv.CsvFormatter;
import com.intellij.database.csv.ui.preview.TableAndTextCsvFormatPreview;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.CsvDocumentDataHookUp;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridAppearance;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridPresentationMode;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.run.ui.DataGridRequestPlace;
import com.intellij.database.run.ui.grid.GridColorsScheme;
import com.intellij.database.settings.AppearanceComponents;
import com.intellij.database.settings.DataGridAppearanceConfigurableKt;
import com.intellij.database.settings.DataGridAppearanceSettings;
import com.intellij.database.settings.DataGridAppearanceSettingsImpl;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.options.BoundSearchableConfigurable;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TopGap;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0005H\u0016J\b\u0010\u0010\u001a\u00020\u000eH\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/settings/DataGridAppearanceConfigurable;", "Lcom/intellij/openapi/options/BoundSearchableConfigurable;", "<init>", "()V", "isResetting", "", "components", "Lcom/intellij/database/settings/AppearanceComponents;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "useCustomFont", "getUseCustomFont", "()Z", "apply", "", "isModified", "reset", "updateGrid", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "Companion", "intellij.grid.impl"})
public final class DataGridAppearanceConfigurable
extends BoundSearchableConfigurable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isResetting;
    private AppearanceComponents components;
    private DataGrid grid;
    @NotNull
    public static final String ID = "database.data.views.appearance";

    public DataGridAppearanceConfigurable() {
        String string = IdeBundle.message((String)"configurable.DatabaseSettingsConfigurable.DataViews.display.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super(string, "preferences.database.dataViews", ID);
    }

    private final boolean getUseCustomFont() {
        AppearanceComponents appearanceComponents = this.components;
        if (appearanceComponents == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"components");
            appearanceComponents = null;
        }
        return ((JBCheckBox)appearanceComponents.getUseCustomFontCell().getComponent()).isSelected();
    }

    public void apply() {
        super.apply();
        AppearanceComponents appearanceComponents = this.components;
        if (appearanceComponents == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"components");
            appearanceComponents = null;
        }
        appearanceComponents.getCustomFontOptionsPanel().apply(this.getUseCustomFont());
        DataGridAppearanceSettingsImpl.fireSettingsChanged();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isModified() {
        if (super.isModified()) return true;
        AppearanceComponents appearanceComponents = this.components;
        if (appearanceComponents == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"components");
            appearanceComponents = null;
        }
        if (!appearanceComponents.getCustomFontOptionsPanel().isModified(this.getUseCustomFont())) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        try {
            this.isResetting = true;
            super.reset();
            AppearanceComponents appearanceComponents = this.components;
            if (appearanceComponents == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"components");
                appearanceComponents = null;
            }
            appearanceComponents.getCustomFontOptionsPanel().reset();
            this.updateGrid();
        }
        finally {
            this.isResetting = false;
        }
    }

    private final void updateGrid() {
        AppearanceComponents appearanceComponents = this.components;
        if (appearanceComponents == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"components");
            appearanceComponents = null;
        }
        boolean striped = ((JBCheckBox)appearanceComponents.isStripeRowsCheckBox().getComponent()).isSelected();
        DataGrid dataGrid = this.grid;
        if (dataGrid == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"grid");
            dataGrid = null;
        }
        dataGrid.getAppearance().setResultViewStriped(striped);
        DataGrid dataGrid2 = this.grid;
        if (dataGrid2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"grid");
            dataGrid2 = null;
        }
        DataGridAppearance dataGridAppearance = dataGrid2.getAppearance();
        AppearanceComponents appearanceComponents2 = this.components;
        if (appearanceComponents2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"components");
            appearanceComponents2 = null;
        }
        dataGridAppearance.setBooleanMode((DataGridAppearanceSettings.BooleanMode)((ComboBox)appearanceComponents2.getBooleanMode().getComponent()).getItem());
        DataGrid dataGrid3 = this.grid;
        if (dataGrid3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"grid");
            dataGrid3 = null;
        }
        dataGrid3.getAppearance().setResultViewSetShowHorizontalLines(!striped);
        DataGrid dataGrid4 = this.grid;
        if (dataGrid4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"grid");
            dataGrid4 = null;
        }
        GridColorsScheme gridColorsScheme = dataGrid4.getColorsScheme();
        boolean bl = this.getUseCustomFont();
        AppearanceComponents appearanceComponents3 = this.components;
        if (appearanceComponents3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"components");
            appearanceComponents3 = null;
        }
        gridColorsScheme.updateFromScheme(bl, appearanceComponents3.getCustomFontOptionsPanel().getScheme());
        DataGrid dataGrid5 = this.grid;
        if (dataGrid5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"grid");
            dataGrid5 = null;
        }
        dataGrid5.getResultView().reinitSettings();
        DataGrid dataGrid6 = this.grid;
        if (dataGrid6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"grid");
            dataGrid6 = null;
        }
        dataGrid6.getPanel().getComponent().revalidate();
        DataGrid dataGrid7 = this.grid;
        if (dataGrid7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"grid");
            dataGrid7 = null;
        }
        dataGrid7.getPanel().getComponent().repaint();
    }

    @NotNull
    public DialogPanel createPanel() {
        DataGridAppearanceSettings settings = DataGridAppearanceSettings.getSettings();
        DialogPanel panel2 = BuilderKt.panel(arg_0 -> DataGridAppearanceConfigurable.createPanel$lambda$5(this, settings, arg_0));
        return panel2;
    }

    private static final boolean createPanel$lambda$5$lambda$0(DataGridAppearanceConfigurable this$0) {
        return this$0.isResetting;
    }

    private static final Unit createPanel$lambda$5$lambda$1(DataGridAppearanceConfigurable this$0) {
        this$0.updateGrid();
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$5$lambda$4$lambda$2(DataGrid grid, DataGridAppearance appearance) {
        appearance.setResultViewVisibleRowCount(8);
        grid.getPanel().getComponent().setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)1));
        return Unit.INSTANCE;
    }

    private static final void createPanel$lambda$5$lambda$4$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit createPanel$lambda$5$lambda$4(DataGridAppearanceConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Project project = DefaultProjectFactory.getInstance().getDefaultProject();
        CsvFormat csvFormat = CsvFormatter.setFirstRowIsHeader((CsvFormat)((CsvFormat)CsvFormats.CSV_FORMAT.getValue()), (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)csvFormat, (String)"setFirstRowIsHeader(...)");
        CsvFormat format = csvFormat;
        Document document = EditorFactory.getInstance().createDocument((CharSequence)TableAndTextCsvFormatPreview.formatData(format));
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"createDocument(...)");
        Document document2 = document;
        CsvDocumentDataHookUp hookUp = new CsvDocumentDataHookUp(project, format, document2, null);
        Disposable disposable = this$0.getDisposable();
        Intrinsics.checkNotNull((Object)disposable);
        Disposable disposable2 = disposable;
        Disposer.register((Disposable)disposable2, (Disposable)((Disposable)hookUp));
        DataGrid dataGrid = GridUtil.createPreviewDataGrid(project, (GridDataHookUp<GridRow, GridColumn>)((GridDataHookUp)hookUp), GridUtil.configureCsvTable().andThen((arg_0, arg_1) -> DataGridAppearanceConfigurable.createPanel$lambda$5$lambda$4$lambda$3(DataGridAppearanceConfigurable::createPanel$lambda$5$lambda$4$lambda$2, arg_0, arg_1)));
        Intrinsics.checkNotNullExpressionValue((Object)dataGrid, (String)"createPreviewDataGrid(...)");
        this$0.grid = dataGrid;
        DataGrid dataGrid2 = this$0.grid;
        if (dataGrid2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"grid");
            dataGrid2 = null;
        }
        dataGrid2.setPresentationMode(GridPresentationMode.TABLE);
        DataGrid dataGrid3 = this$0.grid;
        if (dataGrid3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"grid");
            dataGrid3 = null;
        }
        Disposer.register((Disposable)disposable2, (Disposable)((Disposable)dataGrid3));
        DataGrid dataGrid4 = this$0.grid;
        if (dataGrid4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"grid");
            dataGrid4 = null;
        }
        JBLoadingPanel jBLoadingPanel = dataGrid4.getPanel().getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jBLoadingPanel, (String)"getComponent(...)");
        Disposer.register((Disposable)disposable2, (Disposable)((Disposable)UiNotifyConnector.Once.Companion.installOn((Component)jBLoadingPanel, new Activatable(this$0, hookUp){
            final /* synthetic */ DataGridAppearanceConfigurable this$0;
            final /* synthetic */ CsvDocumentDataHookUp $hookUp;
            {
                this.this$0 = $receiver;
                this.$hookUp = $hookUp;
            }

            public void showNotify() {
                DataGrid dataGrid = DataGridAppearanceConfigurable.access$getGrid$p(this.this$0);
                if (dataGrid == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"grid");
                    dataGrid = null;
                }
                GridRequestSource source = new GridRequestSource((GridRequestSource.RequestPlace)new DataGridRequestPlace((CoreGrid)dataGrid));
                this.$hookUp.getLoader().loadFirstPage(source);
            }
        })));
        DataGrid dataGrid5 = this$0.grid;
        if (dataGrid5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"grid");
            dataGrid5 = null;
        }
        JBLoadingPanel jBLoadingPanel2 = dataGrid5.getPanel().getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jBLoadingPanel2, (String)"getComponent(...)");
        $this$row.cell((JComponent)jBLoadingPanel2).align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$5(DataGridAppearanceConfigurable this$0, DataGridAppearanceSettings $settings, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Intrinsics.checkNotNull((Object)$settings);
        this$0.components = DataGridAppearanceConfigurableKt.produceAppearanceSettings($this$panel, $settings, (Function0<Boolean>)((Function0)() -> DataGridAppearanceConfigurable.createPanel$lambda$5$lambda$0(this$0)), (Function0<Unit>)((Function0)() -> DataGridAppearanceConfigurable.createPanel$lambda$5$lambda$1(this$0)));
        Panel.row$default((Panel)$this$panel, null, arg_0 -> DataGridAppearanceConfigurable.createPanel$lambda$5$lambda$4(this$0, arg_0), (int)1, null).topGap(TopGap.MEDIUM);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ DataGrid access$getGrid$p(DataGridAppearanceConfigurable $this) {
        return $this.grid;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/settings/DataGridAppearanceConfigurable$Companion;", "", "<init>", "()V", "ID", "", "intellij.grid.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

