/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes.membersManager;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.refactoring.classes.PyClassRefactoringUtil;
import com.jetbrains.python.refactoring.classes.membersManager.MembersManager;
import com.jetbrains.python.refactoring.classes.membersManager.PyMemberInfo;
import com.jetbrains.python.refactoring.classes.membersManager.PyUsageInfo;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PyMembersRefactoringBaseProcessor
extends BaseRefactoringProcessor
implements UsageViewDescriptor {
    @NotNull
    protected final Collection<PyMemberInfo<PyElement>> myMembersToMove;
    @NotNull
    protected final PyClass myFrom;
    private final PyClass @NotNull [] myTo;

    protected PyMembersRefactoringBaseProcessor(@NotNull Project project, @NotNull Collection<PyMemberInfo<PyElement>> membersToMove, @NotNull PyClass from, PyClass ... to) {
        if (project == null) {
            PyMembersRefactoringBaseProcessor.$$$reportNull$$$0(0);
        }
        if (membersToMove == null) {
            PyMembersRefactoringBaseProcessor.$$$reportNull$$$0(1);
        }
        if (from == null) {
            PyMembersRefactoringBaseProcessor.$$$reportNull$$$0(2);
        }
        if (to == null) {
            PyMembersRefactoringBaseProcessor.$$$reportNull$$$0(3);
        }
        super(project);
        this.myFrom = from;
        this.myMembersToMove = new ArrayList<PyMemberInfo<PyElement>>(membersToMove);
        this.myTo = (PyClass[])to.clone();
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            PyMembersRefactoringBaseProcessor.$$$reportNull$$$0(4);
        }
        PyMembersRefactoringBaseProcessor pyMembersRefactoringBaseProcessor = this;
        if (pyMembersRefactoringBaseProcessor == null) {
            PyMembersRefactoringBaseProcessor.$$$reportNull$$$0(5);
        }
        return pyMembersRefactoringBaseProcessor;
    }

    public PsiElement @NotNull [] getElements() {
        PsiElement[] psiElementArray = (PsiElement[])this.myTo.clone();
        if (psiElementArray == null) {
            PyMembersRefactoringBaseProcessor.$$$reportNull$$$0(6);
        }
        return psiElementArray;
    }

    protected final PyUsageInfo @NotNull [] findUsages() {
        ArrayList<PyUsageInfo> result2 = new ArrayList<PyUsageInfo>(this.myTo.length);
        for (PyClass pyDestinationClass : this.myTo) {
            result2.add(new PyUsageInfo(pyDestinationClass));
        }
        PyUsageInfo[] pyUsageInfoArray = result2.toArray(new PyUsageInfo[0]);
        if (pyUsageInfoArray == null) {
            PyMembersRefactoringBaseProcessor.$$$reportNull$$$0(7);
        }
        return pyUsageInfoArray;
    }

    protected final void performRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            PyMembersRefactoringBaseProcessor.$$$reportNull$$$0(8);
        }
        ArrayList<PyClass> destinations = new ArrayList<PyClass>(usages.length);
        for (UsageInfo usage : usages) {
            if (!(usage instanceof PyUsageInfo)) {
                throw new IllegalArgumentException("Only PyUsageInfo is accepted here");
            }
            destinations.add(((PyUsageInfo)usage).getTo());
        }
        MembersManager.moveAllMembers(this.myMembersToMove, this.myFrom, destinations.toArray(PyClass.EMPTY_ARRAY));
        PyClassRefactoringUtil.optimizeImports(this.myFrom.getContainingFile());
    }

    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData data = new RefactoringEventData();
        data.addElement((PsiElement)this.myFrom);
        data.addMembers((Object[])this.myMembersToMove.toArray(new PyMemberInfo[0]), info -> info.getMember());
        return data;
    }

    @Nullable
    protected RefactoringEventData getAfterData(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            PyMembersRefactoringBaseProcessor.$$$reportNull$$$0(9);
        }
        RefactoringEventData data = new RefactoringEventData();
        data.addElements((PsiElement[])this.myTo);
        return data;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "membersToMove";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/classes/membersManager/PyMembersRefactoringBaseProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/classes/membersManager/PyMembersRefactoringBaseProcessor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAfterData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

