/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.authentication;

import com.intellij.collaboration.auth.Account;
import com.intellij.collaboration.auth.ui.login.LoginModel;
import com.intellij.collaboration.auth.ui.login.TokenLoginDialog;
import com.intellij.collaboration.auth.ui.login.TokenLoginInputPanelFactory;
import com.intellij.collaboration.auth.ui.login.TokenLoginPanelModel;
import com.intellij.collaboration.messages.CollaborationToolsBundle;
import com.intellij.collaboration.ui.codereview.list.error.ErrorStatusPresenter;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.api.GitLabServerPath;
import org.jetbrains.plugins.gitlab.api.GitLabServerPathKt;
import org.jetbrains.plugins.gitlab.authentication.GitLabLoginCollector;
import org.jetbrains.plugins.gitlab.authentication.GitLabLoginData;
import org.jetbrains.plugins.gitlab.authentication.GitLabLoginErrorStatusPresenter;
import org.jetbrains.plugins.gitlab.authentication.GitLabLoginSource;
import org.jetbrains.plugins.gitlab.authentication.GitLabSecurityUtil;
import org.jetbrains.plugins.gitlab.authentication.LoginResult;
import org.jetbrains.plugins.gitlab.authentication.accounts.GitLabAccount;
import org.jetbrains.plugins.gitlab.authentication.accounts.GitLabProjectDefaultAccountHolder;
import org.jetbrains.plugins.gitlab.authentication.ui.GitLabChooseAccountDialog;
import org.jetbrains.plugins.gitlab.authentication.ui.GitLabTokenLoginPanelModel;
import org.jetbrains.plugins.gitlab.ui.util.GitLabPluginProjectScopeProvider;
import org.jetbrains.plugins.gitlab.util.GitLabBundle;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JF\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fH\u0007JW\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00102\u0006\u0010\f\u001a\u00020\r2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fH\u0001\u00a2\u0006\u0002\b\u0013JD\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\r2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fH\u0007JU\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00102\u0006\u0010\f\u001a\u00020\r2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fH\u0001\u00a2\u0006\u0002\b\u0017J7\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001a\u001a\u00020\u001b2\u000b\u0010\u001c\u001a\u00070\u0010\u00a2\u0006\u0002\b\u001d2\u0006\u0010\u001e\u001a\u00020\u0011H\u0003J>\u0010\u001f\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010 2\r\u0010!\u001a\t\u0018\u00010\u0010\u00a2\u0006\u0002\b\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00160$H\u0001\u00a2\u0006\u0002\b%J$\u0010&\u001a\u00020\u00112\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00160$2\u0006\u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u0010\u00a8\u0006)"}, d2={"Lorg/jetbrains/plugins/gitlab/authentication/GitLabLoginUtil;", "", "<init>", "()V", "logInViaToken", "Lorg/jetbrains/plugins/gitlab/authentication/LoginResult;", "project", "Lcom/intellij/openapi/project/Project;", "parentComponent", "Ljavax/swing/JComponent;", "serverPath", "Lorg/jetbrains/plugins/gitlab/api/GitLabServerPath;", "loginSource", "Lorg/jetbrains/plugins/gitlab/authentication/GitLabLoginSource;", "uniqueAccountPredicate", "Lkotlin/Function2;", "", "", "requiredUsername", "logInViaToken$intellij_vcs_gitlab", "updateToken", "account", "Lorg/jetbrains/plugins/gitlab/authentication/accounts/GitLabAccount;", "updateToken$intellij_vcs_gitlab", "showLoginDialog", "", "model", "Lorg/jetbrains/plugins/gitlab/authentication/ui/GitLabTokenLoginPanelModel;", "title", "Lcom/intellij/openapi/util/NlsContexts$DialogTitle;", "serverFieldDisabled", "chooseAccount", "Ljava/awt/Component;", "description", "Lorg/jetbrains/annotations/Nls;", "accounts", "", "chooseAccount$intellij_vcs_gitlab", "isAccountUnique", "server", "username", "intellij.vcs.gitlab"})
@SourceDebugExtension(value={"SMAP\nGitLabLoginUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLabLoginUtil.kt\norg/jetbrains/plugins/gitlab/authentication/GitLabLoginUtil\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,155:1\n19#2:156\n30#3,2:157\n30#3,2:159\n2746#4,3:161\n*S KotlinDebug\n*F\n+ 1 GitLabLoginUtil.kt\norg/jetbrains/plugins/gitlab/authentication/GitLabLoginUtil\n*L\n54#1:156\n112#1:157,2\n138#1:159,2\n148#1:161,3\n*E\n"})
public final class GitLabLoginUtil {
    @NotNull
    public static final GitLabLoginUtil INSTANCE = new GitLabLoginUtil();

    private GitLabLoginUtil() {
    }

    @ApiStatus.Internal
    @RequiresEdt
    @NotNull
    public final LoginResult logInViaToken(@NotNull Project project, @Nullable JComponent parentComponent, @NotNull GitLabServerPath serverPath, @NotNull GitLabLoginSource loginSource, @NotNull Function2<? super GitLabServerPath, ? super String, Boolean> uniqueAccountPredicate) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)serverPath, (String)"serverPath");
        Intrinsics.checkNotNullParameter((Object)((Object)loginSource), (String)"loginSource");
        Intrinsics.checkNotNullParameter(uniqueAccountPredicate, (String)"uniqueAccountPredicate");
        return this.logInViaToken$intellij_vcs_gitlab(project, parentComponent, serverPath, null, loginSource, uniqueAccountPredicate);
    }

    public static /* synthetic */ LoginResult logInViaToken$default(GitLabLoginUtil gitLabLoginUtil, Project project, JComponent jComponent, GitLabServerPath gitLabServerPath, GitLabLoginSource gitLabLoginSource, Function2 function2, int n, Object object) {
        if ((n & 4) != 0) {
            gitLabServerPath = GitLabServerPath.Companion.getDEFAULT_SERVER();
        }
        return gitLabLoginUtil.logInViaToken(project, jComponent, gitLabServerPath, gitLabLoginSource, (Function2<? super GitLabServerPath, ? super String, Boolean>)function2);
    }

    @RequiresEdt
    @NotNull
    public final LoginResult logInViaToken$intellij_vcs_gitlab(@NotNull Project project, @Nullable JComponent parentComponent, @NotNull GitLabServerPath serverPath, @Nullable String requiredUsername, @NotNull GitLabLoginSource loginSource, @NotNull Function2<? super GitLabServerPath, ? super String, Boolean> uniqueAccountPredicate) {
        LoginResult loginResult2;
        GitLabTokenLoginPanelModel gitLabTokenLoginPanelModel;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)serverPath, (String)"serverPath");
        Intrinsics.checkNotNullParameter((Object)((Object)loginSource), (String)"loginSource");
        Intrinsics.checkNotNullParameter(uniqueAccountPredicate, (String)"uniqueAccountPredicate");
        GitLabTokenLoginPanelModel $this$logInViaToken_u24lambda_u240 = gitLabTokenLoginPanelModel = new GitLabTokenLoginPanelModel(requiredUsername, uniqueAccountPredicate);
        boolean bl = false;
        $this$logInViaToken_u24lambda_u240.setServerUri(serverPath.getUri());
        GitLabTokenLoginPanelModel model = gitLabTokenLoginPanelModel;
        String dialogTitle = GitLabBundle.message("account.add.dialog.title", new Object[0]);
        int exitCode = this.showLoginDialog(project, parentComponent, model, dialogTitle, false);
        switch (exitCode) {
            case 0: {
                Object $this$asSafely$iv = model.getLoginState().getValue();
                boolean $i$f$asSafely = false;
                Object object = $this$asSafely$iv;
                if (!(object instanceof LoginModel.LoginState.Connected)) {
                    object = null;
                }
                LoginModel.LoginState.Connected connected = (LoginModel.LoginState.Connected)object;
                if (connected == null) {
                    return LoginResult.Failure.INSTANCE;
                }
                LoginModel.LoginState.Connected loginResult3 = connected;
                GitLabLoginData loginData = new GitLabLoginData(loginSource, false, serverPath.isDefault());
                GitLabLoginCollector.INSTANCE.login(loginData);
                return new LoginResult.Success(new GitLabAccount(null, loginResult3.getUsername(), model.getServerPath(), 1, null), model.getToken());
            }
            case 2: {
                loginResult2 = LoginResult.OtherMethod.INSTANCE;
                break;
            }
            default: {
                loginResult2 = LoginResult.Failure.INSTANCE;
            }
        }
        return loginResult2;
    }

    public static /* synthetic */ LoginResult logInViaToken$intellij_vcs_gitlab$default(GitLabLoginUtil gitLabLoginUtil, Project project, JComponent jComponent, GitLabServerPath gitLabServerPath, String string, GitLabLoginSource gitLabLoginSource, Function2 function2, int n, Object object) {
        if ((n & 4) != 0) {
            gitLabServerPath = GitLabServerPath.Companion.getDEFAULT_SERVER();
        }
        if ((n & 8) != 0) {
            string = null;
        }
        return gitLabLoginUtil.logInViaToken$intellij_vcs_gitlab(project, jComponent, gitLabServerPath, string, gitLabLoginSource, (Function2<? super GitLabServerPath, ? super String, Boolean>)function2);
    }

    @ApiStatus.Internal
    @RequiresEdt
    @NotNull
    public final LoginResult updateToken(@NotNull Project project, @Nullable JComponent parentComponent, @NotNull GitLabAccount account, @NotNull GitLabLoginSource loginSource, @NotNull Function2<? super GitLabServerPath, ? super String, Boolean> uniqueAccountPredicate) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)account), (String)"account");
        Intrinsics.checkNotNullParameter((Object)((Object)loginSource), (String)"loginSource");
        Intrinsics.checkNotNullParameter(uniqueAccountPredicate, (String)"uniqueAccountPredicate");
        return this.updateToken$intellij_vcs_gitlab(project, parentComponent, account, null, loginSource, uniqueAccountPredicate);
    }

    @RequiresEdt
    @NotNull
    public final LoginResult updateToken$intellij_vcs_gitlab(@NotNull Project project, @Nullable JComponent parentComponent, @NotNull GitLabAccount account, @Nullable String requiredUsername, @NotNull GitLabLoginSource loginSource, @NotNull Function2<? super GitLabServerPath, ? super String, Boolean> uniqueAccountPredicate) {
        GitLabTokenLoginPanelModel gitLabTokenLoginPanelModel;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)account), (String)"account");
        Intrinsics.checkNotNullParameter((Object)((Object)loginSource), (String)"loginSource");
        Intrinsics.checkNotNullParameter(uniqueAccountPredicate, (String)"uniqueAccountPredicate");
        Function2 predicateWithoutCurrent = (arg_0, arg_1) -> GitLabLoginUtil.updateToken$lambda$1(account, uniqueAccountPredicate, arg_0, arg_1);
        GitLabTokenLoginPanelModel $this$updateToken_u24lambda_u242 = gitLabTokenLoginPanelModel = new GitLabTokenLoginPanelModel(requiredUsername, (Function2<? super GitLabServerPath, ? super String, Boolean>)predicateWithoutCurrent);
        boolean bl = false;
        $this$updateToken_u24lambda_u242.setServerUri(account.getServer().getUri());
        GitLabTokenLoginPanelModel model = gitLabTokenLoginPanelModel;
        String title = GitLabBundle.message("account.update.dialog.title", new Object[0]);
        int exitState = this.showLoginDialog(project, parentComponent, model, title, true);
        LoginModel.LoginState loginState = (LoginModel.LoginState)model.getLoginState().getValue();
        if (exitState == 0 && loginState instanceof LoginModel.LoginState.Connected) {
            GitLabLoginData loginData = new GitLabLoginData(loginSource, true, model.getServerPath().isDefault());
            GitLabLoginCollector.INSTANCE.login(loginData);
            return new LoginResult.Success(new GitLabAccount(account.getId(), ((LoginModel.LoginState.Connected)loginState).getUsername(), model.getServerPath()), model.getToken());
        }
        return LoginResult.Failure.INSTANCE;
    }

    public static /* synthetic */ LoginResult updateToken$intellij_vcs_gitlab$default(GitLabLoginUtil gitLabLoginUtil, Project project, JComponent jComponent, GitLabAccount gitLabAccount, String string, GitLabLoginSource gitLabLoginSource, Function2 function2, int n, Object object) {
        if ((n & 8) != 0) {
            string = null;
        }
        return gitLabLoginUtil.updateToken$intellij_vcs_gitlab(project, jComponent, gitLabAccount, string, gitLabLoginSource, (Function2<? super GitLabServerPath, ? super String, Boolean>)function2);
    }

    @RequiresEdt
    private final int showLoginDialog(Project project, JComponent parentComponent, GitLabTokenLoginPanelModel model, String title, boolean serverFieldDisabled) {
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<GitLabPluginProjectScopeProvider> serviceClass$iv = GitLabPluginProjectScopeProvider.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        GitLabPluginProjectScopeProvider scopeProvider = (GitLabPluginProjectScopeProvider)((Object)object);
        TokenLoginDialog dialog = (TokenLoginDialog)scopeProvider.constructDialog("GitLab token login dialog", arg_0 -> GitLabLoginUtil.showLoginDialog$lambda$4(project, parentComponent, model, title, serverFieldDisabled, arg_0));
        dialog.showAndGet();
        return dialog.getExitCode();
    }

    @RequiresEdt
    @Nullable
    public final GitLabAccount chooseAccount$intellij_vcs_gitlab(@NotNull Project project, @Nullable Component parentComponent, @Nullable String description, @NotNull Collection<GitLabAccount> accounts) {
        GitLabAccount gitLabAccount;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(accounts, (String)"accounts");
        GitLabChooseAccountDialog dialog = new GitLabChooseAccountDialog(project, parentComponent, accounts, false, true, null, description, null, 160, null);
        if (dialog.showAndGet()) {
            GitLabAccount account = dialog.getAccount();
            if (dialog.getSetDefault()) {
                ComponentManager $this$service$iv = (ComponentManager)project;
                boolean $i$f$service = false;
                Class<GitLabProjectDefaultAccountHolder> serviceClass$iv = GitLabProjectDefaultAccountHolder.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                ((GitLabProjectDefaultAccountHolder)((Object)object)).setAccount((Account)account);
            }
            gitLabAccount = account;
        } else {
            gitLabAccount = null;
        }
        return gitLabAccount;
    }

    public final boolean isAccountUnique(@NotNull Collection<GitLabAccount> accounts, @NotNull GitLabServerPath server, @NotNull String username) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(accounts, (String)"accounts");
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)username, (String)"username");
            Iterable $this$none$iv = accounts;
            boolean $i$f$none = false;
            if (((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    GitLabAccount it = (GitLabAccount)((Object)element$iv);
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)GitLabServerPathKt.toHttpsNormalizedURI(it.getServer()), (Object)GitLabServerPathKt.toHttpsNormalizedURI(server)) && Intrinsics.areEqual((Object)it.getName(), (Object)username))) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final boolean updateToken$lambda$1(GitLabAccount $account, Function2 $uniqueAccountPredicate, GitLabServerPath serverPath, String username) {
        Intrinsics.checkNotNullParameter((Object)serverPath, (String)"serverPath");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        return Intrinsics.areEqual((Object)serverPath, (Object)$account.getServer()) && Intrinsics.areEqual((Object)username, (Object)$account.getName()) ? true : (Boolean)$uniqueAccountPredicate.invoke((Object)serverPath, (Object)username);
    }

    private static final DialogPanel showLoginDialog$lambda$4$lambda$3(GitLabTokenLoginPanelModel $model, boolean $serverFieldDisabled, CoroutineScope $this$TokenLoginDialog) {
        Intrinsics.checkNotNullParameter((Object)$this$TokenLoginDialog, (String)"$this$TokenLoginDialog");
        CoroutineScope cs = $this$TokenLoginDialog;
        Object[] objectArray = new Object[]{GitLabSecurityUtil.INSTANCE.getMASTER_SCOPES()};
        return TokenLoginInputPanelFactory.createIn$default((TokenLoginInputPanelFactory)new TokenLoginInputPanelFactory((TokenLoginPanelModel)$model), (CoroutineScope)cs, (boolean)$serverFieldDisabled, (String)CollaborationToolsBundle.message((String)"clone.dialog.insufficient.scopes", (Object[])objectArray), (ErrorStatusPresenter)((ErrorStatusPresenter)new GitLabLoginErrorStatusPresenter(cs, $model)), null, (int)16, null);
    }

    private static final TokenLoginDialog showLoginDialog$lambda$4(Project $project, JComponent $parentComponent, GitLabTokenLoginPanelModel $model, String $title, boolean $serverFieldDisabled, CoroutineScope $this$constructDialog) {
        Intrinsics.checkNotNullParameter((Object)$this$constructDialog, (String)"$this$constructDialog");
        return new TokenLoginDialog($project, $this$constructDialog, (Component)$parentComponent, (LoginModel)$model, $title, $model.getTryGitAuthorizationSignal(), arg_0 -> GitLabLoginUtil.showLoginDialog$lambda$4$lambda$3($model, $serverFieldDisabled, arg_0));
    }
}

