/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.collection.IntObjectMap;
import androidx.collection.MutableIntList;
import androidx.collection.MutableIntObjectMap;
import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.ArcMode;
import androidx.compose.animation.core.DurationBasedAnimationSpec;
import androidx.compose.animation.core.Easing;
import androidx.compose.animation.core.EasingKt;
import androidx.compose.animation.core.KeyframeBaseEntity;
import androidx.compose.animation.core.KeyframesSpecBaseConfig;
import androidx.compose.animation.core.TwoWayConverter;
import androidx.compose.animation.core.VectorizedKeyframeSpecElementInfo;
import androidx.compose.animation.core.VectorizedKeyframesSpec;
import androidx.compose.runtime.Immutable;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0002\u000f\u0010B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J,\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u000b0\n\"\b\b\u0001\u0010\u000b*\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u000b0\u000eH\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Landroidx/compose/animation/core/KeyframesSpec;", "T", "Landroidx/compose/animation/core/DurationBasedAnimationSpec;", "config", "Landroidx/compose/animation/core/KeyframesSpec$KeyframesSpecConfig;", "<init>", "(Landroidx/compose/animation/core/KeyframesSpec$KeyframesSpecConfig;)V", "getConfig", "()Landroidx/compose/animation/core/KeyframesSpec$KeyframesSpecConfig;", "vectorize", "Landroidx/compose/animation/core/VectorizedKeyframesSpec;", "V", "Landroidx/compose/animation/core/AnimationVector;", "converter", "Landroidx/compose/animation/core/TwoWayConverter;", "KeyframesSpecConfig", "KeyframeEntity", "animation-core"})
@Immutable
@SourceDebugExtension(value={"SMAP\nAnimationSpec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnimationSpec.kt\nandroidx/compose/animation/core/KeyframesSpec\n+ 2 IntObjectMap.kt\nandroidx/collection/IntObjectMap\n+ 3 ScatterMap.kt\nandroidx/collection/ScatterMapKt\n*L\n1#1,1072:1\n382#2,4:1073\n354#2,6:1077\n364#2,3:1084\n367#2,9:1088\n386#2:1097\n425#2:1098\n425#2:1099\n1399#3:1083\n1270#3:1087\n*S KotlinDebug\n*F\n+ 1 AnimationSpec.kt\nandroidx/compose/animation/core/KeyframesSpec\n*L\n644#1:1073,4\n644#1:1077,6\n644#1:1084,3\n644#1:1088,9\n644#1:1097\n654#1:1098\n657#1:1099\n644#1:1083\n644#1:1087\n*E\n"})
public final class KeyframesSpec<T>
implements DurationBasedAnimationSpec<T> {
    @NotNull
    private final KeyframesSpecConfig<T> config;
    public static final int $stable;

    public KeyframesSpec(@NotNull KeyframesSpecConfig<T> config2) {
        Intrinsics.checkNotNullParameter(config2, (String)"config");
        this.config = config2;
    }

    @NotNull
    public final KeyframesSpecConfig<T> getConfig() {
        return this.config;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <V extends AnimationVector> VectorizedKeyframesSpec<V> vectorize(@NotNull TwoWayConverter<T, V> converter) {
        Intrinsics.checkNotNullParameter(converter, (String)"converter");
        MutableIntList timestamps = new MutableIntList(this.config.getKeyframes$animation_core().getSize() + 2);
        MutableIntObjectMap timeToInfoMap = new MutableIntObjectMap(this.config.getKeyframes$animation_core().getSize());
        IntObjectMap this_$iv = this.config.getKeyframes$animation_core();
        boolean $i$f$forEach = false;
        int[] k$iv = this_$iv.keys;
        Object[] v$iv = this_$iv.values;
        IntObjectMap this_$iv$iv = this_$iv;
        boolean $i$f$forEachIndexed = false;
        long[] m$iv$iv = this_$iv$iv.metadata;
        int lastIndex$iv$iv = m$iv$iv.length - 2;
        int i$iv$iv = 0;
        if (i$iv$iv <= lastIndex$iv$iv) {
            while (true) {
                long slot$iv$iv;
                long $this$maskEmptyOrDeleted$iv$iv$iv = slot$iv$iv = m$iv$iv[i$iv$iv];
                boolean $i$f$maskEmptyOrDeleted = false;
                if (($this$maskEmptyOrDeleted$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                    int bitCount$iv$iv = 8 - (~(i$iv$iv - lastIndex$iv$iv) >>> 31);
                    for (int j$iv$iv = 0; j$iv$iv < bitCount$iv$iv; ++j$iv$iv) {
                        long value$iv$iv$iv = slot$iv$iv & 0xFFL;
                        boolean $i$f$isFull = false;
                        if (value$iv$iv$iv < 128L) {
                            void value;
                            int index$iv$iv;
                            int index$iv = index$iv$iv = (i$iv$iv << 3) + j$iv$iv;
                            boolean bl = false;
                            KeyframeEntity keyframeEntity = (KeyframeEntity)v$iv[index$iv];
                            int key = k$iv[index$iv];
                            boolean bl2 = false;
                            timestamps.add(key);
                            timeToInfoMap.set(key, new VectorizedKeyframeSpecElementInfo((AnimationVector)converter.getConvertToVector().invoke(value.getValue$animation_core()), value.getEasing$animation_core(), value.getArcMode--9T-Mq4$animation_core(), null));
                        }
                        slot$iv$iv >>= 8;
                    }
                    if (bitCount$iv$iv != 8) break;
                }
                if (i$iv$iv == lastIndex$iv$iv) break;
                ++i$iv$iv;
            }
        }
        this_$iv = this.config.getKeyframes$animation_core();
        int key$iv = 0;
        boolean $i$f$contains = false;
        if (!this_$iv.containsKey(key$iv)) {
            timestamps.add(0, 0);
        }
        this_$iv = this.config.getKeyframes$animation_core();
        key$iv = this.config.getDurationMillis();
        $i$f$contains = false;
        if (!this_$iv.containsKey(key$iv)) {
            timestamps.add(this.config.getDurationMillis());
        }
        timestamps.sort();
        return new VectorizedKeyframesSpec(timestamps, timeToInfoMap, this.config.getDurationMillis(), this.config.getDelayMillis(), EasingKt.getLinearEasing(), ArcMode.Companion.getArcLinear--9T-Mq4(), null);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0007\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B%\b\u0000\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u001c\u0010\u0006\u001a\u00020\u0007X\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000e\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Landroidx/compose/animation/core/KeyframesSpec$KeyframeEntity;", "T", "Landroidx/compose/animation/core/KeyframeBaseEntity;", "value", "easing", "Landroidx/compose/animation/core/Easing;", "arcMode", "Landroidx/compose/animation/core/ArcMode;", "<init>", "(Ljava/lang/Object;Landroidx/compose/animation/core/Easing;ILkotlin/jvm/internal/DefaultConstructorMarker;)V", "getArcMode--9T-Mq4$animation_core", "()I", "setArcMode-Rur9ykg$animation_core", "(I)V", "I", "equals", "", "other", "", "hashCode", "", "animation-core"})
    @StabilityInferred(parameters=0)
    public static final class KeyframeEntity<T>
    extends KeyframeBaseEntity<T> {
        private int arcMode;
        public static final int $stable = 8;

        private KeyframeEntity(T value, Easing easing, int arcMode) {
            Intrinsics.checkNotNullParameter((Object)easing, (String)"easing");
            super(value, easing, null);
            this.arcMode = arcMode;
        }

        public /* synthetic */ KeyframeEntity(Object object, Easing easing, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                easing = EasingKt.getLinearEasing();
            }
            if ((n2 & 4) != 0) {
                n = ArcMode.Companion.getArcLinear--9T-Mq4();
            }
            this(object, easing, n, null);
        }

        public final int getArcMode--9T-Mq4$animation_core() {
            return this.arcMode;
        }

        public final void setArcMode-Rur9ykg$animation_core(int n) {
            this.arcMode = n;
        }

        public boolean equals(@Nullable Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof KeyframeEntity)) {
                return false;
            }
            return Intrinsics.areEqual(((KeyframeEntity)other).getValue$animation_core(), this.getValue$animation_core()) && Intrinsics.areEqual((Object)((KeyframeEntity)other).getEasing$animation_core(), (Object)this.getEasing$animation_core()) && ArcMode.equals-impl0(((KeyframeEntity)other).arcMode, this.arcMode);
        }

        public int hashCode() {
            Object t = this.getValue$animation_core();
            int result2 = t != null ? t.hashCode() : 0;
            result2 = 31 * result2 + ArcMode.hashCode-impl(this.arcMode);
            result2 = 31 * result2 + this.getEasing$animation_core().hashCode();
            return result2;
        }

        public /* synthetic */ KeyframeEntity(Object value, Easing easing, int arcMode, DefaultConstructorMarker $constructor_marker) {
            this(value, easing, arcMode);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000*\u0004\b\u0001\u0010\u00012\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u00032\u0006\u0010\u0007\u001a\u00028\u0001H\u0010\u00a2\u0006\u0004\b\b\u0010\tJ\"\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003*\u00028\u00012\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0096\u0004\u00a2\u0006\u0002\u0010\rJ\"\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003*\u00028\u00012\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0096\u0004\u00a2\u0006\u0002\u0010\u0011J\u001b\u0010\u0012\u001a\u00020\u0013*\b\u0012\u0004\u0012\u00028\u00010\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0087\u0004J(\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003*\b\u0012\u0004\u0012\u00028\u00010\u00032\u0006\u0010\u0017\u001a\u00020\u0018H\u0086\u0004\u00a2\u0006\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Landroidx/compose/animation/core/KeyframesSpec$KeyframesSpecConfig;", "T", "Landroidx/compose/animation/core/KeyframesSpecBaseConfig;", "Landroidx/compose/animation/core/KeyframesSpec$KeyframeEntity;", "<init>", "()V", "createEntityFor", "value", "createEntityFor$animation_core", "(Ljava/lang/Object;)Landroidx/compose/animation/core/KeyframesSpec$KeyframeEntity;", "at", "timeStamp", "", "(Ljava/lang/Object;I)Landroidx/compose/animation/core/KeyframesSpec$KeyframeEntity;", "atFraction", "fraction", "", "(Ljava/lang/Object;F)Landroidx/compose/animation/core/KeyframesSpec$KeyframeEntity;", "with", "", "easing", "Landroidx/compose/animation/core/Easing;", "using", "arcMode", "Landroidx/compose/animation/core/ArcMode;", "using-ngzHuyU", "(Landroidx/compose/animation/core/KeyframesSpec$KeyframeEntity;I)Landroidx/compose/animation/core/KeyframesSpec$KeyframeEntity;", "animation-core"})
    @StabilityInferred(parameters=0)
    @SourceDebugExtension(value={"SMAP\nAnimationSpec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnimationSpec.kt\nandroidx/compose/animation/core/KeyframesSpec$KeyframesSpecConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n*L\n1#1,1072:1\n1#2:1073\n26#3:1074\n*S KotlinDebug\n*F\n+ 1 AnimationSpec.kt\nandroidx/compose/animation/core/KeyframesSpec$KeyframesSpecConfig\n*L\n594#1:1074\n*E\n"})
    public static final class KeyframesSpecConfig<T>
    extends KeyframesSpecBaseConfig<T, KeyframeEntity<T>> {
        public static final int $stable = 8;

        public KeyframesSpecConfig() {
            super(null);
        }

        @Override
        @NotNull
        public KeyframeEntity<T> createEntityFor$animation_core(T value) {
            return new KeyframeEntity(value, null, 0, 6, null);
        }

        @Override
        @NotNull
        public KeyframeEntity<T> at(T $this$at, @IntRange(from=0L) int timeStamp) {
            KeyframeEntity keyframeEntity;
            KeyframeEntity it = keyframeEntity = new KeyframeEntity($this$at, null, 0, 6, null);
            boolean bl = false;
            this.getKeyframes$animation_core().set(timeStamp, it);
            return keyframeEntity;
        }

        @Override
        @NotNull
        public KeyframeEntity<T> atFraction(T $this$atFraction, @FloatRange(from=0.0, to=1.0) float fraction) {
            float $this$fastRoundToInt$iv = (float)this.getDurationMillis() * fraction;
            boolean $i$f$fastRoundToInt = false;
            return this.at((Object)$this$atFraction, Math.round($this$fastRoundToInt$iv));
        }

        @Deprecated(message="Use version that returns an instance of the entity so it can be re-used in other keyframe builders.", replaceWith=@ReplaceWith(expression="this using easing", imports={}))
        public final void with(@NotNull KeyframeEntity<T> $this$with, @NotNull Easing easing) {
            Intrinsics.checkNotNullParameter($this$with, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)easing, (String)"easing");
            $this$with.setEasing$animation_core(easing);
        }

        @NotNull
        public final KeyframeEntity<T> using-ngzHuyU(@NotNull KeyframeEntity<T> $this$using_u2dngzHuyU, int arcMode) {
            Intrinsics.checkNotNullParameter($this$using_u2dngzHuyU, (String)"$this$using");
            $this$using_u2dngzHuyU.setArcMode-Rur9ykg$animation_core(arcMode);
            return $this$using_u2dngzHuyU;
        }
    }
}

