/*
 * Decompiled with CFR 0.152.
 */
package coil3.util;

import coil3.annotation.InternalCoilApi;
import coil3.util.MimeTypesKt;
import coil3.util.MimeTypes_nonAndroidKt;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\u0005\u00a8\u0006\t"}, d2={"Lcoil3/util/MimeTypeMap;", "", "<init>", "()V", "getMimeTypeFromUrl", "", "url", "getMimeTypeFromExtension", "extension", "coil-core"})
@InternalCoilApi
public final class MimeTypeMap {
    @NotNull
    public static final MimeTypeMap INSTANCE = new MimeTypeMap();

    private MimeTypeMap() {
    }

    @Nullable
    public final String getMimeTypeFromUrl(@NotNull String url) {
        if (StringsKt.isBlank((CharSequence)url)) {
            return null;
        }
        String extension = StringsKt.substringAfterLast((String)StringsKt.substringAfterLast$default((String)StringsKt.substringBeforeLast$default((String)StringsKt.substringBeforeLast$default((String)url, (char)'#', null, (int)2, null), (char)'?', null, (int)2, null), (char)'/', null, (int)2, null), (char)'.', (String)"");
        return this.getMimeTypeFromExtension(extension);
    }

    @Nullable
    public final String getMimeTypeFromExtension(@NotNull String extension) {
        if (StringsKt.isBlank((CharSequence)extension)) {
            return null;
        }
        String string = extension.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String lowerExtension = string;
        String string2 = (String)MimeTypesKt.access$getMimeTypeData$p().get(lowerExtension);
        if (string2 == null) {
            string2 = MimeTypes_nonAndroidKt.extensionFromMimeTypeMap(lowerExtension);
        }
        return string2;
    }
}

