/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.basic.algorithm;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.pfl.basic.contain.Pair;
import org.glassfish.pfl.basic.func.BinaryFunction;
import org.glassfish.pfl.basic.func.UnaryFunction;
import org.glassfish.pfl.basic.func.UnaryPredicate;

public final class Algorithms {
    private static Set<String> annotationMethods = new HashSet<String>();

    private Algorithms() {
    }

    public static <T> List<T> list(T ... arg) {
        return Arrays.asList(arg);
    }

    public static <S, T> Pair<S, T> pair(S first, T second) {
        return new Pair<S, T>(first, second);
    }

    public static <K, V> Map<K, V> map(Pair<K, V> ... pairs) {
        HashMap<K, V> result = new HashMap<K, V>();
        for (Pair<K, V> pair : pairs) {
            result.put(pair.first(), pair.second());
        }
        return result;
    }

    public static <A, R> UnaryFunction<A, R> mapToFunction(final Map<A, R> map) {
        return new UnaryFunction<A, R>(){

            @Override
            public R evaluate(A arg) {
                return map.get(arg);
            }
        };
    }

    public static <A, R> void map(Collection<A> arg, Collection<R> result, UnaryFunction<A, R> func) {
        for (A a : arg) {
            R newArg = func.evaluate(a);
            if (newArg == null) continue;
            result.add(newArg);
        }
    }

    public static <K, A, R> Map<K, R> map(Map<K, A> arg, UnaryFunction<A, R> func) {
        HashMap<K, R> result = new HashMap<K, R>();
        for (Map.Entry<K, A> entry : arg.entrySet()) {
            result.put(entry.getKey(), func.evaluate(entry.getValue()));
        }
        return result;
    }

    public static <A, R> List<R> map(List<A> arg, UnaryFunction<A, R> func) {
        ArrayList result = new ArrayList();
        Algorithms.map(arg, result, func);
        return result;
    }

    public static <A> UnaryPredicate<A> and(final UnaryPredicate<A> arg1, final UnaryPredicate<A> arg2) {
        return new UnaryPredicate<A>(){

            @Override
            public boolean evaluate(A arg) {
                return arg1.evaluate(arg) && arg2.evaluate(arg);
            }
        };
    }

    public static <A> UnaryPredicate<A> or(final UnaryPredicate<A> arg1, final UnaryPredicate<A> arg2) {
        return new UnaryPredicate<A>(){

            @Override
            public boolean evaluate(A arg) {
                return arg1.evaluate(arg) || arg2.evaluate(arg);
            }
        };
    }

    public static <T> UnaryPredicate<T> FALSE(Class<T> cls) {
        return new UnaryPredicate<T>(){

            @Override
            public boolean evaluate(T arg) {
                return false;
            }
        };
    }

    public static <T> UnaryPredicate<T> TRUE(Class<T> cls) {
        return new UnaryPredicate<T>(){

            @Override
            public boolean evaluate(T arg) {
                return true;
            }
        };
    }

    public static <A> UnaryPredicate<A> not(final UnaryPredicate<A> arg1) {
        return new UnaryPredicate<A>(){

            @Override
            public boolean evaluate(A arg) {
                return !arg1.evaluate(arg);
            }
        };
    }

    public static <A> void filter(List<A> arg, List<A> result, final UnaryPredicate<A> predicate) {
        UnaryFunction filter = new UnaryFunction<A, A>(){

            @Override
            public A evaluate(A arg) {
                return predicate.evaluate(arg) ? arg : null;
            }
        };
        Algorithms.map(arg, result, filter);
    }

    public static <A> List<A> filter(List<A> arg, UnaryPredicate<A> predicate) {
        ArrayList result = new ArrayList();
        Algorithms.filter(arg, result, predicate);
        return result;
    }

    public static <A> A find(List<A> arg, UnaryPredicate<A> predicate) {
        for (A a : arg) {
            if (!predicate.evaluate(a)) continue;
            return a;
        }
        return null;
    }

    public static <A, R> R fold(List<A> list, R initial, BinaryFunction<R, A, R> func) {
        R result = initial;
        for (A elem : list) {
            result = func.evaluate(result, elem);
        }
        return result;
    }

    public static <S, T> List<T> flatten(List<S> list, final UnaryFunction<S, List<T>> map) {
        return Algorithms.fold(list, new ArrayList(), new BinaryFunction<List<T>, S, List<T>>(){

            @Override
            public List<T> evaluate(List<T> arg1, S arg2) {
                arg1.addAll((Collection)map.evaluate(arg2));
                return arg1;
            }
        });
    }

    public static <T> T getFirst(Collection<T> list, Runnable handleEmptyList) {
        Iterator<T> iterator = list.iterator();
        if (iterator.hasNext()) {
            T element = iterator.next();
            return element;
        }
        handleEmptyList.run();
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List convertToList(Object arg) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (arg == null) return result;
        Class<?> cls = arg.getClass();
        if (cls.isArray()) {
            Class<?> cclass = cls.getComponentType();
            if (cclass.equals(Integer.TYPE)) {
                for (int elem : (int[])arg) {
                    result.add(elem);
                }
                return result;
            } else if (cclass.equals(Byte.TYPE)) {
                for (byte elem : (byte[])arg) {
                    result.add(elem);
                }
                return result;
            } else if (cclass.equals(Boolean.TYPE)) {
                for (boolean elem : (boolean[])arg) {
                    result.add(elem);
                }
                return result;
            } else if (cclass.equals(Character.TYPE)) {
                for (char elem : (char[])arg) {
                    result.add(Character.valueOf(elem));
                }
                return result;
            } else if (cclass.equals(Short.TYPE)) {
                for (short elem : (short[])arg) {
                    result.add(elem);
                }
                return result;
            } else if (cclass.equals(Long.TYPE)) {
                for (long elem : (long[])arg) {
                    result.add(elem);
                }
                return result;
            } else if (cclass.equals(Float.TYPE)) {
                for (float elem : (float[])arg) {
                    result.add(Float.valueOf(elem));
                }
                return result;
            } else {
                if (!cclass.equals(Double.TYPE)) return Arrays.asList((Object[])arg);
                for (double elem : (double[])arg) {
                    result.add(elem);
                }
            }
            return result;
        } else {
            result.add(arg);
            return result;
        }
    }

    public static String convertToString(Object arg) {
        if (arg == null) {
            return "<NULL>";
        }
        Class<?> cls = arg.getClass();
        if (cls.isArray()) {
            Class<?> cclass = cls.getComponentType();
            if (cclass.equals(Integer.TYPE)) {
                return Arrays.toString((int[])arg);
            }
            if (cclass.equals(Byte.TYPE)) {
                return Arrays.toString((byte[])arg);
            }
            if (cclass.equals(Boolean.TYPE)) {
                return Arrays.toString((boolean[])arg);
            }
            if (cclass.equals(Character.TYPE)) {
                return Arrays.toString((char[])arg);
            }
            if (cclass.equals(Short.TYPE)) {
                return Arrays.toString((short[])arg);
            }
            if (cclass.equals(Long.TYPE)) {
                return Arrays.toString((long[])arg);
            }
            if (cclass.equals(Float.TYPE)) {
                return Arrays.toString((float[])arg);
            }
            if (cclass.equals(Double.TYPE)) {
                return Arrays.toString((double[])arg);
            }
            return Arrays.toString((Object[])arg);
        }
        return arg.toString();
    }

    private static List<Method> getDeclaredMethods(final Class<?> cls) {
        SecurityManager sman = System.getSecurityManager();
        if (sman == null) {
            return Arrays.asList(cls.getDeclaredMethods());
        }
        return AccessController.doPrivileged(new PrivilegedAction<List<Method>>(){

            @Override
            public List<Method> run() {
                return Arrays.asList(cls.getDeclaredMethods());
            }
        });
    }

    public static Map<String, Object> getAnnotationValues(Annotation ann, boolean convertArraysToLists) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Method m : Algorithms.getDeclaredMethods(ann.getClass())) {
            String name = m.getName();
            if (annotationMethods.contains(name)) continue;
            Object value = null;
            try {
                value = m.invoke((Object)ann, new Object[0]);
            }
            catch (Exception ex) {
                Logger.getLogger(Algorithms.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (value != null) {
                Class<?> valueClass = value.getClass();
                if (valueClass.isAnnotation()) {
                    value = Algorithms.getAnnotationValues((Annotation)value, convertArraysToLists);
                } else if (convertArraysToLists && valueClass.isArray()) {
                    value = Algorithms.convertToList(value);
                }
            }
            result.put(name, value);
        }
        return result;
    }

    private static <T> PrivilegedAction<T> makePrivilegedAction(final Action<T> act) {
        return new PrivilegedAction<T>(){

            @Override
            public T run() {
                try {
                    return act.run();
                }
                catch (RuntimeException exc) {
                    throw exc;
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
    }

    public static <T> T doPrivileged(Action<T> func) {
        SecurityManager sman = System.getSecurityManager();
        try {
            if (sman == null) {
                return func.run();
            }
            return AccessController.doPrivileged(Algorithms.makePrivilegedAction(func));
        }
        catch (RuntimeException rex) {
            throw rex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        for (Method m : Algorithms.getDeclaredMethods(Annotation.class)) {
            annotationMethods.add(m.getName());
        }
    }

    public static interface Action<T> {
        public T run() throws Exception;
    }
}

