/*
 * Decompiled with CFR 0.152.
 */
package org.coode.mdock;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import org.coode.mdock.Node;
import org.coode.mdock.SplitterNode;

public class Util {
    public static int getX(Node node, Component c, boolean includeSplitter) {
        int x = (int)Math.round(node.getGloballyNormalisedXLocation() * (double)c.getWidth());
        if (includeSplitter) {
            x += 3;
        }
        return x;
    }

    public static int getY(Node node, Component c, boolean includeSplitter) {
        int y = (int)Math.round(node.getGloballyNormalisedYLocation() * (double)c.getHeight());
        if (includeSplitter) {
            y += 3;
        }
        return y;
    }

    public static int getWidth(Node node, Component c, boolean includeSplitter) {
        int w = (int)Math.round(node.getGloballyNormalisedWidth() * (double)c.getWidth());
        if (includeSplitter) {
            w -= 6;
        }
        return w;
    }

    public static int getHeight(Node node, Component c, boolean includeSplitter) {
        int h = (int)Math.round(node.getGloballyNormalisedHeight() * (double)c.getHeight());
        if (includeSplitter) {
            h -= 6;
        }
        return h;
    }

    public static Rectangle getBounds(Node node, Component c, boolean includeSplitter) {
        return new Rectangle(Util.getX(node, c, includeSplitter), Util.getY(node, c, includeSplitter), Util.getWidth(node, c, includeSplitter), Util.getHeight(node, c, includeSplitter));
    }

    public static SplitterNode getDeepestSplitterNode(SplitterNode rootNode, Component c, Point pt) {
        SplitterNode deepestNode = null;
        Rectangle bounds = Util.getBounds(rootNode, c, false);
        if (bounds.contains(pt)) {
            deepestNode = rootNode;
            for (Node curChild : rootNode.getVisibleChildren()) {
                SplitterNode n;
                if (!(curChild instanceof SplitterNode) || (n = Util.getDeepestSplitterNode((SplitterNode)curChild, c, pt)) == null) continue;
                return n;
            }
        } else {
            return null;
        }
        return deepestNode;
    }

    public static Node getDeepestNode(Node rootNode, Component c, Point pt) {
        Node deepestNode = null;
        Rectangle bounds = Util.getBounds(rootNode, c, false);
        if (bounds.contains(pt)) {
            deepestNode = rootNode;
            if (rootNode instanceof SplitterNode) {
                for (Node curChild : ((SplitterNode)rootNode).getVisibleChildren()) {
                    Node n = Util.getDeepestNode(curChild, c, pt);
                    if (n == null) continue;
                    return n;
                }
            }
        }
        return deepestNode;
    }

    public static void bringToFront(JComponent component) {
        Container child = component;
        for (Container parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof JTabbedPane) {
                ((JTabbedPane)parent).setSelectedComponent(child);
            }
            child = parent;
        }
    }
}

