/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vertical;

import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Hexagon;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamondWIP;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.style.ISkinParam;

public class FtileDiamondSquare
extends FtileDiamondWIP {
    public FtileDiamondSquare(TextBlock label, ISkinParam skinParam, HColor backColor, HColor borderColor, Swimlane swimlane) {
        this(label, skinParam, backColor, borderColor, swimlane, TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0));
    }

    public FtileDiamondSquare withNorth(TextBlock north) {
        return new FtileDiamondSquare(this.label, this.skinParam(), this.backColor, this.borderColor, this.swimlane, north, this.west, this.east, this.south);
    }

    public FtileDiamondSquare withWest(TextBlock west) {
        return new FtileDiamondSquare(this.label, this.skinParam(), this.backColor, this.borderColor, this.swimlane, this.north, west, this.east, this.south);
    }

    public FtileDiamondSquare withEast(TextBlock east) {
        return new FtileDiamondSquare(this.label, this.skinParam(), this.backColor, this.borderColor, this.swimlane, this.north, this.west, east, this.south);
    }

    public FtileDiamondSquare withSouth(TextBlock south) {
        return new FtileDiamondSquare(this.label, this.skinParam(), this.backColor, this.borderColor, this.swimlane, this.north, this.west, this.east, south);
    }

    public Ftile withWestAndEast(TextBlock tb1, TextBlock tb2) {
        return this.withWest(tb1).withEast(tb2);
    }

    private FtileDiamondSquare(TextBlock label, ISkinParam skinParam, HColor backColor, HColor borderColor, Swimlane swimlane, TextBlock north, TextBlock west, TextBlock east, TextBlock south) {
        super(label, skinParam, backColor, borderColor, swimlane, north, south, east, west);
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        XDimension2D dimLabel = this.label.calculateDimension(stringBounder);
        XDimension2D dimTotal = this.calculateDimensionInternal(stringBounder);
        ug = ug.apply(this.borderColor).apply(this.getStyle().getStroke()).apply(this.backColor.bg());
        ug.draw(Hexagon.asPolygonSquare(this.shadowing, dimTotal.getWidth(), dimTotal.getHeight()));
        this.north.drawU(ug.apply(new UTranslate(4.0 + dimTotal.getWidth() / 2.0, dimTotal.getHeight())));
        this.south.drawU(ug.apply(new UTranslate(4.0 + dimTotal.getWidth() / 2.0, dimTotal.getHeight())));
        double lx = (dimTotal.getWidth() - dimLabel.getWidth()) / 2.0;
        double ly = (dimTotal.getHeight() - dimLabel.getHeight()) / 2.0;
        this.label.drawU(ug.apply(new UTranslate(lx, ly)));
        XDimension2D dimWeat = this.west.calculateDimension(stringBounder);
        this.west.drawU(ug.apply(new UTranslate(-dimWeat.getWidth(), -dimWeat.getHeight() + 12.0)));
        XDimension2D dimEast = this.east.calculateDimension(stringBounder);
        this.east.drawU(ug.apply(new UTranslate(dimTotal.getWidth(), -dimEast.getHeight() + 12.0)));
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        XDimension2D dim = this.calculateDimensionInternal(stringBounder);
        return new FtileGeometry(dim, dim.getWidth() / 2.0, 0.0, dim.getHeight());
    }

    private XDimension2D calculateDimensionInternal(StringBounder stringBounder) {
        XDimension2D dimLabel = this.label.calculateDimension(stringBounder);
        if (dimLabel.getWidth() == 0.0 || dimLabel.getHeight() == 0.0) {
            return new XDimension2D(24.0, 24.0);
        }
        XDimension2D result = dimLabel;
        result = result.delta(24.0, 24.0);
        return result;
    }
}

