/**
 * ./src/classes/pxe.ts
 * penguins-eggs v.25.7.x / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import { IDhcpOptions, ITftpOptions } from '../dhcpd-proxy/interfaces/i-pxe.js';
import Distro from './distro.js';
import Settings from './settings.js';
/**
 * Pxe:
 */
export default class Pxe {
    bootLabel: string;
    distro: Distro;
    echo: {};
    eggRoot: string;
    initrdImg: string;
    isos: string[];
    nest: string;
    pxeRoot: string;
    settings: Settings;
    vmlinuz: string;
    /**
     * constructor
     * @param nest
     * @param pxeRoot
     */
    constructor(nest?: string, pxeRoot?: string, verbose?: boolean);
    /**
     * build
     */
    build(): Promise<void>;
    /**
     *
     * @param dhcpOptions
     */
    dhcpdStart(dhcpOptions: IDhcpOptions): void;
    /**
     * fertilization()
     *
     * cuckoo's nest
     */
    fertilization(): Promise<void>;
    /**
     * start http server for images
     */
    httpStart(): Promise<void>;
    /**
     * start tftp
     */
    tftpStart(tftpOptions: ITftpOptions): Promise<void>;
    /**
     * Metodo helper per ottenere i parametri corretti per GRUB
     * in base alla famiglia della distribuzione.
     */
    private _getKernelParameters;
    /**
     * configure PXE bios
     */
    private bios;
    /**
     * grubCfg
     * @param familyId
     */
    private grubCfg;
    /**
     * configure PXE http server
     */
    private http;
    /**
     * uefi: uso ipxe solo per chainload di grub
     */
    private uefi;
}
