/**
 * ./src/lib/select_keyboard_option.ts
 * penguins-eggs v.25.7.x / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import inquirer from 'inquirer';
import Keyboards from '../../classes/keyboards.js';
/**
 * selectKeyboardOption
 */
export default async function selectKeyboardOption(selected = '') {
    const keyboards = new Keyboards();
    const options = keyboards.getOptions();
    const supported = [];
    for (const o of options) {
        supported.push(o.code);
    }
    const questions = [
        {
            choices: supported,
            default: selected,
            message: 'Select option: ',
            name: 'option',
            type: 'list'
        }
    ];
    return new Promise((resolve) => {
        inquirer.prompt(questions).then((options) => {
            resolve(options.option);
        });
    });
}
