/**
 * ./src/lib/utils.ts
 * penguins-eggs v.25.7.x / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import { SpawnOptions, SpawnSyncOptions, SpawnSyncReturns, ChildProcess } from 'child_process';
import { IExec } from '../interfaces/index.js';
interface ShellExecResult {
    code: number;
    stdout: string;
    stderr: string;
}
interface ExecSyncOptions {
    echo?: boolean;
    ignore?: boolean;
    stdio?: 'pipe' | 'ignore' | 'inherit';
}
/**
 * spawnSync (WRAPPER INTELLIGENTE)
 * Supporta:
 * 1. (command, args, options)
 * 2. (command, options) -> args diventa []
 * Pulisce automaticamente l'ambiente.
 */
export declare function spawnSync(command: string, arg2?: string[] | SpawnSyncOptions, arg3?: SpawnSyncOptions): SpawnSyncReturns<string | Buffer>;
/**
 * spawn (WRAPPER INTELLIGENTE)
 * Supporta:
 * 1. (command, args, options)
 * 2. (command, options) -> args diventa []
 * Pulisce automaticamente l'ambiente.
 */
export declare function spawn(command: string, arg2?: readonly string[] | SpawnOptions, arg3?: SpawnOptions): ChildProcess;
/**
 * shx
 * Sostituto drop-in per shelljs che usa API native e ambiente pulito.
 */
export declare const shx: {
    sed: (flag: string, regex: string | RegExp, replacement: string, file: string) => void;
    touch: (file: string) => void;
    cp: (arg1: string, arg2: string, arg3?: string) => void;
    rm: (arg1: string, arg2?: string) => void;
    mkdir: (arg1: string, arg2?: string) => void;
    mv: (src: string, dest: string) => void;
    chmod: (mode: string | number, file: string) => void;
    test: (flag: string, pathToCheck: string) => boolean;
    which: (cmd: string) => string | null;
    ln: (flag: string, target: string, link: string) => void;
    ls: (arg1?: string | string[], arg2?: string | string[]) => string[];
    exec: (command: string, options?: {
        silent?: boolean;
    }) => ShellExecResult;
};
/**
 * execSync
 */
export declare function execSync(command: string, options?: ExecSyncOptions): string | null;
/**
 * exec (Async)
 */
export declare function exec(command: string, { echo, ignore, capture }?: {
    echo?: boolean | undefined;
    ignore?: boolean | undefined;
    capture?: boolean | undefined;
}): Promise<IExec>;
export {};
