/**
 * ./src/components/network.tsx
 * penguins-eggs v.25.7.x / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import React from 'react';
import Title from './title.js';
import Steps from './steps.js';
import { Text, Box } from 'ink';
import yaml from 'js-yaml';
import fs from 'fs';
// pjson
import { createRequire } from 'module';
const require = createRequire(import.meta.url);
const pjson = require('../../../package.json');
export default function Network({ iface, addressType, address, netmask, gateway, domain, dns }) {
    let productName = '';
    let version = '';
    let configRoot = '/etc/penguins-eggs.d/krill/';
    if (fs.existsSync('/etc/calamares/settings.conf')) {
        configRoot = '/etc/calamares/';
    }
    const settings = yaml.load(fs.readFileSync(configRoot + 'settings.conf', 'utf-8'));
    const branding = settings.branding;
    const calamares = yaml.load(fs.readFileSync(configRoot + 'branding/' + branding + '/branding.desc', 'utf-8'));
    productName = calamares.strings.productName;
    version = calamares.strings.version;
    /**
    * totale width=75
    * step width=15
    * finestra with=59
    */
    const [activeField, setActiveField] = React.useState(0);
    const [submission, setSubmission] = React.useState();
    return (React.createElement(React.Fragment, null,
        React.createElement(Title, null),
        React.createElement(Box, { width: 75, height: 11, borderStyle: "round", flexDirection: "column" },
            React.createElement(Box, { width: 74, height: 8, flexDirection: "column" },
                React.createElement(Box, { flexDirection: "row" },
                    React.createElement(Steps, { step: 6 }),
                    React.createElement(Box, { flexDirection: "column" },
                        React.createElement(Box, null,
                            React.createElement(Text, null, "interface: "),
                            React.createElement(Text, { color: 'green' }, iface)),
                        React.createElement(Box, null,
                            React.createElement(Text, null, "type     : "),
                            React.createElement(Text, { color: 'green' }, addressType)),
                        React.createElement(Box, null,
                            React.createElement(Text, null, "address  : "),
                            React.createElement(Text, { color: 'green' }, address)),
                        React.createElement(Box, null,
                            React.createElement(Text, null, "netmask  : "),
                            React.createElement(Text, { color: 'green' }, netmask)),
                        React.createElement(Box, null,
                            React.createElement(Text, null, "gateway  : "),
                            React.createElement(Text, { color: 'green' }, gateway)),
                        React.createElement(Box, null,
                            React.createElement(Text, null, "domain   : "),
                            React.createElement(Text, { color: 'green' }, domain)),
                        React.createElement(Box, null,
                            React.createElement(Text, null, "dns      : "),
                            React.createElement(Text, { color: 'green' }, dns))))))));
}
