import {
  CachePolicyType,
  ConnectionMode,
  DistributionResourceType,
  DnsConfigurationStatus,
  FunctionStage,
  HttpVersion,
  IpAddressType,
  ManagedCertificateStatus,
  OriginAccessControlOriginTypes,
  OriginAccessControlSigningBehaviors,
  OriginAccessControlSigningProtocols,
  OriginRequestPolicyType,
  PriceClass,
  ResponseHeadersPolicyType,
  TrustStoreStatus,
  ValidationTokenHost,
} from "./enums";
import {
  Aliases,
  AliasICPRecordal,
  AnycastIpList,
  AnycastIpListCollection,
  CaCertificatesBundleSource,
  CacheBehaviors,
  CachePolicy,
  CachePolicyConfig,
  CachePolicyList,
  CloudFrontOriginAccessIdentity,
  CloudFrontOriginAccessIdentityConfig,
  ConnectionFunctionAssociation,
  ConnectionFunctionSummary,
  ConnectionGroup,
  ContentTypeProfileConfig,
  ContinuousDeploymentPolicy,
  ContinuousDeploymentPolicyConfig,
  CustomErrorResponses,
  Customizations,
  DefaultCacheBehavior,
  Distribution,
  DistributionConfig,
  DistributionTenant,
  DomainItem,
  DomainResult,
  EncryptionEntities,
  EndPoint,
  FieldLevelEncryption,
  FieldLevelEncryptionConfig,
  FieldLevelEncryptionProfile,
  FieldLevelEncryptionProfileConfig,
  FunctionConfig,
  FunctionSummary,
  KeyGroup,
  KeyGroupConfig,
  KeyValueStore,
  ManagedCertificateRequest,
  MonitoringSubscription,
  OriginAccessControl,
  OriginAccessControlConfig,
  OriginGroups,
  OriginRequestPolicy,
  OriginRequestPolicyConfig,
  Origins,
  Parameter,
  PublicKey,
  PublicKeyConfig,
  QueryArgProfileConfig,
  RealtimeLogConfig,
  ResponseHeadersPolicy,
  ResponseHeadersPolicyConfig,
  Restrictions,
  S3Origin,
  StreamingDistribution,
  StreamingDistributionConfig,
  Tags,
  TrustedSigners,
  TrustStore,
  ViewerCertificate,
  ViewerMtlsConfig,
  VpcOrigin,
  VpcOriginEndpointConfig,
} from "./models_0";
export interface ValidationTokenDetail {
  Domain: string | undefined;
  RedirectTo?: string | undefined;
  RedirectFrom?: string | undefined;
}
export interface ManagedCertificateDetails {
  CertificateArn?: string | undefined;
  CertificateStatus?: ManagedCertificateStatus | undefined;
  ValidationTokenHost?: ValidationTokenHost | undefined;
  ValidationTokenDetails?: ValidationTokenDetail[] | undefined;
}
export interface GetManagedCertificateDetailsResult {
  ManagedCertificateDetails?: ManagedCertificateDetails | undefined;
}
export interface GetMonitoringSubscriptionRequest {
  DistributionId: string | undefined;
}
export interface GetMonitoringSubscriptionResult {
  MonitoringSubscription?: MonitoringSubscription | undefined;
}
export interface GetOriginAccessControlRequest {
  Id: string | undefined;
}
export interface GetOriginAccessControlResult {
  OriginAccessControl?: OriginAccessControl | undefined;
  ETag?: string | undefined;
}
export interface GetOriginAccessControlConfigRequest {
  Id: string | undefined;
}
export interface GetOriginAccessControlConfigResult {
  OriginAccessControlConfig?: OriginAccessControlConfig | undefined;
  ETag?: string | undefined;
}
export interface GetOriginRequestPolicyRequest {
  Id: string | undefined;
}
export interface GetOriginRequestPolicyResult {
  OriginRequestPolicy?: OriginRequestPolicy | undefined;
  ETag?: string | undefined;
}
export interface GetOriginRequestPolicyConfigRequest {
  Id: string | undefined;
}
export interface GetOriginRequestPolicyConfigResult {
  OriginRequestPolicyConfig?: OriginRequestPolicyConfig | undefined;
  ETag?: string | undefined;
}
export interface GetPublicKeyRequest {
  Id: string | undefined;
}
export interface GetPublicKeyResult {
  PublicKey?: PublicKey | undefined;
  ETag?: string | undefined;
}
export interface GetPublicKeyConfigRequest {
  Id: string | undefined;
}
export interface GetPublicKeyConfigResult {
  PublicKeyConfig?: PublicKeyConfig | undefined;
  ETag?: string | undefined;
}
export interface GetRealtimeLogConfigRequest {
  Name?: string | undefined;
  ARN?: string | undefined;
}
export interface GetRealtimeLogConfigResult {
  RealtimeLogConfig?: RealtimeLogConfig | undefined;
}
export interface GetResourcePolicyRequest {
  ResourceArn: string | undefined;
}
export interface GetResourcePolicyResult {
  ResourceArn?: string | undefined;
  PolicyDocument?: string | undefined;
}
export interface GetResponseHeadersPolicyRequest {
  Id: string | undefined;
}
export interface GetResponseHeadersPolicyResult {
  ResponseHeadersPolicy?: ResponseHeadersPolicy | undefined;
  ETag?: string | undefined;
}
export interface GetResponseHeadersPolicyConfigRequest {
  Id: string | undefined;
}
export interface GetResponseHeadersPolicyConfigResult {
  ResponseHeadersPolicyConfig?: ResponseHeadersPolicyConfig | undefined;
  ETag?: string | undefined;
}
export interface GetStreamingDistributionRequest {
  Id: string | undefined;
}
export interface GetStreamingDistributionResult {
  StreamingDistribution?: StreamingDistribution | undefined;
  ETag?: string | undefined;
}
export interface GetStreamingDistributionConfigRequest {
  Id: string | undefined;
}
export interface GetStreamingDistributionConfigResult {
  StreamingDistributionConfig?: StreamingDistributionConfig | undefined;
  ETag?: string | undefined;
}
export interface GetTrustStoreRequest {
  Identifier: string | undefined;
}
export interface GetTrustStoreResult {
  TrustStore?: TrustStore | undefined;
  ETag?: string | undefined;
}
export interface GetVpcOriginRequest {
  Id: string | undefined;
}
export interface GetVpcOriginResult {
  VpcOrigin?: VpcOrigin | undefined;
  ETag?: string | undefined;
}
export interface ListAnycastIpListsRequest {
  Marker?: string | undefined;
  MaxItems?: number | undefined;
}
export interface ListAnycastIpListsResult {
  AnycastIpLists?: AnycastIpListCollection | undefined;
}
export interface ListCachePoliciesRequest {
  Type?: CachePolicyType | undefined;
  Marker?: string | undefined;
  MaxItems?: number | undefined;
}
export interface ListCachePoliciesResult {
  CachePolicyList?: CachePolicyList | undefined;
}
export interface ListCloudFrontOriginAccessIdentitiesRequest {
  Marker?: string | undefined;
  MaxItems?: number | undefined;
}
export interface CloudFrontOriginAccessIdentitySummary {
  Id: string | undefined;
  S3CanonicalUserId: string | undefined;
  Comment: string | undefined;
}
export interface CloudFrontOriginAccessIdentityList {
  Marker: string | undefined;
  NextMarker?: string | undefined;
  MaxItems: number | undefined;
  IsTruncated: boolean | undefined;
  Quantity: number | undefined;
  Items?: CloudFrontOriginAccessIdentitySummary[] | undefined;
}
export interface ListCloudFrontOriginAccessIdentitiesResult {
  CloudFrontOriginAccessIdentityList?:
    | CloudFrontOriginAccessIdentityList
    | undefined;
}
export interface ListConflictingAliasesRequest {
  DistributionId: string | undefined;
  Alias: string | undefined;
  Marker?: string | undefined;
  MaxItems?: number | undefined;
}
export interface ConflictingAlias {
  Alias?: string | undefined;
  DistributionId?: string | undefined;
  AccountId?: string | undefined;
}
export interface ConflictingAliasesList {
  NextMarker?: string | undefined;
  MaxItems?: number | undefined;
  Quantity?: number | undefined;
  Items?: ConflictingAlias[] | undefined;
}
export interface ListConflictingAliasesResult {
  ConflictingAliasesList?: ConflictingAliasesList | undefined;
}
export interface ListConnectionFunctionsRequest {
  Marker?: string | undefined;
  MaxItems?: number | undefined;
  Stage?: FunctionStage | undefined;
}
export interface ListConnectionFunctionsResult {
  NextMarker?: string | undefined;
  ConnectionFunctions?: ConnectionFunctionSummary[] | undefined;
}
export interface ConnectionGroupAssociationFilter {
  AnycastIpListId?: string | undefined;
}
export interface ListConnectionGroupsRequest {
  AssociationFilter?: ConnectionGroupAssociationFilter | undefined;
  Marker?: string | undefined;
  MaxItems?: number | undefined;
}
export interface ConnectionGroupSummary {
  Id: string | undefined;
  Name: string | undefined;
  Arn: string | undefined;
  RoutingEndpoint: string | undefined;
  CreatedTime: Date | undefined;
  LastModifiedTime: Date | undefined;
  ETag: string | undefined;
  AnycastIpListId?: string | undefined;
  Enabled?: boolean | undefined;
  Status?: string | undefined;
  IsDefault?: boolean | undefined;
}
export interface ListConnectionGroupsResult {
  NextMarker?: string | undefined;
  ConnectionGroups?: ConnectionGroupSummary[] | undefined;
}
export interface ListContinuousDeploymentPoliciesRequest {
  Marker?: string | undefined;
  MaxItems?: number | undefined;
}
export interface ContinuousDeploymentPolicySummary {
  ContinuousDeploymentPolicy: ContinuousDeploymentPolicy | undefined;
}
export interface ContinuousDeploymentPolicyList {
  NextMarker?: string | undefined;
  MaxItems: number | undefined;
  Quantity: number | undefined;
  Items?: ContinuousDeploymentPolicySummary[] | undefined;
}
export interface ListContinuousDeploymentPoliciesResult {
  ContinuousDeploymentPolicyList?: ContinuousDeploymentPolicyList | undefined;
}
export interface ListDistributionsRequest {
  Marker?: string | undefined;
  MaxItems?: number | undefined;
}
export interface DistributionSummary {
  Id: string | undefined;
  ARN: string | undefined;
  ETag?: string | undefined;
  Status: string | undefined;
  LastModifiedTime: Date | undefined;
  DomainName: string | undefined;
  Aliases: Aliases | undefined;
  Origins: Origins | undefined;
  OriginGroups?: OriginGroups | undefined;
  DefaultCacheBehavior: DefaultCacheBehavior | undefined;
  CacheBehaviors: CacheBehaviors | undefined;
  CustomErrorResponses: CustomErrorResponses | undefined;
  Comment: string | undefined;
  PriceClass: PriceClass | undefined;
  Enabled: boolean | undefined;
  ViewerCertificate: ViewerCertificate | undefined;
  Restrictions: Restrictions | undefined;
  WebACLId: string | undefined;
  HttpVersion: HttpVersion | undefined;
  IsIPV6Enabled: boolean | undefined;
  AliasICPRecordals?: AliasICPRecordal[] | undefined;
  Staging: boolean | undefined;
  ConnectionMode?: ConnectionMode | undefined;
  AnycastIpListId?: string | undefined;
  ViewerMtlsConfig?: ViewerMtlsConfig | undefined;
  ConnectionFunctionAssociation?: ConnectionFunctionAssociation | undefined;
}
export interface DistributionList {
  Marker: string | undefined;
  NextMarker?: string | undefined;
  MaxItems: number | undefined;
  IsTruncated: boolean | undefined;
  Quantity: number | undefined;
  Items?: DistributionSummary[] | undefined;
}
export interface ListDistributionsResult {
  DistributionList?: DistributionList | undefined;
}
export interface ListDistributionsByAnycastIpListIdRequest {
  Marker?: string | undefined;
  MaxItems?: number | undefined;
  AnycastIpListId: string | undefined;
}
export interface ListDistributionsByAnycastIpListIdResult {
  DistributionList?: DistributionList | undefined;
}
export interface ListDistributionsByCachePolicyIdRequest {
  Marker?: string | undefined;
  MaxItems?: number | undefined;
  CachePolicyId: string | undefined;
}
export interface DistributionIdList {
  Marker: string | undefined;
  NextMarker?: string | undefined;
  MaxItems: number | undefined;
  IsTruncated: boolean | undefined;
  Quantity: number | undefined;
  Items?: string[] | undefined;
}
export interface ListDistributionsByCachePolicyIdResult {
  DistributionIdList?: DistributionIdList | undefined;
}
export interface ListDistributionsByConnectionFunctionRequest {
  Marker?: string | undefined;
  MaxItems?: number | undefined;
  ConnectionFunctionIdentifier: string | undefined;
}
export interface ListDistributionsByConnectionFunctionResult {
  DistributionList?: DistributionList | undefined;
}
export interface ListDistributionsByConnectionModeRequest {
  Marker?: string | undefined;
  MaxItems?: number | undefined;
  ConnectionMode: ConnectionMode | undefined;
}
export interface ListDistributionsByConnectionModeResult {
  DistributionList?: DistributionList | undefined;
}
export interface ListDistributionsByKeyGroupRequest {
  Marker?: string | undefined;
  MaxItems?: number | undefined;
  KeyGroupId: string | undefined;
}
export interface ListDistributionsByKeyGroupResult {
  DistributionIdList?: DistributionIdList | undefined;
}
export interface ListDistributionsByOriginRequestPolicyIdRequest {
  Marker?: string | undefined;
  MaxItems?: number | undefined;
  OriginRequestPolicyId: string | undefined;
}
export interface ListDistributionsByOriginRequestPolicyIdResult {
  DistributionIdList?: DistributionIdList | undefined;
}
export interface ListDistributionsByOwnedResourceRequest {
  ResourceArn: string | undefined;
  Marker?: string | undefined;
  MaxItems?: number | undefined;
}
export interface DistributionIdOwner {
  DistributionId: string | undefined;
  OwnerAccountId: string | undefined;
}
export interface DistributionIdOwnerList {
  Marker: string | undefined;
  NextMarker?: string | undefined;
  MaxItems: number | undefined;
  IsTruncated: boolean | undefined;
  Quantity: number | undefined;
  Items?: DistributionIdOwner[] | undefined;
}
export interface ListDistributionsByOwnedResourceResult {
  DistributionList?: DistributionIdOwnerList | undefined;
}
export interface ListDistributionsByRealtimeLogConfigRequest {
  Marker?: string | undefined;
  MaxItems?: number | undefined;
  RealtimeLogConfigName?: string | undefined;
  RealtimeLogConfigArn?: string | undefined;
}
export interface ListDistributionsByRealtimeLogConfigResult {
  DistributionList?: DistributionList | undefined;
}
export interface ListDistributionsByResponseHeadersPolicyIdRequest {
  Marker?: string | undefined;
  MaxItems?: number | undefined;
  ResponseHeadersPolicyId: string | undefined;
}
export interface ListDistributionsByResponseHeadersPolicyIdResult {
  DistributionIdList?: DistributionIdList | undefined;
}
export interface ListDistributionsByTrustStoreRequest {
  TrustStoreIdentifier: string | undefined;
  Marker?: string | undefined;
  MaxItems?: number | undefined;
}
export interface ListDistributionsByTrustStoreResult {
  DistributionList?: DistributionList | undefined;
}
export interface ListDistributionsByVpcOriginIdRequest {
  Marker?: string | undefined;
  MaxItems?: number | undefined;
  VpcOriginId: string | undefined;
}
export interface ListDistributionsByVpcOriginIdResult {
  DistributionIdList?: DistributionIdList | undefined;
}
export interface ListDistributionsByWebACLIdRequest {
  Marker?: string | undefined;
  MaxItems?: number | undefined;
  WebACLId: string | undefined;
}
export interface ListDistributionsByWebACLIdResult {
  DistributionList?: DistributionList | undefined;
}
export interface DistributionTenantAssociationFilter {
  DistributionId?: string | undefined;
  ConnectionGroupId?: string | undefined;
}
export interface ListDistributionTenantsRequest {
  AssociationFilter?: DistributionTenantAssociationFilter | undefined;
  Marker?: string | undefined;
  MaxItems?: number | undefined;
}
export interface DistributionTenantSummary {
  Id: string | undefined;
  DistributionId: string | undefined;
  Name: string | undefined;
  Arn: string | undefined;
  Domains: DomainResult[] | undefined;
  ConnectionGroupId?: string | undefined;
  Customizations?: Customizations | undefined;
  CreatedTime: Date | undefined;
  LastModifiedTime: Date | undefined;
  ETag: string | undefined;
  Enabled?: boolean | undefined;
  Status?: string | undefined;
}
export interface ListDistributionTenantsResult {
  NextMarker?: string | undefined;
  DistributionTenantList?: DistributionTenantSummary[] | undefined;
}
export interface ListDistributionTenantsByCustomizationRequest {
  WebACLArn?: string | undefined;
  CertificateArn?: string | undefined;
  Marker?: string | undefined;
  MaxItems?: number | undefined;
}
export interface ListDistributionTenantsByCustomizationResult {
  NextMarker?: string | undefined;
  DistributionTenantList?: DistributionTenantSummary[] | undefined;
}
export interface DistributionResourceId {
  DistributionId?: string | undefined;
  DistributionTenantId?: string | undefined;
}
export interface ListDomainConflictsRequest {
  Domain: string | undefined;
  DomainControlValidationResource: DistributionResourceId | undefined;
  MaxItems?: number | undefined;
  Marker?: string | undefined;
}
export interface DomainConflict {
  Domain: string | undefined;
  ResourceType: DistributionResourceType | undefined;
  ResourceId: string | undefined;
  AccountId: string | undefined;
}
export interface ListDomainConflictsResult {
  DomainConflicts?: DomainConflict[] | undefined;
  NextMarker?: string | undefined;
}
export interface ListFieldLevelEncryptionConfigsRequest {
  Marker?: string | undefined;
  MaxItems?: number | undefined;
}
export interface FieldLevelEncryptionSummary {
  Id: string | undefined;
  LastModifiedTime: Date | undefined;
  Comment?: string | undefined;
  QueryArgProfileConfig?: QueryArgProfileConfig | undefined;
  ContentTypeProfileConfig?: ContentTypeProfileConfig | undefined;
}
export interface FieldLevelEncryptionList {
  NextMarker?: string | undefined;
  MaxItems: number | undefined;
  Quantity: number | undefined;
  Items?: FieldLevelEncryptionSummary[] | undefined;
}
export interface ListFieldLevelEncryptionConfigsResult {
  FieldLevelEncryptionList?: FieldLevelEncryptionList | undefined;
}
export interface ListFieldLevelEncryptionProfilesRequest {
  Marker?: string | undefined;
  MaxItems?: number | undefined;
}
export interface FieldLevelEncryptionProfileSummary {
  Id: string | undefined;
  LastModifiedTime: Date | undefined;
  Name: string | undefined;
  EncryptionEntities: EncryptionEntities | undefined;
  Comment?: string | undefined;
}
export interface FieldLevelEncryptionProfileList {
  NextMarker?: string | undefined;
  MaxItems: number | undefined;
  Quantity: number | undefined;
  Items?: FieldLevelEncryptionProfileSummary[] | undefined;
}
export interface ListFieldLevelEncryptionProfilesResult {
  FieldLevelEncryptionProfileList?: FieldLevelEncryptionProfileList | undefined;
}
export interface ListFunctionsRequest {
  Marker?: string | undefined;
  MaxItems?: number | undefined;
  Stage?: FunctionStage | undefined;
}
export interface FunctionList {
  NextMarker?: string | undefined;
  MaxItems: number | undefined;
  Quantity: number | undefined;
  Items?: FunctionSummary[] | undefined;
}
export interface ListFunctionsResult {
  FunctionList?: FunctionList | undefined;
}
export interface ListInvalidationsRequest {
  DistributionId: string | undefined;
  Marker?: string | undefined;
  MaxItems?: number | undefined;
}
export interface InvalidationSummary {
  Id: string | undefined;
  CreateTime: Date | undefined;
  Status: string | undefined;
}
export interface InvalidationList {
  Marker: string | undefined;
  NextMarker?: string | undefined;
  MaxItems: number | undefined;
  IsTruncated: boolean | undefined;
  Quantity: number | undefined;
  Items?: InvalidationSummary[] | undefined;
}
export interface ListInvalidationsResult {
  InvalidationList?: InvalidationList | undefined;
}
export interface ListInvalidationsForDistributionTenantRequest {
  Id: string | undefined;
  Marker?: string | undefined;
  MaxItems?: number | undefined;
}
export interface ListInvalidationsForDistributionTenantResult {
  InvalidationList?: InvalidationList | undefined;
}
export interface ListKeyGroupsRequest {
  Marker?: string | undefined;
  MaxItems?: number | undefined;
}
export interface KeyGroupSummary {
  KeyGroup: KeyGroup | undefined;
}
export interface KeyGroupList {
  NextMarker?: string | undefined;
  MaxItems: number | undefined;
  Quantity: number | undefined;
  Items?: KeyGroupSummary[] | undefined;
}
export interface ListKeyGroupsResult {
  KeyGroupList?: KeyGroupList | undefined;
}
export interface ListKeyValueStoresRequest {
  Marker?: string | undefined;
  MaxItems?: number | undefined;
  Status?: string | undefined;
}
export interface KeyValueStoreList {
  NextMarker?: string | undefined;
  MaxItems: number | undefined;
  Quantity: number | undefined;
  Items?: KeyValueStore[] | undefined;
}
export interface ListKeyValueStoresResult {
  KeyValueStoreList?: KeyValueStoreList | undefined;
}
export interface ListOriginAccessControlsRequest {
  Marker?: string | undefined;
  MaxItems?: number | undefined;
}
export interface OriginAccessControlSummary {
  Id: string | undefined;
  Description: string | undefined;
  Name: string | undefined;
  SigningProtocol: OriginAccessControlSigningProtocols | undefined;
  SigningBehavior: OriginAccessControlSigningBehaviors | undefined;
  OriginAccessControlOriginType: OriginAccessControlOriginTypes | undefined;
}
export interface OriginAccessControlList {
  Marker: string | undefined;
  NextMarker?: string | undefined;
  MaxItems: number | undefined;
  IsTruncated: boolean | undefined;
  Quantity: number | undefined;
  Items?: OriginAccessControlSummary[] | undefined;
}
export interface ListOriginAccessControlsResult {
  OriginAccessControlList?: OriginAccessControlList | undefined;
}
export interface ListOriginRequestPoliciesRequest {
  Type?: OriginRequestPolicyType | undefined;
  Marker?: string | undefined;
  MaxItems?: number | undefined;
}
export interface OriginRequestPolicySummary {
  Type: OriginRequestPolicyType | undefined;
  OriginRequestPolicy: OriginRequestPolicy | undefined;
}
export interface OriginRequestPolicyList {
  NextMarker?: string | undefined;
  MaxItems: number | undefined;
  Quantity: number | undefined;
  Items?: OriginRequestPolicySummary[] | undefined;
}
export interface ListOriginRequestPoliciesResult {
  OriginRequestPolicyList?: OriginRequestPolicyList | undefined;
}
export interface ListPublicKeysRequest {
  Marker?: string | undefined;
  MaxItems?: number | undefined;
}
export interface PublicKeySummary {
  Id: string | undefined;
  Name: string | undefined;
  CreatedTime: Date | undefined;
  EncodedKey: string | undefined;
  Comment?: string | undefined;
}
export interface PublicKeyList {
  NextMarker?: string | undefined;
  MaxItems: number | undefined;
  Quantity: number | undefined;
  Items?: PublicKeySummary[] | undefined;
}
export interface ListPublicKeysResult {
  PublicKeyList?: PublicKeyList | undefined;
}
export interface ListRealtimeLogConfigsRequest {
  MaxItems?: number | undefined;
  Marker?: string | undefined;
}
export interface RealtimeLogConfigs {
  MaxItems: number | undefined;
  Items?: RealtimeLogConfig[] | undefined;
  IsTruncated: boolean | undefined;
  Marker: string | undefined;
  NextMarker?: string | undefined;
}
export interface ListRealtimeLogConfigsResult {
  RealtimeLogConfigs?: RealtimeLogConfigs | undefined;
}
export interface ListResponseHeadersPoliciesRequest {
  Type?: ResponseHeadersPolicyType | undefined;
  Marker?: string | undefined;
  MaxItems?: number | undefined;
}
export interface ResponseHeadersPolicySummary {
  Type: ResponseHeadersPolicyType | undefined;
  ResponseHeadersPolicy: ResponseHeadersPolicy | undefined;
}
export interface ResponseHeadersPolicyList {
  NextMarker?: string | undefined;
  MaxItems: number | undefined;
  Quantity: number | undefined;
  Items?: ResponseHeadersPolicySummary[] | undefined;
}
export interface ListResponseHeadersPoliciesResult {
  ResponseHeadersPolicyList?: ResponseHeadersPolicyList | undefined;
}
export interface ListStreamingDistributionsRequest {
  Marker?: string | undefined;
  MaxItems?: number | undefined;
}
export interface StreamingDistributionSummary {
  Id: string | undefined;
  ARN: string | undefined;
  Status: string | undefined;
  LastModifiedTime: Date | undefined;
  DomainName: string | undefined;
  S3Origin: S3Origin | undefined;
  Aliases: Aliases | undefined;
  TrustedSigners: TrustedSigners | undefined;
  Comment: string | undefined;
  PriceClass: PriceClass | undefined;
  Enabled: boolean | undefined;
}
export interface StreamingDistributionList {
  Marker: string | undefined;
  NextMarker?: string | undefined;
  MaxItems: number | undefined;
  IsTruncated: boolean | undefined;
  Quantity: number | undefined;
  Items?: StreamingDistributionSummary[] | undefined;
}
export interface ListStreamingDistributionsResult {
  StreamingDistributionList?: StreamingDistributionList | undefined;
}
export interface ListTagsForResourceRequest {
  Resource: string | undefined;
}
export interface ListTagsForResourceResult {
  Tags: Tags | undefined;
}
export interface ListTrustStoresRequest {
  Marker?: string | undefined;
  MaxItems?: number | undefined;
}
export interface TrustStoreSummary {
  Id: string | undefined;
  Arn: string | undefined;
  Name: string | undefined;
  Status: TrustStoreStatus | undefined;
  NumberOfCaCertificates: number | undefined;
  LastModifiedTime: Date | undefined;
  Reason?: string | undefined;
  ETag: string | undefined;
}
export interface ListTrustStoresResult {
  NextMarker?: string | undefined;
  TrustStoreList?: TrustStoreSummary[] | undefined;
}
export interface ListVpcOriginsRequest {
  Marker?: string | undefined;
  MaxItems?: number | undefined;
}
export interface VpcOriginSummary {
  Id: string | undefined;
  Name: string | undefined;
  Status: string | undefined;
  CreatedTime: Date | undefined;
  LastModifiedTime: Date | undefined;
  Arn: string | undefined;
  AccountId?: string | undefined;
  OriginEndpointArn: string | undefined;
}
export interface VpcOriginList {
  Marker: string | undefined;
  NextMarker?: string | undefined;
  MaxItems: number | undefined;
  IsTruncated: boolean | undefined;
  Quantity: number | undefined;
  Items?: VpcOriginSummary[] | undefined;
}
export interface ListVpcOriginsResult {
  VpcOriginList?: VpcOriginList | undefined;
}
export interface PublishConnectionFunctionRequest {
  Id: string | undefined;
  IfMatch: string | undefined;
}
export interface PublishConnectionFunctionResult {
  ConnectionFunctionSummary?: ConnectionFunctionSummary | undefined;
}
export interface PublishFunctionRequest {
  Name: string | undefined;
  IfMatch: string | undefined;
}
export interface PublishFunctionResult {
  FunctionSummary?: FunctionSummary | undefined;
}
export interface PutResourcePolicyRequest {
  ResourceArn: string | undefined;
  PolicyDocument: string | undefined;
}
export interface PutResourcePolicyResult {
  ResourceArn?: string | undefined;
}
export interface TagResourceRequest {
  Resource: string | undefined;
  Tags: Tags | undefined;
}
export interface TestConnectionFunctionRequest {
  Id: string | undefined;
  IfMatch: string | undefined;
  Stage?: FunctionStage | undefined;
  ConnectionObject: Uint8Array | undefined;
}
export interface ConnectionFunctionTestResult {
  ConnectionFunctionSummary?: ConnectionFunctionSummary | undefined;
  ComputeUtilization?: string | undefined;
  ConnectionFunctionExecutionLogs?: string[] | undefined;
  ConnectionFunctionErrorMessage?: string | undefined;
  ConnectionFunctionOutput?: string | undefined;
}
export interface TestConnectionFunctionResult {
  ConnectionFunctionTestResult?: ConnectionFunctionTestResult | undefined;
}
export interface TestFunctionRequest {
  Name: string | undefined;
  IfMatch: string | undefined;
  Stage?: FunctionStage | undefined;
  EventObject: Uint8Array | undefined;
}
export interface TestResult {
  FunctionSummary?: FunctionSummary | undefined;
  ComputeUtilization?: string | undefined;
  FunctionExecutionLogs?: string[] | undefined;
  FunctionErrorMessage?: string | undefined;
  FunctionOutput?: string | undefined;
}
export interface TestFunctionResult {
  TestResult?: TestResult | undefined;
}
export interface TagKeys {
  Items?: string[] | undefined;
}
export interface UntagResourceRequest {
  Resource: string | undefined;
  TagKeys: TagKeys | undefined;
}
export interface UpdateAnycastIpListRequest {
  Id: string | undefined;
  IpAddressType?: IpAddressType | undefined;
  IfMatch: string | undefined;
}
export interface UpdateAnycastIpListResult {
  AnycastIpList?: AnycastIpList | undefined;
  ETag?: string | undefined;
}
export interface UpdateCachePolicyRequest {
  CachePolicyConfig: CachePolicyConfig | undefined;
  Id: string | undefined;
  IfMatch?: string | undefined;
}
export interface UpdateCachePolicyResult {
  CachePolicy?: CachePolicy | undefined;
  ETag?: string | undefined;
}
export interface UpdateCloudFrontOriginAccessIdentityRequest {
  CloudFrontOriginAccessIdentityConfig:
    | CloudFrontOriginAccessIdentityConfig
    | undefined;
  Id: string | undefined;
  IfMatch?: string | undefined;
}
export interface UpdateCloudFrontOriginAccessIdentityResult {
  CloudFrontOriginAccessIdentity?: CloudFrontOriginAccessIdentity | undefined;
  ETag?: string | undefined;
}
export interface UpdateConnectionFunctionRequest {
  Id: string | undefined;
  IfMatch: string | undefined;
  ConnectionFunctionConfig: FunctionConfig | undefined;
  ConnectionFunctionCode: Uint8Array | undefined;
}
export interface UpdateConnectionFunctionResult {
  ConnectionFunctionSummary?: ConnectionFunctionSummary | undefined;
  ETag?: string | undefined;
}
export interface UpdateConnectionGroupRequest {
  Id: string | undefined;
  Ipv6Enabled?: boolean | undefined;
  IfMatch: string | undefined;
  AnycastIpListId?: string | undefined;
  Enabled?: boolean | undefined;
}
export interface UpdateConnectionGroupResult {
  ConnectionGroup?: ConnectionGroup | undefined;
  ETag?: string | undefined;
}
export interface UpdateContinuousDeploymentPolicyRequest {
  ContinuousDeploymentPolicyConfig:
    | ContinuousDeploymentPolicyConfig
    | undefined;
  Id: string | undefined;
  IfMatch?: string | undefined;
}
export interface UpdateContinuousDeploymentPolicyResult {
  ContinuousDeploymentPolicy?: ContinuousDeploymentPolicy | undefined;
  ETag?: string | undefined;
}
export interface UpdateDistributionRequest {
  DistributionConfig: DistributionConfig | undefined;
  Id: string | undefined;
  IfMatch?: string | undefined;
}
export interface UpdateDistributionResult {
  Distribution?: Distribution | undefined;
  ETag?: string | undefined;
}
export interface UpdateDistributionTenantRequest {
  Id: string | undefined;
  DistributionId?: string | undefined;
  Domains?: DomainItem[] | undefined;
  Customizations?: Customizations | undefined;
  Parameters?: Parameter[] | undefined;
  ConnectionGroupId?: string | undefined;
  IfMatch: string | undefined;
  ManagedCertificateRequest?: ManagedCertificateRequest | undefined;
  Enabled?: boolean | undefined;
}
export interface UpdateDistributionTenantResult {
  DistributionTenant?: DistributionTenant | undefined;
  ETag?: string | undefined;
}
export interface UpdateDistributionWithStagingConfigRequest {
  Id: string | undefined;
  StagingDistributionId?: string | undefined;
  IfMatch?: string | undefined;
}
export interface UpdateDistributionWithStagingConfigResult {
  Distribution?: Distribution | undefined;
  ETag?: string | undefined;
}
export interface UpdateDomainAssociationRequest {
  Domain: string | undefined;
  TargetResource: DistributionResourceId | undefined;
  IfMatch?: string | undefined;
}
export interface UpdateDomainAssociationResult {
  Domain?: string | undefined;
  ResourceId?: string | undefined;
  ETag?: string | undefined;
}
export interface UpdateFieldLevelEncryptionConfigRequest {
  FieldLevelEncryptionConfig: FieldLevelEncryptionConfig | undefined;
  Id: string | undefined;
  IfMatch?: string | undefined;
}
export interface UpdateFieldLevelEncryptionConfigResult {
  FieldLevelEncryption?: FieldLevelEncryption | undefined;
  ETag?: string | undefined;
}
export interface UpdateFieldLevelEncryptionProfileRequest {
  FieldLevelEncryptionProfileConfig:
    | FieldLevelEncryptionProfileConfig
    | undefined;
  Id: string | undefined;
  IfMatch?: string | undefined;
}
export interface UpdateFieldLevelEncryptionProfileResult {
  FieldLevelEncryptionProfile?: FieldLevelEncryptionProfile | undefined;
  ETag?: string | undefined;
}
export interface UpdateFunctionRequest {
  Name: string | undefined;
  IfMatch: string | undefined;
  FunctionConfig: FunctionConfig | undefined;
  FunctionCode: Uint8Array | undefined;
}
export interface UpdateFunctionResult {
  FunctionSummary?: FunctionSummary | undefined;
  ETag?: string | undefined;
}
export interface UpdateKeyGroupRequest {
  KeyGroupConfig: KeyGroupConfig | undefined;
  Id: string | undefined;
  IfMatch?: string | undefined;
}
export interface UpdateKeyGroupResult {
  KeyGroup?: KeyGroup | undefined;
  ETag?: string | undefined;
}
export interface UpdateKeyValueStoreRequest {
  Name: string | undefined;
  Comment: string | undefined;
  IfMatch: string | undefined;
}
export interface UpdateKeyValueStoreResult {
  KeyValueStore?: KeyValueStore | undefined;
  ETag?: string | undefined;
}
export interface UpdateOriginAccessControlRequest {
  OriginAccessControlConfig: OriginAccessControlConfig | undefined;
  Id: string | undefined;
  IfMatch?: string | undefined;
}
export interface UpdateOriginAccessControlResult {
  OriginAccessControl?: OriginAccessControl | undefined;
  ETag?: string | undefined;
}
export interface UpdateOriginRequestPolicyRequest {
  OriginRequestPolicyConfig: OriginRequestPolicyConfig | undefined;
  Id: string | undefined;
  IfMatch?: string | undefined;
}
export interface UpdateOriginRequestPolicyResult {
  OriginRequestPolicy?: OriginRequestPolicy | undefined;
  ETag?: string | undefined;
}
export interface UpdatePublicKeyRequest {
  PublicKeyConfig: PublicKeyConfig | undefined;
  Id: string | undefined;
  IfMatch?: string | undefined;
}
export interface UpdatePublicKeyResult {
  PublicKey?: PublicKey | undefined;
  ETag?: string | undefined;
}
export interface UpdateRealtimeLogConfigRequest {
  EndPoints?: EndPoint[] | undefined;
  Fields?: string[] | undefined;
  Name?: string | undefined;
  ARN?: string | undefined;
  SamplingRate?: number | undefined;
}
export interface UpdateRealtimeLogConfigResult {
  RealtimeLogConfig?: RealtimeLogConfig | undefined;
}
export interface UpdateResponseHeadersPolicyRequest {
  ResponseHeadersPolicyConfig: ResponseHeadersPolicyConfig | undefined;
  Id: string | undefined;
  IfMatch?: string | undefined;
}
export interface UpdateResponseHeadersPolicyResult {
  ResponseHeadersPolicy?: ResponseHeadersPolicy | undefined;
  ETag?: string | undefined;
}
export interface UpdateStreamingDistributionRequest {
  StreamingDistributionConfig: StreamingDistributionConfig | undefined;
  Id: string | undefined;
  IfMatch?: string | undefined;
}
export interface UpdateStreamingDistributionResult {
  StreamingDistribution?: StreamingDistribution | undefined;
  ETag?: string | undefined;
}
export interface UpdateTrustStoreRequest {
  Id: string | undefined;
  CaCertificatesBundleSource: CaCertificatesBundleSource | undefined;
  IfMatch: string | undefined;
}
export interface UpdateTrustStoreResult {
  TrustStore?: TrustStore | undefined;
  ETag?: string | undefined;
}
export interface UpdateVpcOriginRequest {
  VpcOriginEndpointConfig: VpcOriginEndpointConfig | undefined;
  Id: string | undefined;
  IfMatch: string | undefined;
}
export interface UpdateVpcOriginResult {
  VpcOrigin?: VpcOrigin | undefined;
  ETag?: string | undefined;
}
export interface VerifyDnsConfigurationRequest {
  Domain?: string | undefined;
  Identifier: string | undefined;
}
export interface DnsConfiguration {
  Domain: string | undefined;
  Status: DnsConfigurationStatus | undefined;
  Reason?: string | undefined;
}
export interface VerifyDnsConfigurationResult {
  DnsConfigurationList?: DnsConfiguration[] | undefined;
}
