/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.securityconf;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.EventBusBuilder;
import org.greenrobot.eventbus.Logger;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.security.DefaultObjectMapper;
import org.opensearch.security.auditlog.config.AuditConfig;
import org.opensearch.security.auth.internal.InternalAuthenticationBackend;
import org.opensearch.security.configuration.ClusterInfoHolder;
import org.opensearch.security.configuration.ConfigurationChangeListener;
import org.opensearch.security.configuration.ConfigurationMap;
import org.opensearch.security.configuration.ConfigurationRepository;
import org.opensearch.security.configuration.SecurityConfigVersionHandler;
import org.opensearch.security.configuration.StaticResourceException;
import org.opensearch.security.hasher.PasswordHasher;
import org.opensearch.security.securityconf.ConfigModelV7;
import org.opensearch.security.securityconf.DynamicConfigModelV7;
import org.opensearch.security.securityconf.Initializable;
import org.opensearch.security.securityconf.InternalUsersModel;
import org.opensearch.security.securityconf.NodesDnModel;
import org.opensearch.security.securityconf.impl.AllowlistingSettings;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.security.securityconf.impl.NodesDn;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.security.securityconf.impl.v7.ActionGroupsV7;
import org.opensearch.security.securityconf.impl.v7.ConfigV7;
import org.opensearch.security.securityconf.impl.v7.InternalUserV7;
import org.opensearch.security.securityconf.impl.v7.RoleMappingsV7;
import org.opensearch.security.securityconf.impl.v7.RoleV7;
import org.opensearch.security.securityconf.impl.v7.TenantV7;
import org.opensearch.security.support.WildcardMatcher;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;

public class DynamicConfigFactory
implements Initializable,
ConfigurationChangeListener {
    public static final EventBusBuilder EVENT_BUS_BUILDER = EventBus.builder();
    private static SecurityDynamicConfiguration<RoleV7> staticRoles = SecurityDynamicConfiguration.empty(CType.ROLES);
    private static SecurityDynamicConfiguration<ActionGroupsV7> staticActionGroups = SecurityDynamicConfiguration.empty(CType.ACTIONGROUPS);
    private static SecurityDynamicConfiguration<TenantV7> staticTenants = SecurityDynamicConfiguration.empty(CType.TENANTS);
    private static final AllowlistingSettings defaultAllowlistingSettings = new AllowlistingSettings();
    private static final AuditConfig defaultAuditConfig = AuditConfig.from(Settings.EMPTY);
    protected final org.apache.logging.log4j.Logger log = LogManager.getLogger(this.getClass());
    private final ConfigurationRepository cr;
    private final AtomicBoolean initialized = new AtomicBoolean();
    private final EventBus eventBus = EVENT_BUS_BUILDER.logger((Logger)new Logger.JavaLogger(DynamicConfigFactory.class.getCanonicalName())).build();
    private final Settings opensearchSettings;
    private final Path configPath;
    private final InternalAuthenticationBackend iab;
    private final ClusterInfoHolder cih;
    private final ThreadPool threadPool;
    private final Client client;
    SecurityDynamicConfiguration<?> config;

    static void resetStatics() {
        staticRoles = SecurityDynamicConfiguration.empty(CType.ROLES);
        staticActionGroups = SecurityDynamicConfiguration.empty(CType.ACTIONGROUPS);
        staticTenants = SecurityDynamicConfiguration.empty(CType.TENANTS);
    }

    private void loadStaticConfig() throws IOException {
        JsonNode staticRolesJsonNode = DefaultObjectMapper.YAML_MAPPER.readTree(DynamicConfigFactory.class.getResourceAsStream("/static_config/static_roles.yml"));
        staticRoles = SecurityDynamicConfiguration.fromNode(staticRolesJsonNode, CType.ROLES, 2, 0L, 0L);
        JsonNode staticActionGroupsJsonNode = DefaultObjectMapper.YAML_MAPPER.readTree(DynamicConfigFactory.class.getResourceAsStream("/static_config/static_action_groups.yml"));
        staticActionGroups = SecurityDynamicConfiguration.fromNode(staticActionGroupsJsonNode, CType.ACTIONGROUPS, 2, 0L, 0L);
        JsonNode staticTenantsJsonNode = DefaultObjectMapper.YAML_MAPPER.readTree(DynamicConfigFactory.class.getResourceAsStream("/static_config/static_tenants.yml"));
        staticTenants = SecurityDynamicConfiguration.fromNode(staticTenantsJsonNode, CType.TENANTS, 2, 0L, 0L);
    }

    public static final <T> SecurityDynamicConfiguration<T> addStatics(SecurityDynamicConfiguration<T> original) {
        if (original.getCType() == CType.ACTIONGROUPS && !staticActionGroups.getCEntries().isEmpty()) {
            original.add(staticActionGroups.deepClone());
        }
        if (original.getCType() == CType.ROLES && !staticRoles.getCEntries().isEmpty()) {
            original.add(staticRoles.deepClone());
        }
        if (original.getCType() == CType.TENANTS && !staticTenants.getCEntries().isEmpty()) {
            original.add(staticTenants.deepClone());
        }
        return original;
    }

    public DynamicConfigFactory(ConfigurationRepository cr, Settings opensearchSettings, Path configPath, Client client, ThreadPool threadPool, ClusterInfoHolder cih, PasswordHasher passwordHasher) {
        this.cr = cr;
        this.opensearchSettings = opensearchSettings;
        this.configPath = configPath;
        this.cih = cih;
        this.iab = new InternalAuthenticationBackend(passwordHasher);
        this.threadPool = threadPool;
        this.client = client;
        if (opensearchSettings.getAsBoolean("plugins.security.unsupported.load_static_resources", Boolean.valueOf(true)).booleanValue()) {
            try {
                this.loadStaticConfig();
            }
            catch (IOException e) {
                throw new StaticResourceException("Unable to load static resources due to " + String.valueOf(e), e, new Object[0]);
            }
        } else {
            this.log.info("Static resources will not be loaded.");
        }
        ThreadContext threadContext = threadPool.getThreadContext();
        SecurityConfigVersionHandler versionHandler = new SecurityConfigVersionHandler(cr, opensearchSettings, threadContext, threadPool, client, this.cih);
        cr.subscribeOnChange(versionHandler);
        this.registerDCFListener(this.iab);
        this.cr.subscribeOnChange(this);
    }

    @Override
    public void onChange(ConfigurationMap typeToConfig) {
        SecurityDynamicConfiguration<ActionGroupsV7> actionGroups = this.cr.getConfiguration(CType.ACTIONGROUPS);
        this.config = this.cr.getConfiguration(CType.CONFIG);
        SecurityDynamicConfiguration<InternalUserV7> internalusers = this.cr.getConfiguration(CType.INTERNALUSERS);
        SecurityDynamicConfiguration<RoleV7> roles = this.cr.getConfiguration(CType.ROLES);
        SecurityDynamicConfiguration<RoleMappingsV7> rolesmapping = this.cr.getConfiguration(CType.ROLESMAPPING);
        SecurityDynamicConfiguration<TenantV7> tenants = this.cr.getConfiguration(CType.TENANTS);
        SecurityDynamicConfiguration<NodesDn> nodesDn = this.cr.getConfiguration(CType.NODESDN);
        SecurityDynamicConfiguration<AllowlistingSettings> allowlistingSetting = this.cr.getConfiguration(CType.ALLOWLIST);
        if (this.log.isDebugEnabled()) {
            String logmsg = "current config (because of " + String.valueOf(typeToConfig.keySet()) + ")\n actionGroups: " + String.valueOf(actionGroups.getImplementingClass()) + " with " + actionGroups.getCEntries().size() + " entries\n config: " + String.valueOf(this.config.getImplementingClass()) + " with " + this.config.getCEntries().size() + " entries\n internalusers: " + String.valueOf(internalusers.getImplementingClass()) + " with " + internalusers.getCEntries().size() + " entries\n roles: " + String.valueOf(roles.getImplementingClass()) + " with " + roles.getCEntries().size() + " entries\n rolesmapping: " + String.valueOf(rolesmapping.getImplementingClass()) + " with " + rolesmapping.getCEntries().size() + " entries\n tenants: " + String.valueOf(tenants.getImplementingClass()) + " with " + tenants.getCEntries().size() + " entries\n nodesdn: " + String.valueOf(nodesDn.getImplementingClass()) + " with " + nodesDn.getCEntries().size() + " entries\n allowlist " + String.valueOf(allowlistingSetting.getImplementingClass()) + " with " + allowlistingSetting.getCEntries().size() + " entries\n";
            this.log.debug(logmsg);
        }
        NodesDnModelImpl nm = new NodesDnModelImpl(nodesDn);
        AllowlistingSettings allowlist = this.cr.getConfiguration(CType.ALLOWLIST).getCEntry("config");
        AuditConfig audit = this.cr.getConfiguration(CType.AUDIT).getCEntry("config");
        if (roles.containsAny(staticRoles)) {
            throw new StaticResourceException("Cannot override static roles", new Object[0]);
        }
        if (!roles.add(staticRoles) && !staticRoles.getCEntries().isEmpty()) {
            throw new StaticResourceException("Unable to load static roles", new Object[0]);
        }
        this.log.debug("Static roles loaded ({})", (Object)staticRoles.getCEntries().size());
        if (actionGroups.containsAny(staticActionGroups)) {
            throw new StaticResourceException("Cannot override static action groups", new Object[0]);
        }
        if (!actionGroups.add(staticActionGroups) && !staticActionGroups.getCEntries().isEmpty()) {
            throw new StaticResourceException("Unable to load static action groups", new Object[0]);
        }
        this.log.debug("Static action groups loaded ({})", (Object)staticActionGroups.getCEntries().size());
        if (tenants.containsAny(staticTenants)) {
            throw new StaticResourceException("Cannot override static tenants", new Object[0]);
        }
        if (!tenants.add(staticTenants) && !staticTenants.getCEntries().isEmpty()) {
            throw new StaticResourceException("Unable to load static tenants", new Object[0]);
        }
        this.log.debug("Static tenants loaded ({})", (Object)staticTenants.getCEntries().size());
        this.log.debug("Static configuration loaded (total roles: {}/total action groups: {}/total tenants: {})", (Object)roles.getCEntries().size(), (Object)actionGroups.getCEntries().size(), (Object)tenants.getCEntries().size());
        DynamicConfigModelV7 dcm = new DynamicConfigModelV7(DynamicConfigFactory.getConfigV7(this.config), this.opensearchSettings, this.configPath, this.iab, this.cih);
        InternalUsersModelV7 ium = new InternalUsersModelV7(internalusers, roles, rolesmapping);
        ConfigModelV7 cm = new ConfigModelV7(roles, rolesmapping, dcm, this.opensearchSettings);
        this.eventBus.post((Object)cm);
        this.eventBus.post((Object)dcm);
        this.eventBus.post((Object)ium);
        this.eventBus.post((Object)nm);
        this.eventBus.post((Object)(allowlist == null ? defaultAllowlistingSettings : allowlist));
        if (this.cr.isAuditHotReloadingEnabled()) {
            this.eventBus.post((Object)(audit == null ? defaultAuditConfig : audit));
        }
        this.log.debug("Dispatched config update notification to different subscribers");
        this.initialized.set(true);
    }

    private static ConfigV7 getConfigV7(SecurityDynamicConfiguration<?> sdc) {
        SecurityDynamicConfiguration<?> c = sdc;
        return (ConfigV7)c.getCEntry("config");
    }

    @Override
    public boolean isInitialized() {
        return this.initialized.get();
    }

    public void registerDCFListener(Object listener) {
        this.eventBus.register(listener);
    }

    public void unregisterDCFListener(Object listener) {
        this.eventBus.unregister(listener);
    }

    private static class NodesDnModelImpl
    extends NodesDnModel {
        SecurityDynamicConfiguration<NodesDn> configuration;

        public NodesDnModelImpl(SecurityDynamicConfiguration<?> configuration) {
            this.configuration = null == configuration.getCType() ? SecurityDynamicConfiguration.empty(CType.NODESDN) : configuration;
        }

        @Override
        public Map<String, WildcardMatcher> getNodesDn() {
            return (Map)this.configuration.getCEntries().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> WildcardMatcher.from(((NodesDn)entry.getValue()).getNodesDn()).ignoreCase()));
        }
    }

    private static class InternalUsersModelV7
    extends InternalUsersModel {
        private final SecurityDynamicConfiguration<InternalUserV7> internalUserV7SecurityDynamicConfiguration;
        private final SecurityDynamicConfiguration<RoleV7> rolesV7SecurityDynamicConfiguration;
        private final SecurityDynamicConfiguration<RoleMappingsV7> rolesMappingsV7SecurityDynamicConfiguration;

        public InternalUsersModelV7(SecurityDynamicConfiguration<InternalUserV7> internalUserV7SecurityDynamicConfiguration, SecurityDynamicConfiguration<RoleV7> rolesV7SecurityDynamicConfiguration, SecurityDynamicConfiguration<RoleMappingsV7> rolesMappingsV7SecurityDynamicConfiguration) {
            this.internalUserV7SecurityDynamicConfiguration = internalUserV7SecurityDynamicConfiguration;
            this.rolesV7SecurityDynamicConfiguration = rolesV7SecurityDynamicConfiguration;
            this.rolesMappingsV7SecurityDynamicConfiguration = rolesMappingsV7SecurityDynamicConfiguration;
        }

        @Override
        public boolean exists(String user) {
            return this.internalUserV7SecurityDynamicConfiguration.exists(user);
        }

        @Override
        public ImmutableSet<String> getBackendRoles(String user) {
            InternalUserV7 tmp = this.internalUserV7SecurityDynamicConfiguration.getCEntry(user);
            return tmp == null ? ImmutableSet.of() : ImmutableSet.copyOf(tmp.getBackend_roles());
        }

        @Override
        public ImmutableMap<String, String> getAttributes(String user) {
            InternalUserV7 tmp = this.internalUserV7SecurityDynamicConfiguration.getCEntry(user);
            return tmp == null ? ImmutableMap.of() : ImmutableMap.copyOf(tmp.getAttributes());
        }

        @Override
        public String getDescription(String user) {
            InternalUserV7 tmp = this.internalUserV7SecurityDynamicConfiguration.getCEntry(user);
            return tmp == null ? null : tmp.getDescription();
        }

        @Override
        public String getHash(String user) {
            InternalUserV7 tmp = this.internalUserV7SecurityDynamicConfiguration.getCEntry(user);
            return tmp == null ? null : tmp.getHash();
        }

        @Override
        public ImmutableSet<String> getSecurityRoles(String user) {
            InternalUserV7 tmp = this.internalUserV7SecurityDynamicConfiguration.getCEntry(user);
            return tmp == null ? ImmutableSet.of() : (ImmutableSet)tmp.getOpendistro_security_roles().stream().filter(role -> !this.isRolesMappingHidden((String)role) && this.rolesV7SecurityDynamicConfiguration.exists((String)role)).collect(ImmutableSet.toImmutableSet());
        }

        private boolean isRolesMappingHidden(String rolename) {
            RoleMappingsV7 roleMapping = this.rolesMappingsV7SecurityDynamicConfiguration.getCEntry(rolename);
            return roleMapping != null && roleMapping.isHidden();
        }
    }
}

