/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server.logging;

import io.netty.handler.codec.http.HttpResponse;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.logging.AbstractAccessLogArgProvider;

final class AccessLogArgProviderH1
extends AbstractAccessLogArgProvider<AccessLogArgProviderH1> {
    @Nullable HttpServerRequest request;
    @Nullable HttpResponse response;

    AccessLogArgProviderH1(@Nullable SocketAddress remoteAddress) {
        super(remoteAddress);
    }

    AccessLogArgProviderH1(AccessLogArgProviderH1 copy) {
        super(copy);
        this.request = copy.request;
        this.response = copy.response;
    }

    AccessLogArgProviderH1 request(HttpServerRequest request) {
        this.request = Objects.requireNonNull(request, "request");
        this.onRequest();
        return this.get();
    }

    AccessLogArgProviderH1 response(HttpResponse response) {
        this.response = Objects.requireNonNull(response, "response");
        return this.get();
    }

    @Override
    public @Nullable CharSequence status() {
        return this.response == null ? null : this.response.status().codeAsText();
    }

    @Override
    public @Nullable CharSequence requestHeader(CharSequence name) {
        Objects.requireNonNull(name, "name");
        return this.request == null ? null : this.request.requestHeaders().get(name);
    }

    @Override
    public @Nullable CharSequence responseHeader(CharSequence name) {
        Objects.requireNonNull(name, "name");
        return this.response == null ? null : this.response.headers().get(name);
    }

    @Override
    public @Nullable Iterator<Map.Entry<CharSequence, CharSequence>> requestHeaderIterator() {
        return this.request == null ? null : this.request.requestHeaders().iteratorCharSequence();
    }

    @Override
    public @Nullable Iterator<Map.Entry<CharSequence, CharSequence>> responseHeaderIterator() {
        return this.response == null ? null : this.response.headers().iteratorCharSequence();
    }

    @Override
    void onRequest() {
        if (this.request != null) {
            this.accessDateTime = this.request.timestamp();
            this.zonedDateTime = this.accessDateTime.format(DATE_TIME_FORMATTER);
            this.startTime = this.accessDateTime.toInstant().toEpochMilli();
            this.method = this.request.method().name();
            this.uri = this.request.uri();
            this.protocol = this.request.protocol();
            this.cookies = this.request.cookies();
            this.connectionInfo = this.request;
        }
    }

    @Override
    void clear() {
        super.clear();
        this.request = null;
        this.response = null;
    }

    AccessLogArgProviderH1 contentLength(long contentLength) {
        this.contentLength = contentLength;
        return this.get();
    }

    @Override
    public AccessLogArgProviderH1 get() {
        return this;
    }
}

