/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.haproxy.HAProxyMessage;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.jspecify.annotations.Nullable;
import reactor.netty.transport.AddressUtils;

final class HAProxyMessageReader
extends ChannelInboundHandlerAdapter {
    private static final AttributeKey<@Nullable InetSocketAddress> REMOTE_ADDRESS_FROM_PROXY_PROTOCOL = AttributeKey.valueOf((String)"remoteAddressFromProxyProtocol");
    private static final boolean isProxyProtocolAvailable;

    HAProxyMessageReader() {
    }

    static boolean isProxyProtocolAvailable() {
        return isProxyProtocolAvailable;
    }

    static @Nullable SocketAddress resolveRemoteAddressFromProxyProtocol(Channel channel) {
        if (HAProxyMessageReader.isProxyProtocolAvailable()) {
            return (SocketAddress)channel.attr(REMOTE_ADDRESS_FROM_PROXY_PROTOCOL).getAndSet(null);
        }
        return null;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HAProxyMessage) {
            HAProxyMessage proxyMessage = (HAProxyMessage)msg;
            if (proxyMessage.sourceAddress() != null && proxyMessage.sourcePort() != 0) {
                InetSocketAddress remoteAddress = AddressUtils.createUnresolved((String)proxyMessage.sourceAddress(), (int)proxyMessage.sourcePort());
                ctx.channel().attr(REMOTE_ADDRESS_FROM_PROXY_PROTOCOL).set((Object)remoteAddress);
            }
            proxyMessage.release();
            ctx.channel().pipeline().remove((ChannelHandler)this);
            ctx.read();
        } else {
            super.channelRead(ctx, msg);
        }
    }

    static {
        boolean proxyProtocolCheck = true;
        try {
            Class.forName("io.netty.handler.codec.haproxy.HAProxyMessageDecoder");
        }
        catch (ClassNotFoundException cnfe) {
            proxyProtocolCheck = false;
        }
        isProxyProtocolAvailable = proxyProtocolCheck;
    }
}

