/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPrivateKeySpec;
import javax.security.auth.Destroyable;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.asymmetric.AsymmetricECPrivateKey;
import org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import org.bouncycastle.jcajce.provider.ECUtil;
import org.bouncycastle.jcajce.provider.KeyUtil;
import org.bouncycastle.jcajce.provider.ProvKey;

class ProvECPrivateKey
implements Destroyable,
ECPrivateKey,
ProvKey<AsymmetricECPrivateKey> {
    static final long serialVersionUID = 994553197664784084L;
    private transient AsymmetricECPrivateKey baseKey;

    ProvECPrivateKey(Algorithm algorithm, ECPrivateKey eCPrivateKey) {
        ECDomainParameters eCDomainParameters = ECUtil.convertFromSpec(eCPrivateKey.getParams());
        this.baseKey = new AsymmetricECPrivateKey(algorithm, eCDomainParameters, eCPrivateKey.getS());
    }

    ProvECPrivateKey(Algorithm algorithm, ECPrivateKeySpec eCPrivateKeySpec) {
        this.baseKey = new AsymmetricECPrivateKey(algorithm, ECUtil.convertFromSpec(eCPrivateKeySpec.getParams()), eCPrivateKeySpec.getS());
    }

    ProvECPrivateKey(AsymmetricECPrivateKey asymmetricECPrivateKey) {
        this.baseKey = asymmetricECPrivateKey;
    }

    @Override
    public AsymmetricECPrivateKey getBaseKey() {
        KeyUtil.checkDestroyed(this);
        return this.baseKey;
    }

    @Override
    public String getAlgorithm() {
        KeyUtil.checkDestroyed(this);
        return "EC";
    }

    @Override
    public String getFormat() {
        KeyUtil.checkDestroyed(this);
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        return this.baseKey.getEncoded();
    }

    @Override
    public ECParameterSpec getParams() {
        return ECUtil.convertToSpec(this.baseKey.getDomainParameters());
    }

    @Override
    public BigInteger getS() {
        return this.baseKey.getS();
    }

    @Override
    public void destroy() {
        this.baseKey.destroy();
    }

    @Override
    public boolean isDestroyed() {
        return this.baseKey.isDestroyed();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ProvECPrivateKey) {
            ProvECPrivateKey provECPrivateKey = (ProvECPrivateKey)object;
            return this.baseKey.equals(provECPrivateKey.baseKey);
        }
        return false;
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    public String toString() {
        if (this.isDestroyed()) {
            return KeyUtil.destroyedPrivateKeyToString("EC");
        }
        try {
            return KeyUtil.privateKeyToString("EC", this.baseKey.getS(), this.baseKey.getDomainParameters());
        }
        catch (Exception exception) {
            return KeyUtil.restrictedToString("EC");
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Algorithm algorithm = (Algorithm)objectInputStream.readObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.baseKey = new AsymmetricECPrivateKey(algorithm, byArray);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.isDestroyed()) {
            throw new IOException("key has been destroyed");
        }
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.baseKey.getAlgorithm());
        objectOutputStream.writeObject(this.getEncoded());
    }
}

