/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.search;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.core.search.Collector;
import org.opensearch.client.opensearch.core.search.QueryProfile;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class SearchProfile
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, SearchProfile> {
    @Nonnull
    private final List<Collector> collector;
    @Nonnull
    private final List<QueryProfile> query;
    private final long rewriteTime;
    public static final JsonpDeserializer<SearchProfile> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SearchProfile::setupSearchProfileDeserializer);

    private SearchProfile(Builder builder) {
        this.collector = ApiTypeHelper.unmodifiableRequired(builder.collector, (Object)this, "collector");
        this.query = ApiTypeHelper.unmodifiableRequired(builder.query, (Object)this, "query");
        this.rewriteTime = ApiTypeHelper.requireNonNull(builder.rewriteTime, this, "rewriteTime");
    }

    public static SearchProfile of(Function<Builder, ObjectBuilder<SearchProfile>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<Collector> collector() {
        return this.collector;
    }

    @Nonnull
    public final List<QueryProfile> query() {
        return this.query;
    }

    public final long rewriteTime() {
        return this.rewriteTime;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("collector");
        generator.writeStartArray();
        for (Collector collector : this.collector) {
            collector.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("query");
        generator.writeStartArray();
        for (QueryProfile queryProfile : this.query) {
            queryProfile.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("rewrite_time");
        generator.write(this.rewriteTime);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupSearchProfileDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::collector, JsonpDeserializer.arrayDeserializer(Collector._DESERIALIZER), "collector");
        op.add(Builder::query, JsonpDeserializer.arrayDeserializer(QueryProfile._DESERIALIZER), "query");
        op.add(Builder::rewriteTime, JsonpDeserializer.longDeserializer(), "rewrite_time");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.collector.hashCode();
        result = 31 * result + this.query.hashCode();
        result = 31 * result + Long.hashCode(this.rewriteTime);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchProfile other = (SearchProfile)o;
        return this.collector.equals(other.collector) && this.query.equals(other.query) && this.rewriteTime == other.rewriteTime;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, SearchProfile> {
        private List<Collector> collector;
        private List<QueryProfile> query;
        private Long rewriteTime;

        public Builder() {
        }

        private Builder(SearchProfile o) {
            this.collector = Builder._listCopy(o.collector);
            this.query = Builder._listCopy(o.query);
            this.rewriteTime = o.rewriteTime;
        }

        private Builder(Builder o) {
            this.collector = Builder._listCopy(o.collector);
            this.query = Builder._listCopy(o.query);
            this.rewriteTime = o.rewriteTime;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder collector(List<Collector> list) {
            this.collector = Builder._listAddAll(this.collector, list);
            return this;
        }

        @Nonnull
        public final Builder collector(Collector value, Collector ... values) {
            this.collector = Builder._listAdd(this.collector, value, values);
            return this;
        }

        @Nonnull
        public final Builder collector(Function<Collector.Builder, ObjectBuilder<Collector>> fn) {
            return this.collector(fn.apply(new Collector.Builder()).build(), new Collector[0]);
        }

        @Nonnull
        public final Builder query(List<QueryProfile> list) {
            this.query = Builder._listAddAll(this.query, list);
            return this;
        }

        @Nonnull
        public final Builder query(QueryProfile value, QueryProfile ... values) {
            this.query = Builder._listAdd(this.query, value, values);
            return this;
        }

        @Nonnull
        public final Builder query(Function<QueryProfile.Builder, ObjectBuilder<QueryProfile>> fn) {
            return this.query(fn.apply(new QueryProfile.Builder()).build(), new QueryProfile[0]);
        }

        @Nonnull
        public final Builder rewriteTime(long value) {
            this.rewriteTime = value;
            return this;
        }

        @Override
        @Nonnull
        public SearchProfile build() {
            this._checkSingleUse();
            return new SearchProfile(this);
        }
    }
}

