/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.mapping;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.mapping.KnnVectorMethod;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class SemanticDenseEmbeddingConfig
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, SemanticDenseEmbeddingConfig> {
    @Nullable
    private final String compressionLevel;
    @Nullable
    private final String dataType;
    @Nullable
    private final KnnVectorMethod method;
    @Nullable
    private final String mode;
    public static final JsonpDeserializer<SemanticDenseEmbeddingConfig> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SemanticDenseEmbeddingConfig::setupSemanticDenseEmbeddingConfigDeserializer);

    private SemanticDenseEmbeddingConfig(Builder builder) {
        this.compressionLevel = builder.compressionLevel;
        this.dataType = builder.dataType;
        this.method = builder.method;
        this.mode = builder.mode;
    }

    public static SemanticDenseEmbeddingConfig of(Function<Builder, ObjectBuilder<SemanticDenseEmbeddingConfig>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String compressionLevel() {
        return this.compressionLevel;
    }

    @Nullable
    public final String dataType() {
        return this.dataType;
    }

    @Nullable
    public final KnnVectorMethod method() {
        return this.method;
    }

    @Nullable
    public final String mode() {
        return this.mode;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.compressionLevel != null) {
            generator.writeKey("compression_level");
            generator.write(this.compressionLevel);
        }
        if (this.dataType != null) {
            generator.writeKey("data_type");
            generator.write(this.dataType);
        }
        if (this.method != null) {
            generator.writeKey("method");
            this.method.serialize(generator, mapper);
        }
        if (this.mode != null) {
            generator.writeKey("mode");
            generator.write(this.mode);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupSemanticDenseEmbeddingConfigDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::compressionLevel, JsonpDeserializer.stringDeserializer(), "compression_level");
        op.add(Builder::dataType, JsonpDeserializer.stringDeserializer(), "data_type");
        op.add(Builder::method, KnnVectorMethod._DESERIALIZER, "method");
        op.add(Builder::mode, JsonpDeserializer.stringDeserializer(), "mode");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.compressionLevel);
        result = 31 * result + Objects.hashCode(this.dataType);
        result = 31 * result + Objects.hashCode(this.method);
        result = 31 * result + Objects.hashCode(this.mode);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SemanticDenseEmbeddingConfig other = (SemanticDenseEmbeddingConfig)o;
        return Objects.equals(this.compressionLevel, other.compressionLevel) && Objects.equals(this.dataType, other.dataType) && Objects.equals(this.method, other.method) && Objects.equals(this.mode, other.mode);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, SemanticDenseEmbeddingConfig> {
        @Nullable
        private String compressionLevel;
        @Nullable
        private String dataType;
        @Nullable
        private KnnVectorMethod method;
        @Nullable
        private String mode;

        public Builder() {
        }

        private Builder(SemanticDenseEmbeddingConfig o) {
            this.compressionLevel = o.compressionLevel;
            this.dataType = o.dataType;
            this.method = o.method;
            this.mode = o.mode;
        }

        private Builder(Builder o) {
            this.compressionLevel = o.compressionLevel;
            this.dataType = o.dataType;
            this.method = o.method;
            this.mode = o.mode;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder compressionLevel(@Nullable String value) {
            this.compressionLevel = value;
            return this;
        }

        @Nonnull
        public final Builder dataType(@Nullable String value) {
            this.dataType = value;
            return this;
        }

        @Nonnull
        public final Builder method(@Nullable KnnVectorMethod value) {
            this.method = value;
            return this;
        }

        @Nonnull
        public final Builder method(Function<KnnVectorMethod.Builder, ObjectBuilder<KnnVectorMethod>> fn) {
            return this.method(fn.apply(new KnnVectorMethod.Builder()).build());
        }

        @Nonnull
        public final Builder mode(@Nullable String value) {
            this.mode = value;
            return this;
        }

        @Override
        @Nonnull
        public SemanticDenseEmbeddingConfig build() {
            this._checkSingleUse();
            return new SemanticDenseEmbeddingConfig(this);
        }
    }
}

