/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor.factory;

import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ingest.ConfigurationUtils;
import org.opensearch.neuralsearch.processor.NormalizationProcessorWorkflow;
import org.opensearch.neuralsearch.processor.RRFProcessor;
import org.opensearch.neuralsearch.processor.combination.ScoreCombinationFactory;
import org.opensearch.neuralsearch.processor.combination.ScoreCombinationTechnique;
import org.opensearch.neuralsearch.processor.normalization.ScoreNormalizationFactory;
import org.opensearch.neuralsearch.processor.normalization.ScoreNormalizationTechnique;
import org.opensearch.search.pipeline.Processor;
import org.opensearch.search.pipeline.SearchPhaseResultsProcessor;

public class RRFProcessorFactory
implements Processor.Factory<SearchPhaseResultsProcessor> {
    @Generated
    private static final Logger log = LogManager.getLogger(RRFProcessorFactory.class);
    public static final String COMBINATION_CLAUSE = "combination";
    public static final String TECHNIQUE = "technique";
    public static final String PARAMETERS = "parameters";
    private final NormalizationProcessorWorkflow normalizationProcessorWorkflow;
    private ScoreNormalizationFactory scoreNormalizationFactory;
    private ScoreCombinationFactory scoreCombinationFactory;

    public SearchPhaseResultsProcessor create(Map<String, Processor.Factory<SearchPhaseResultsProcessor>> processorFactories, String tag, String description, boolean ignoreFailure, Map<String, Object> config, Processor.PipelineContext pipelineContext) throws Exception {
        ScoreNormalizationTechnique normalizationTechnique = this.scoreNormalizationFactory.createNormalization("rrf");
        ScoreCombinationTechnique scoreCombinationTechnique = this.scoreCombinationFactory.createCombination("rrf");
        Map combinationClause = ConfigurationUtils.readOptionalMap((String)"score-ranker-processor", (String)tag, config, (String)COMBINATION_CLAUSE);
        if (Objects.nonNull(combinationClause)) {
            String combinationTechnique = ConfigurationUtils.readStringProperty((String)"score-ranker-processor", (String)tag, (Map)combinationClause, (String)TECHNIQUE, (String)"rrf");
            String rankConstantParam = "rank_constant";
            if (combinationClause.containsKey(rankConstantParam)) {
                normalizationTechnique = this.scoreNormalizationFactory.createNormalization("rrf", Map.of(rankConstantParam, combinationClause.get(rankConstantParam)));
            }
            Map params = ConfigurationUtils.readOptionalMap((String)"score-ranker-processor", (String)tag, (Map)combinationClause, (String)PARAMETERS);
            scoreCombinationTechnique = this.scoreCombinationFactory.createCombination(combinationTechnique, params);
        }
        log.info("Creating search phase results processor of type [{}] with normalization [{}] and combination [{}]", (Object)"score-ranker-processor", (Object)normalizationTechnique, (Object)scoreCombinationTechnique);
        return new RRFProcessor(tag, description, normalizationTechnique, scoreCombinationTechnique, this.normalizationProcessorWorkflow);
    }

    @Generated
    public RRFProcessorFactory(NormalizationProcessorWorkflow normalizationProcessorWorkflow, ScoreNormalizationFactory scoreNormalizationFactory, ScoreCombinationFactory scoreCombinationFactory) {
        this.normalizationProcessorWorkflow = normalizationProcessorWorkflow;
        this.scoreNormalizationFactory = scoreNormalizationFactory;
        this.scoreCombinationFactory = scoreCombinationFactory;
    }
}

