/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.classification.sgd.crf;

import com.oracle.labs.mlrg.olcut.config.ConfigurationManager;
import com.oracle.labs.mlrg.olcut.config.Option;
import com.oracle.labs.mlrg.olcut.config.Options;
import com.oracle.labs.mlrg.olcut.config.UsageException;
import com.oracle.labs.mlrg.olcut.util.LabsLogFormatter;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Path;
import java.util.logging.Logger;
import org.tribuo.ImmutableFeatureMap;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.classification.sequence.LabelSequenceEvaluation;
import org.tribuo.classification.sequence.LabelSequenceEvaluator;
import org.tribuo.classification.sequence.example.SequenceDataGenerator;
import org.tribuo.classification.sgd.crf.CRFModel;
import org.tribuo.classification.sgd.crf.CRFTrainer;
import org.tribuo.hash.HashCodeHasher;
import org.tribuo.hash.Hasher;
import org.tribuo.hash.HashingOptions;
import org.tribuo.hash.MessageDigestHasher;
import org.tribuo.math.optimisers.GradientOptimiserOptions;
import org.tribuo.sequence.HashingSequenceTrainer;
import org.tribuo.sequence.ImmutableSequenceDataset;
import org.tribuo.sequence.SequenceDataset;
import org.tribuo.sequence.SequenceModel;
import org.tribuo.sequence.SequenceTrainer;
import org.tribuo.util.Util;

public class SeqTest {
    private static final Logger logger = Logger.getLogger(SeqTest.class.getName());

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) throws ClassNotFoundException, IOException {
        LabsLogFormatter.setAllLogFormatters();
        o = new CRFOptions();
        try {
            cm = new ConfigurationManager(args, (Options)o);
        }
        catch (UsageException e) {
            SeqTest.logger.info(e.getMessage());
            return;
        }
        SeqTest.logger.info("Configuring gradient optimiser");
        grad = o.gradientOptions.getOptimiser();
        SeqTest.logger.info(String.format("Set logging interval to %d", new Object[]{o.loggingInterval}));
        var6_5 = o.datasetName;
        var7_6 = -1;
        switch (var6_5.hashCode()) {
            case 1874604354: {
                if (!var6_5.equals("Gorilla")) break;
                var7_6 = 0;
                break;
            }
            case 209951074: {
                if (!var6_5.equals("gorilla")) break;
                var7_6 = 1;
            }
        }
        switch (var7_6) {
            case 0: 
            case 1: {
                SeqTest.logger.info("Generating gorilla dataset");
                train = SequenceDataGenerator.generateGorillaDataset((int)1);
                test = SequenceDataGenerator.generateGorillaDataset((int)1);
                break;
            }
            default: {
                if (o.trainDataset == null || o.testDataset == null) ** GOTO lbl84
                SeqTest.logger.info("Loading training data from " + o.trainDataset);
                ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(o.trainDataset.toFile())));
                var9_11 = null;
                oits = new ObjectInputStream(new BufferedInputStream(new FileInputStream(o.testDataset.toFile())));
                var11_16 = null;
                try {
                    train = (SequenceDataset)ois.readObject();
                    SeqTest.logger.info(String.format("Loaded %d training examples for %s", new Object[]{train.size(), train.getOutputs().toString()}));
                    SeqTest.logger.info("Found " + train.getFeatureIDMap().size() + " features");
                    SeqTest.logger.info("Loading testing data from " + o.testDataset);
                    deserTest = (SequenceDataset)oits.readObject();
                    test = ImmutableSequenceDataset.copyDataset((SequenceDataset)deserTest, (ImmutableFeatureMap)train.getFeatureIDMap(), (ImmutableOutputInfo)train.getOutputIDInfo());
                    SeqTest.logger.info(String.format("Loaded %d testing examples", new Object[]{test.size()}));
                }
                catch (Throwable deserTest) {
                    var11_16 = deserTest;
                    throw deserTest;
                }
                finally {
                    if (oits != null) {
                        if (var11_16 != null) {
                            try {
                                oits.close();
                            }
                            catch (Throwable deserTest) {
                                var11_16.addSuppressed(deserTest);
                            }
                        } else {
                            oits.close();
                        }
                    }
                }
                if (ois == null) break;
                if (var9_11 == null) ** GOTO lbl67
                try {
                    ois.close();
                }
                catch (Throwable oits) {
                    var9_11.addSuppressed(oits);
                }
                break;
lbl67:
                // 1 sources

                ois.close();
                break;
                catch (Throwable oits) {
                    try {
                        var9_11 = oits;
                        throw oits;
                    }
                    catch (Throwable var15_23) {
                        if (ois != null) {
                            if (var9_11 != null) {
                                try {
                                    ois.close();
                                }
                                catch (Throwable var16_25) {
                                    var9_11.addSuppressed(var16_25);
                                }
                            } else {
                                ois.close();
                            }
                        }
                        throw var15_23;
                    }
                }
lbl84:
                // 1 sources

                SeqTest.logger.warning("Unknown dataset " + o.datasetName);
                SeqTest.logger.info(cm.usage());
                return;
            }
        }
        trainer = new CRFTrainer(grad, o.epochs, o.loggingInterval, o.seed);
        trainer.setShuffle(o.shuffle);
        switch (1.$SwitchMap$org$tribuo$hash$HashingOptions$ModelHashingType[o.modelHashingAlgorithm.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                trainer = new HashingSequenceTrainer((SequenceTrainer)trainer, (Hasher)new HashCodeHasher(o.modelHashingSalt));
                break;
            }
            case 3: {
                trainer = new HashingSequenceTrainer((SequenceTrainer)trainer, (Hasher)new MessageDigestHasher("SHA1", o.modelHashingSalt));
                break;
            }
            case 4: {
                trainer = new HashingSequenceTrainer((SequenceTrainer)trainer, (Hasher)new MessageDigestHasher("SHA-256", o.modelHashingSalt));
                break;
            }
            default: {
                SeqTest.logger.info("Unknown hasher " + o.modelHashingAlgorithm);
            }
        }
        SeqTest.logger.info("Training using " + trainer.toString());
        trainStart = System.currentTimeMillis();
        model = (CRFModel)trainer.train((SequenceDataset)train);
        trainStop = System.currentTimeMillis();
        SeqTest.logger.info("Finished training classifier " + Util.formatDuration((long)trainStart, (long)trainStop));
        if (o.logModel) {
            System.out.println("FeatureMap = " + model.getFeatureIDMap().toString());
            System.out.println("LabelMap = " + model.getOutputIDInfo().toString());
            System.out.println("Features - " + model.generateWeightsString());
        }
        labelEvaluator = new LabelSequenceEvaluator();
        testStart = System.currentTimeMillis();
        evaluation = (LabelSequenceEvaluation)labelEvaluator.evaluate((SequenceModel)model, (SequenceDataset)test);
        testStop = System.currentTimeMillis();
        SeqTest.logger.info("Finished evaluating model " + Util.formatDuration((long)testStart, (long)testStop));
        System.out.println(evaluation.toString());
        System.out.println();
        System.out.println(evaluation.getConfusionMatrix().toString());
        if (o.outputPath != null) {
            fout = new FileOutputStream(o.outputPath.toFile());
            oout = new ObjectOutputStream(fout);
            oout.writeObject((Object)model);
            oout.close();
            fout.close();
            SeqTest.logger.info("Serialized model to file: " + o.outputPath);
        }
    }

    public static class CRFOptions
    implements Options {
        public GradientOptimiserOptions gradientOptions;
        @Option(charName=100, longName="dataset-name", usage="Name of the example dataset, options are {gorilla}.")
        public String datasetName = "";
        @Option(charName=102, longName="output-path", usage="Path to serialize model to.")
        public Path outputPath;
        @Option(charName=105, longName="epochs", usage="Number of SGD epochs.")
        public int epochs = 5;
        @Option(charName=111, longName="print-model", usage="Print out feature, label and other model details.")
        public boolean logModel = false;
        @Option(charName=112, longName="logging-interval", usage="Log the objective after <int> examples.")
        public int loggingInterval = 100;
        @Option(charName=114, longName="seed", usage="RNG seed.")
        public long seed = 1L;
        @Option(longName="shuffle", usage="Shuffle the data each epoch (default: true).")
        public boolean shuffle = true;
        @Option(charName=117, longName="train-dataset", usage="Path to a serialised SequenceDataset used for training.")
        public Path trainDataset = null;
        @Option(charName=118, longName="test-dataset", usage="Path to a serialised SequenceDataset used for testing.")
        public Path testDataset = null;
        @Option(longName="model-hashing-algorithm", usage="Hash the model during training. Defaults to no hashing.")
        public HashingOptions.ModelHashingType modelHashingAlgorithm = HashingOptions.ModelHashingType.NONE;
        @Option(longName="model-hashing-salt", usage="Salt for hashing the model.")
        public String modelHashingSalt = "";

        public String getOptionsDescription() {
            return "Tests a linear chain CRF model on the specified dataset.";
        }
    }
}

