/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives;

import Wrappers_Compile.Option;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import java.nio.ByteBuffer;
import java.util.Objects;
import software.amazon.cryptography.primitives.AtomicPrimitives;
import software.amazon.cryptography.primitives.internaldafny.types.AESEncryptInput;
import software.amazon.cryptography.primitives.internaldafny.types.AES__CTR;
import software.amazon.cryptography.primitives.internaldafny.types.AES__GCM;
import software.amazon.cryptography.primitives.internaldafny.types.CompressPublicKeyInput;
import software.amazon.cryptography.primitives.internaldafny.types.CompressPublicKeyOutput;
import software.amazon.cryptography.primitives.internaldafny.types.CryptoConfig;
import software.amazon.cryptography.primitives.internaldafny.types.DecompressPublicKeyInput;
import software.amazon.cryptography.primitives.internaldafny.types.DeriveSharedSecretInput;
import software.amazon.cryptography.primitives.internaldafny.types.DigestInput;
import software.amazon.cryptography.primitives.internaldafny.types.ECCPrivateKey;
import software.amazon.cryptography.primitives.internaldafny.types.ECCPublicKey;
import software.amazon.cryptography.primitives.internaldafny.types.ECDHCurveSpec;
import software.amazon.cryptography.primitives.internaldafny.types.ECDSASignatureAlgorithm;
import software.amazon.cryptography.primitives.internaldafny.types.ECDSAVerifyInput;
import software.amazon.cryptography.primitives.internaldafny.types.Error;
import software.amazon.cryptography.primitives.internaldafny.types.Error_AwsCryptographicPrimitivesError;
import software.amazon.cryptography.primitives.internaldafny.types.GenerateRSAKeyPairInput;
import software.amazon.cryptography.primitives.internaldafny.types.GenerateRSAKeyPairOutput;
import software.amazon.cryptography.primitives.internaldafny.types.GenerateRandomBytesInput;
import software.amazon.cryptography.primitives.internaldafny.types.GetPublicKeyFromPrivateKeyInput;
import software.amazon.cryptography.primitives.internaldafny.types.GetPublicKeyFromPrivateKeyOutput;
import software.amazon.cryptography.primitives.internaldafny.types.HMacInput;
import software.amazon.cryptography.primitives.internaldafny.types.HkdfExtractInput;
import software.amazon.cryptography.primitives.internaldafny.types.IAwsCryptographicPrimitivesClient;
import software.amazon.cryptography.primitives.internaldafny.types.ParsePublicKeyInput;
import software.amazon.cryptography.primitives.internaldafny.types.RSADecryptInput;
import software.amazon.cryptography.primitives.internaldafny.types.RSAPaddingMode;
import software.amazon.cryptography.primitives.internaldafny.types.ValidatePublicKeyInput;
import software.amazon.cryptography.primitives.model.AESDecryptInput;
import software.amazon.cryptography.primitives.model.AESEncryptOutput;
import software.amazon.cryptography.primitives.model.AES_CTR;
import software.amazon.cryptography.primitives.model.AES_GCM;
import software.amazon.cryptography.primitives.model.AesKdfCtrInput;
import software.amazon.cryptography.primitives.model.AwsCryptographicPrimitivesError;
import software.amazon.cryptography.primitives.model.CollectionOfErrors;
import software.amazon.cryptography.primitives.model.DecompressPublicKeyOutput;
import software.amazon.cryptography.primitives.model.DeriveSharedSecretOutput;
import software.amazon.cryptography.primitives.model.DigestAlgorithm;
import software.amazon.cryptography.primitives.model.ECDSASignInput;
import software.amazon.cryptography.primitives.model.GenerateECCKeyPairInput;
import software.amazon.cryptography.primitives.model.GenerateECCKeyPairOutput;
import software.amazon.cryptography.primitives.model.GenerateECDSASignatureKeyInput;
import software.amazon.cryptography.primitives.model.GenerateECDSASignatureKeyOutput;
import software.amazon.cryptography.primitives.model.GetRSAKeyModulusLengthInput;
import software.amazon.cryptography.primitives.model.GetRSAKeyModulusLengthOutput;
import software.amazon.cryptography.primitives.model.HkdfExpandInput;
import software.amazon.cryptography.primitives.model.HkdfInput;
import software.amazon.cryptography.primitives.model.KdfCtrInput;
import software.amazon.cryptography.primitives.model.OpaqueError;
import software.amazon.cryptography.primitives.model.OpaqueWithTextError;
import software.amazon.cryptography.primitives.model.ParsePublicKeyOutput;
import software.amazon.cryptography.primitives.model.RSAEncryptInput;
import software.amazon.cryptography.primitives.model.RSAPrivateKey;
import software.amazon.cryptography.primitives.model.RSAPublicKey;
import software.amazon.cryptography.primitives.model.ValidatePublicKeyOutput;
import software.amazon.smithy.dafny.conversion.ToDafny;

public class ToDafny {
    public static Error Error(RuntimeException nativeValue) {
        if (nativeValue instanceof AwsCryptographicPrimitivesError) {
            return ToDafny.Error((AwsCryptographicPrimitivesError)nativeValue);
        }
        if (nativeValue instanceof OpaqueError) {
            return ToDafny.Error((OpaqueError)nativeValue);
        }
        if (nativeValue instanceof OpaqueWithTextError) {
            return ToDafny.Error((OpaqueWithTextError)nativeValue);
        }
        if (nativeValue instanceof CollectionOfErrors) {
            return ToDafny.Error((CollectionOfErrors)nativeValue);
        }
        return Error.create_Opaque(nativeValue);
    }

    public static Error Error(OpaqueError nativeValue) {
        return Error.create_Opaque(nativeValue.obj());
    }

    public static Error Error(OpaqueWithTextError nativeValue) {
        return Error.create_OpaqueWithText(nativeValue.obj(), (DafnySequence<? extends Character>)DafnySequence.asString((String)nativeValue.objMessage()));
    }

    public static Error Error(CollectionOfErrors nativeValue) {
        DafnySequence list = ToDafny.Aggregate.GenericToSequence(nativeValue.list(), ToDafny::Error, Error._typeDescriptor());
        DafnySequence message = ToDafny.Simple.CharacterSequence((String)nativeValue.getMessage());
        return Error.create_CollectionOfErrors((DafnySequence<? extends Error>)list, (DafnySequence<? extends Character>)message);
    }

    public static AES__CTR AES_CTR(AES_CTR nativeValue) {
        Integer keyLength = nativeValue.keyLength();
        Integer nonceLength = nativeValue.nonceLength();
        return new AES__CTR(keyLength, nonceLength);
    }

    public static AES__GCM AES_GCM(AES_GCM nativeValue) {
        Integer keyLength = nativeValue.keyLength();
        Integer tagLength = nativeValue.tagLength();
        Integer ivLength = nativeValue.ivLength();
        return new AES__GCM(keyLength, tagLength, ivLength);
    }

    public static software.amazon.cryptography.primitives.internaldafny.types.AESDecryptInput AESDecryptInput(AESDecryptInput nativeValue) {
        AES__GCM encAlg = ToDafny.AES_GCM(nativeValue.encAlg());
        DafnySequence key = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.key());
        DafnySequence cipherTxt = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.cipherTxt());
        DafnySequence authTag = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.authTag());
        DafnySequence iv = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.iv());
        DafnySequence aad = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.aad());
        return new software.amazon.cryptography.primitives.internaldafny.types.AESDecryptInput(encAlg, (DafnySequence<? extends Byte>)key, (DafnySequence<? extends Byte>)cipherTxt, (DafnySequence<? extends Byte>)authTag, (DafnySequence<? extends Byte>)iv, (DafnySequence<? extends Byte>)aad);
    }

    public static DafnySequence<? extends Byte> AESDecryptOutput(ByteBuffer nativeValue) {
        DafnySequence plaintext = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue);
        return plaintext;
    }

    public static AESEncryptInput AESEncryptInput(software.amazon.cryptography.primitives.model.AESEncryptInput nativeValue) {
        AES__GCM encAlg = ToDafny.AES_GCM(nativeValue.encAlg());
        DafnySequence iv = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.iv());
        DafnySequence key = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.key());
        DafnySequence msg = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.msg());
        DafnySequence aad = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.aad());
        return new AESEncryptInput(encAlg, (DafnySequence<? extends Byte>)iv, (DafnySequence<? extends Byte>)key, (DafnySequence<? extends Byte>)msg, (DafnySequence<? extends Byte>)aad);
    }

    public static software.amazon.cryptography.primitives.internaldafny.types.AESEncryptOutput AESEncryptOutput(AESEncryptOutput nativeValue) {
        DafnySequence cipherText = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.cipherText());
        DafnySequence authTag = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.authTag());
        return new software.amazon.cryptography.primitives.internaldafny.types.AESEncryptOutput((DafnySequence<? extends Byte>)cipherText, (DafnySequence<? extends Byte>)authTag);
    }

    public static software.amazon.cryptography.primitives.internaldafny.types.AesKdfCtrInput AesKdfCtrInput(AesKdfCtrInput nativeValue) {
        DafnySequence ikm = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.ikm());
        Integer expectedLength = nativeValue.expectedLength();
        Option<DafnySequence<? extends Byte>> nonce = Objects.nonNull(nativeValue.nonce()) ? Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE), ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.nonce())) : Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE));
        return new software.amazon.cryptography.primitives.internaldafny.types.AesKdfCtrInput((DafnySequence<? extends Byte>)ikm, expectedLength, nonce);
    }

    public static DafnySequence<? extends Byte> AesKdfCtrOutput(ByteBuffer nativeValue) {
        DafnySequence okm = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue);
        return okm;
    }

    public static CompressPublicKeyInput CompressPublicKeyInput(software.amazon.cryptography.primitives.model.CompressPublicKeyInput nativeValue) {
        ECCPublicKey publicKey = ToDafny.ECCPublicKey(nativeValue.publicKey());
        ECDHCurveSpec eccCurve = ToDafny.ECDHCurveSpec(nativeValue.eccCurve());
        return new CompressPublicKeyInput(publicKey, eccCurve);
    }

    public static CompressPublicKeyOutput CompressPublicKeyOutput(software.amazon.cryptography.primitives.model.CompressPublicKeyOutput nativeValue) {
        DafnySequence compressedPublicKey = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.compressedPublicKey());
        return new CompressPublicKeyOutput((DafnySequence<? extends Byte>)compressedPublicKey);
    }

    public static CryptoConfig CryptoConfig(software.amazon.cryptography.primitives.model.CryptoConfig nativeValue) {
        return new CryptoConfig();
    }

    public static DecompressPublicKeyInput DecompressPublicKeyInput(software.amazon.cryptography.primitives.model.DecompressPublicKeyInput nativeValue) {
        DafnySequence compressedPublicKey = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.compressedPublicKey());
        ECDHCurveSpec eccCurve = ToDafny.ECDHCurveSpec(nativeValue.eccCurve());
        return new DecompressPublicKeyInput((DafnySequence<? extends Byte>)compressedPublicKey, eccCurve);
    }

    public static software.amazon.cryptography.primitives.internaldafny.types.DecompressPublicKeyOutput DecompressPublicKeyOutput(DecompressPublicKeyOutput nativeValue) {
        ECCPublicKey publicKey = ToDafny.ECCPublicKey(nativeValue.publicKey());
        return new software.amazon.cryptography.primitives.internaldafny.types.DecompressPublicKeyOutput(publicKey);
    }

    public static DeriveSharedSecretInput DeriveSharedSecretInput(software.amazon.cryptography.primitives.model.DeriveSharedSecretInput nativeValue) {
        ECDHCurveSpec eccCurve = ToDafny.ECDHCurveSpec(nativeValue.eccCurve());
        ECCPrivateKey privateKey = ToDafny.ECCPrivateKey(nativeValue.privateKey());
        ECCPublicKey publicKey = ToDafny.ECCPublicKey(nativeValue.publicKey());
        return new DeriveSharedSecretInput(eccCurve, privateKey, publicKey);
    }

    public static software.amazon.cryptography.primitives.internaldafny.types.DeriveSharedSecretOutput DeriveSharedSecretOutput(DeriveSharedSecretOutput nativeValue) {
        DafnySequence sharedSecret = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.sharedSecret());
        return new software.amazon.cryptography.primitives.internaldafny.types.DeriveSharedSecretOutput((DafnySequence<? extends Byte>)sharedSecret);
    }

    public static DigestInput DigestInput(software.amazon.cryptography.primitives.model.DigestInput nativeValue) {
        software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm digestAlgorithm = ToDafny.DigestAlgorithm(nativeValue.digestAlgorithm());
        DafnySequence message = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.message());
        return new DigestInput(digestAlgorithm, (DafnySequence<? extends Byte>)message);
    }

    public static DafnySequence<? extends Byte> DigestOutput(ByteBuffer nativeValue) {
        DafnySequence digest = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue);
        return digest;
    }

    public static ECCPrivateKey ECCPrivateKey(software.amazon.cryptography.primitives.model.ECCPrivateKey nativeValue) {
        DafnySequence pem = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.pem());
        return new ECCPrivateKey((DafnySequence<? extends Byte>)pem);
    }

    public static ECCPublicKey ECCPublicKey(software.amazon.cryptography.primitives.model.ECCPublicKey nativeValue) {
        DafnySequence der = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.der());
        return new ECCPublicKey((DafnySequence<? extends Byte>)der);
    }

    public static software.amazon.cryptography.primitives.internaldafny.types.ECDSASignInput ECDSASignInput(ECDSASignInput nativeValue) {
        ECDSASignatureAlgorithm signatureAlgorithm = ToDafny.ECDSASignatureAlgorithm(nativeValue.signatureAlgorithm());
        DafnySequence signingKey = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.signingKey());
        DafnySequence message = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.message());
        return new software.amazon.cryptography.primitives.internaldafny.types.ECDSASignInput(signatureAlgorithm, (DafnySequence<? extends Byte>)signingKey, (DafnySequence<? extends Byte>)message);
    }

    public static DafnySequence<? extends Byte> ECDSASignOutput(ByteBuffer nativeValue) {
        DafnySequence signature = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue);
        return signature;
    }

    public static ECDSAVerifyInput ECDSAVerifyInput(software.amazon.cryptography.primitives.model.ECDSAVerifyInput nativeValue) {
        ECDSASignatureAlgorithm signatureAlgorithm = ToDafny.ECDSASignatureAlgorithm(nativeValue.signatureAlgorithm());
        DafnySequence verificationKey = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.verificationKey());
        DafnySequence message = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.message());
        DafnySequence signature = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.signature());
        return new ECDSAVerifyInput(signatureAlgorithm, (DafnySequence<? extends Byte>)verificationKey, (DafnySequence<? extends Byte>)message, (DafnySequence<? extends Byte>)signature);
    }

    public static Boolean ECDSAVerifyOutput(Boolean nativeValue) {
        Boolean success = nativeValue;
        return success;
    }

    public static software.amazon.cryptography.primitives.internaldafny.types.GenerateECCKeyPairInput GenerateECCKeyPairInput(GenerateECCKeyPairInput nativeValue) {
        ECDHCurveSpec eccCurve = ToDafny.ECDHCurveSpec(nativeValue.eccCurve());
        return new software.amazon.cryptography.primitives.internaldafny.types.GenerateECCKeyPairInput(eccCurve);
    }

    public static software.amazon.cryptography.primitives.internaldafny.types.GenerateECCKeyPairOutput GenerateECCKeyPairOutput(GenerateECCKeyPairOutput nativeValue) {
        ECDHCurveSpec eccCurve = ToDafny.ECDHCurveSpec(nativeValue.eccCurve());
        ECCPrivateKey privateKey = ToDafny.ECCPrivateKey(nativeValue.privateKey());
        ECCPublicKey publicKey = ToDafny.ECCPublicKey(nativeValue.publicKey());
        return new software.amazon.cryptography.primitives.internaldafny.types.GenerateECCKeyPairOutput(eccCurve, privateKey, publicKey);
    }

    public static software.amazon.cryptography.primitives.internaldafny.types.GenerateECDSASignatureKeyInput GenerateECDSASignatureKeyInput(GenerateECDSASignatureKeyInput nativeValue) {
        ECDSASignatureAlgorithm signatureAlgorithm = ToDafny.ECDSASignatureAlgorithm(nativeValue.signatureAlgorithm());
        return new software.amazon.cryptography.primitives.internaldafny.types.GenerateECDSASignatureKeyInput(signatureAlgorithm);
    }

    public static software.amazon.cryptography.primitives.internaldafny.types.GenerateECDSASignatureKeyOutput GenerateECDSASignatureKeyOutput(GenerateECDSASignatureKeyOutput nativeValue) {
        ECDSASignatureAlgorithm signatureAlgorithm = ToDafny.ECDSASignatureAlgorithm(nativeValue.signatureAlgorithm());
        DafnySequence verificationKey = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.verificationKey());
        DafnySequence signingKey = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.signingKey());
        return new software.amazon.cryptography.primitives.internaldafny.types.GenerateECDSASignatureKeyOutput(signatureAlgorithm, (DafnySequence<? extends Byte>)verificationKey, (DafnySequence<? extends Byte>)signingKey);
    }

    public static GenerateRandomBytesInput GenerateRandomBytesInput(software.amazon.cryptography.primitives.model.GenerateRandomBytesInput nativeValue) {
        Integer length = nativeValue.length();
        return new GenerateRandomBytesInput(length);
    }

    public static DafnySequence<? extends Byte> GenerateRandomBytesOutput(ByteBuffer nativeValue) {
        DafnySequence data = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue);
        return data;
    }

    public static GenerateRSAKeyPairInput GenerateRSAKeyPairInput(software.amazon.cryptography.primitives.model.GenerateRSAKeyPairInput nativeValue) {
        Integer lengthBits = nativeValue.lengthBits();
        return new GenerateRSAKeyPairInput(lengthBits);
    }

    public static GenerateRSAKeyPairOutput GenerateRSAKeyPairOutput(software.amazon.cryptography.primitives.model.GenerateRSAKeyPairOutput nativeValue) {
        software.amazon.cryptography.primitives.internaldafny.types.RSAPublicKey publicKey = ToDafny.RSAPublicKey(nativeValue.publicKey());
        software.amazon.cryptography.primitives.internaldafny.types.RSAPrivateKey privateKey = ToDafny.RSAPrivateKey(nativeValue.privateKey());
        return new GenerateRSAKeyPairOutput(publicKey, privateKey);
    }

    public static GetPublicKeyFromPrivateKeyInput GetPublicKeyFromPrivateKeyInput(software.amazon.cryptography.primitives.model.GetPublicKeyFromPrivateKeyInput nativeValue) {
        ECDHCurveSpec eccCurve = ToDafny.ECDHCurveSpec(nativeValue.eccCurve());
        ECCPrivateKey privateKey = ToDafny.ECCPrivateKey(nativeValue.privateKey());
        return new GetPublicKeyFromPrivateKeyInput(eccCurve, privateKey);
    }

    public static GetPublicKeyFromPrivateKeyOutput GetPublicKeyFromPrivateKeyOutput(software.amazon.cryptography.primitives.model.GetPublicKeyFromPrivateKeyOutput nativeValue) {
        ECDHCurveSpec eccCurve = ToDafny.ECDHCurveSpec(nativeValue.eccCurve());
        ECCPrivateKey privateKey = ToDafny.ECCPrivateKey(nativeValue.privateKey());
        DafnySequence publicKey = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.publicKey());
        return new GetPublicKeyFromPrivateKeyOutput(eccCurve, privateKey, (DafnySequence<? extends Byte>)publicKey);
    }

    public static software.amazon.cryptography.primitives.internaldafny.types.GetRSAKeyModulusLengthInput GetRSAKeyModulusLengthInput(GetRSAKeyModulusLengthInput nativeValue) {
        DafnySequence publicKey = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.publicKey());
        return new software.amazon.cryptography.primitives.internaldafny.types.GetRSAKeyModulusLengthInput((DafnySequence<? extends Byte>)publicKey);
    }

    public static software.amazon.cryptography.primitives.internaldafny.types.GetRSAKeyModulusLengthOutput GetRSAKeyModulusLengthOutput(GetRSAKeyModulusLengthOutput nativeValue) {
        Integer length = nativeValue.length();
        return new software.amazon.cryptography.primitives.internaldafny.types.GetRSAKeyModulusLengthOutput(length);
    }

    public static software.amazon.cryptography.primitives.internaldafny.types.HkdfExpandInput HkdfExpandInput(HkdfExpandInput nativeValue) {
        software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm digestAlgorithm = ToDafny.DigestAlgorithm(nativeValue.digestAlgorithm());
        DafnySequence prk = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.prk());
        DafnySequence info = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.info());
        Integer expectedLength = nativeValue.expectedLength();
        return new software.amazon.cryptography.primitives.internaldafny.types.HkdfExpandInput(digestAlgorithm, (DafnySequence<? extends Byte>)prk, (DafnySequence<? extends Byte>)info, expectedLength);
    }

    public static DafnySequence<? extends Byte> HkdfExpandOutput(ByteBuffer nativeValue) {
        DafnySequence okm = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue);
        return okm;
    }

    public static HkdfExtractInput HkdfExtractInput(software.amazon.cryptography.primitives.model.HkdfExtractInput nativeValue) {
        software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm digestAlgorithm = ToDafny.DigestAlgorithm(nativeValue.digestAlgorithm());
        Option<DafnySequence<? extends Byte>> salt = Objects.nonNull(nativeValue.salt()) ? Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE), ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.salt())) : Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE));
        DafnySequence ikm = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.ikm());
        return new HkdfExtractInput(digestAlgorithm, salt, (DafnySequence<? extends Byte>)ikm);
    }

    public static DafnySequence<? extends Byte> HkdfExtractOutput(ByteBuffer nativeValue) {
        DafnySequence prk = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue);
        return prk;
    }

    public static software.amazon.cryptography.primitives.internaldafny.types.HkdfInput HkdfInput(HkdfInput nativeValue) {
        software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm digestAlgorithm = ToDafny.DigestAlgorithm(nativeValue.digestAlgorithm());
        Option<DafnySequence<? extends Byte>> salt = Objects.nonNull(nativeValue.salt()) ? Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE), ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.salt())) : Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE));
        DafnySequence ikm = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.ikm());
        DafnySequence info = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.info());
        Integer expectedLength = nativeValue.expectedLength();
        return new software.amazon.cryptography.primitives.internaldafny.types.HkdfInput(digestAlgorithm, salt, (DafnySequence<? extends Byte>)ikm, (DafnySequence<? extends Byte>)info, expectedLength);
    }

    public static DafnySequence<? extends Byte> HkdfOutput(ByteBuffer nativeValue) {
        DafnySequence okm = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue);
        return okm;
    }

    public static HMacInput HMacInput(software.amazon.cryptography.primitives.model.HMacInput nativeValue) {
        software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm digestAlgorithm = ToDafny.DigestAlgorithm(nativeValue.digestAlgorithm());
        DafnySequence key = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.key());
        DafnySequence message = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.message());
        return new HMacInput(digestAlgorithm, (DafnySequence<? extends Byte>)key, (DafnySequence<? extends Byte>)message);
    }

    public static DafnySequence<? extends Byte> HMacOutput(ByteBuffer nativeValue) {
        DafnySequence digest = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue);
        return digest;
    }

    public static software.amazon.cryptography.primitives.internaldafny.types.KdfCtrInput KdfCtrInput(KdfCtrInput nativeValue) {
        software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm digestAlgorithm = ToDafny.DigestAlgorithm(nativeValue.digestAlgorithm());
        DafnySequence ikm = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.ikm());
        Integer expectedLength = nativeValue.expectedLength();
        Option<DafnySequence<? extends Byte>> purpose = Objects.nonNull(nativeValue.purpose()) ? Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE), ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.purpose())) : Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE));
        Option<DafnySequence<? extends Byte>> nonce = Objects.nonNull(nativeValue.nonce()) ? Option.create_Some(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE), ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.nonce())) : Option.create_None(DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.BYTE));
        return new software.amazon.cryptography.primitives.internaldafny.types.KdfCtrInput(digestAlgorithm, (DafnySequence<? extends Byte>)ikm, expectedLength, purpose, nonce);
    }

    public static DafnySequence<? extends Byte> KdfCtrOutput(ByteBuffer nativeValue) {
        DafnySequence okm = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue);
        return okm;
    }

    public static ParsePublicKeyInput ParsePublicKeyInput(software.amazon.cryptography.primitives.model.ParsePublicKeyInput nativeValue) {
        DafnySequence publicKey = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.publicKey());
        return new ParsePublicKeyInput((DafnySequence<? extends Byte>)publicKey);
    }

    public static software.amazon.cryptography.primitives.internaldafny.types.ParsePublicKeyOutput ParsePublicKeyOutput(ParsePublicKeyOutput nativeValue) {
        ECCPublicKey publicKey = ToDafny.ECCPublicKey(nativeValue.publicKey());
        return new software.amazon.cryptography.primitives.internaldafny.types.ParsePublicKeyOutput(publicKey);
    }

    public static RSADecryptInput RSADecryptInput(software.amazon.cryptography.primitives.model.RSADecryptInput nativeValue) {
        RSAPaddingMode padding = ToDafny.RSAPaddingMode(nativeValue.padding());
        DafnySequence privateKey = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.privateKey());
        DafnySequence cipherText = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.cipherText());
        return new RSADecryptInput(padding, (DafnySequence<? extends Byte>)privateKey, (DafnySequence<? extends Byte>)cipherText);
    }

    public static DafnySequence<? extends Byte> RSADecryptOutput(ByteBuffer nativeValue) {
        DafnySequence plaintext = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue);
        return plaintext;
    }

    public static software.amazon.cryptography.primitives.internaldafny.types.RSAEncryptInput RSAEncryptInput(RSAEncryptInput nativeValue) {
        RSAPaddingMode padding = ToDafny.RSAPaddingMode(nativeValue.padding());
        DafnySequence publicKey = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.publicKey());
        DafnySequence plaintext = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.plaintext());
        return new software.amazon.cryptography.primitives.internaldafny.types.RSAEncryptInput(padding, (DafnySequence<? extends Byte>)publicKey, (DafnySequence<? extends Byte>)plaintext);
    }

    public static DafnySequence<? extends Byte> RSAEncryptOutput(ByteBuffer nativeValue) {
        DafnySequence cipherText = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue);
        return cipherText;
    }

    public static software.amazon.cryptography.primitives.internaldafny.types.RSAPrivateKey RSAPrivateKey(RSAPrivateKey nativeValue) {
        Integer lengthBits = nativeValue.lengthBits();
        DafnySequence pem = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.pem());
        return new software.amazon.cryptography.primitives.internaldafny.types.RSAPrivateKey(lengthBits, (DafnySequence<? extends Byte>)pem);
    }

    public static software.amazon.cryptography.primitives.internaldafny.types.RSAPublicKey RSAPublicKey(RSAPublicKey nativeValue) {
        Integer lengthBits = nativeValue.lengthBits();
        DafnySequence pem = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.pem());
        return new software.amazon.cryptography.primitives.internaldafny.types.RSAPublicKey(lengthBits, (DafnySequence<? extends Byte>)pem);
    }

    public static ValidatePublicKeyInput ValidatePublicKeyInput(software.amazon.cryptography.primitives.model.ValidatePublicKeyInput nativeValue) {
        ECDHCurveSpec eccCurve = ToDafny.ECDHCurveSpec(nativeValue.eccCurve());
        DafnySequence publicKey = ToDafny.Simple.ByteSequence((ByteBuffer)nativeValue.publicKey());
        return new ValidatePublicKeyInput(eccCurve, (DafnySequence<? extends Byte>)publicKey);
    }

    public static software.amazon.cryptography.primitives.internaldafny.types.ValidatePublicKeyOutput ValidatePublicKeyOutput(ValidatePublicKeyOutput nativeValue) {
        Boolean success = nativeValue.success();
        return new software.amazon.cryptography.primitives.internaldafny.types.ValidatePublicKeyOutput(success);
    }

    public static Error Error(AwsCryptographicPrimitivesError nativeValue) {
        DafnySequence message = ToDafny.Simple.CharacterSequence((String)nativeValue.message());
        return new Error_AwsCryptographicPrimitivesError((DafnySequence<? extends Character>)message);
    }

    public static software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm DigestAlgorithm(DigestAlgorithm nativeValue) {
        switch (nativeValue) {
            case SHA_512: {
                return software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm.create_SHA__512();
            }
            case SHA_384: {
                return software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm.create_SHA__384();
            }
            case SHA_256: {
                return software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm.create_SHA__256();
            }
        }
        throw new RuntimeException("Cannot convert " + (Object)((Object)nativeValue) + " to software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm.");
    }

    public static ECDHCurveSpec ECDHCurveSpec(software.amazon.cryptography.primitives.model.ECDHCurveSpec nativeValue) {
        switch (nativeValue) {
            case ECC_NIST_P256: {
                return ECDHCurveSpec.create_ECC__NIST__P256();
            }
            case ECC_NIST_P384: {
                return ECDHCurveSpec.create_ECC__NIST__P384();
            }
            case ECC_NIST_P521: {
                return ECDHCurveSpec.create_ECC__NIST__P521();
            }
            case SM2: {
                return ECDHCurveSpec.create_SM2();
            }
        }
        throw new RuntimeException("Cannot convert " + (Object)((Object)nativeValue) + " to software.amazon.cryptography.primitives.internaldafny.types.ECDHCurveSpec.");
    }

    public static ECDSASignatureAlgorithm ECDSASignatureAlgorithm(software.amazon.cryptography.primitives.model.ECDSASignatureAlgorithm nativeValue) {
        switch (nativeValue) {
            case ECDSA_P384: {
                return ECDSASignatureAlgorithm.create_ECDSA__P384();
            }
            case ECDSA_P256: {
                return ECDSASignatureAlgorithm.create_ECDSA__P256();
            }
        }
        throw new RuntimeException("Cannot convert " + (Object)((Object)nativeValue) + " to software.amazon.cryptography.primitives.internaldafny.types.ECDSASignatureAlgorithm.");
    }

    public static RSAPaddingMode RSAPaddingMode(software.amazon.cryptography.primitives.model.RSAPaddingMode nativeValue) {
        switch (nativeValue) {
            case PKCS1: {
                return RSAPaddingMode.create_PKCS1();
            }
            case OAEP_SHA1: {
                return RSAPaddingMode.create_OAEP__SHA1();
            }
            case OAEP_SHA256: {
                return RSAPaddingMode.create_OAEP__SHA256();
            }
            case OAEP_SHA384: {
                return RSAPaddingMode.create_OAEP__SHA384();
            }
            case OAEP_SHA512: {
                return RSAPaddingMode.create_OAEP__SHA512();
            }
        }
        throw new RuntimeException("Cannot convert " + (Object)((Object)nativeValue) + " to software.amazon.cryptography.primitives.internaldafny.types.RSAPaddingMode.");
    }

    public static IAwsCryptographicPrimitivesClient AwsCryptographicPrimitives(AtomicPrimitives nativeValue) {
        return nativeValue.impl();
    }
}

