/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.common.tree;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.tribuo.Example;
import org.tribuo.Output;
import org.tribuo.Prediction;
import org.tribuo.common.tree.Node;
import org.tribuo.math.la.SparseVector;

public class LeafNode<T extends Output<T>>
implements Node<T> {
    private static final long serialVersionUID = 4L;
    private final double impurity;
    private final T output;
    private final Map<String, T> scores;
    private final boolean generatesProbabilities;

    public LeafNode(double impurity, T output, Map<String, T> scores, boolean generatesProbabilities) {
        this.impurity = impurity;
        this.output = output;
        this.scores = Collections.unmodifiableMap(scores);
        this.generatesProbabilities = generatesProbabilities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LeafNode leafNode = (LeafNode)o;
        if (this.output.getClass().equals(leafNode.output.getClass())) {
            LeafNode typedLeafNode = leafNode;
            if (this.scores.keySet().equals(typedLeafNode.scores.keySet())) {
                boolean valueEquals = true;
                for (Map.Entry<String, T> e : this.scores.entrySet()) {
                    valueEquals &= ((Output)e.getValue()).fullEquals((Output)typedLeafNode.scores.get(e.getKey()));
                }
                return valueEquals && Double.compare(typedLeafNode.impurity, this.impurity) == 0 && this.generatesProbabilities == typedLeafNode.generatesProbabilities && this.output.fullEquals(typedLeafNode.output);
            }
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.impurity, this.output, this.scores, this.generatesProbabilities);
    }

    @Override
    public Node<T> getNextNode(SparseVector e) {
        return null;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public double getImpurity() {
        return this.impurity;
    }

    @Override
    public LeafNode<T> copy() {
        return new LeafNode<Output>(this.impurity, this.output.copy(), new HashMap<String, T>(this.scores), this.generatesProbabilities);
    }

    public T getOutput() {
        return this.output;
    }

    public Map<String, T> getDistribution() {
        return this.scores;
    }

    public Prediction<T> getPrediction(int numUsed, Example<T> example) {
        return new Prediction(this.output, this.scores, numUsed, example, this.generatesProbabilities);
    }

    public String toString() {
        return "LeafNode(impurity=" + this.impurity + ",output=" + this.output.toString() + ",scores=" + this.scores.toString() + ",probability=" + this.generatesProbabilities + ")";
    }
}

