/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.security.SecureRandom;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AuthenticationParametersWithIV;
import org.bouncycastle.crypto.IllegalKeyException;
import org.bouncycastle.crypto.ParametersWithIV;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.SymmetricSecretKey;
import org.bouncycastle.crypto.fips.FipsTripleDES;
import org.bouncycastle.crypto.general.CipherUtils;
import org.bouncycastle.crypto.general.FipsRegister;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.crypto.general.GeneralAuthParameters;
import org.bouncycastle.crypto.general.GeneralParameters;
import org.bouncycastle.crypto.general.GeneralParametersWithIV;
import org.bouncycastle.crypto.general.GuardedAEADOperatorFactory;
import org.bouncycastle.crypto.general.GuardedKeyWrapOperatorFactory;
import org.bouncycastle.crypto.general.GuardedMACOperatorFactory;
import org.bouncycastle.crypto.general.GuardedSymmetricKeyGenerator;
import org.bouncycastle.crypto.general.GuardedSymmetricOperatorFactory;
import org.bouncycastle.crypto.general.Mode;
import org.bouncycastle.crypto.general.Padding;
import org.bouncycastle.crypto.general.PrivilegedUtils;
import org.bouncycastle.crypto.general.Utils;
import org.bouncycastle.crypto.internal.BufferedBlockCipher;
import org.bouncycastle.crypto.internal.Mac;
import org.bouncycastle.crypto.internal.ValidatedSymmetricKey;
import org.bouncycastle.crypto.internal.Wrapper;
import org.bouncycastle.crypto.internal.modes.AEADBlockCipher;

public final class TripleDES {
    public static final Algorithm ALGORITHM = FipsTripleDES.ALGORITHM;
    public static final AuthParameters CBC_MAC = new AuthParameters(new GeneralAlgorithm(FipsTripleDES.ALGORITHM.getName(), (Enum)Mode.CBCMAC));
    public static final AuthParameters CBC_MACwithISO7816_4 = new AuthParameters(new GeneralAlgorithm(FipsTripleDES.ALGORITHM.getName(), (Enum)Mode.CBCMAC, Padding.ISO7816_4));
    public static final AuthParameters CFB8_MAC = new AuthParameters(new GeneralAlgorithm(FipsTripleDES.ALGORITHM.getName(), (Enum)Mode.CFB8MAC));
    public static final Parameters OpenPGPCFB = new Parameters(new GeneralAlgorithm(FipsTripleDES.ALGORITHM.getName(), (Enum)Mode.OpenPGPCFB));
    public static final AuthParameters EAX = new AuthParameters(new GeneralAlgorithm(FipsTripleDES.ALGORITHM.getName(), (Enum)Mode.EAX));
    public static final Parameters RFC3217_WRAP = new Parameters(new GeneralAlgorithm(FipsTripleDES.ALGORITHM.getName(), (Enum)Mode.RFC3217_WRAP));
    public static final Parameters RFC3211_WRAP = new Parameters(new GeneralAlgorithm(FipsTripleDES.ALGORITHM.getName(), (Enum)Mode.RFC3211_WRAP));

    private TripleDES() {
    }

    private static void validateKeySize(int n) {
        if (n != 112 && n != 168 && n != 128 && n != 192) {
            throw new IllegalKeyException("DESEDE key must be of length 128 or 192 bits including parity");
        }
    }

    private static ValidatedSymmetricKey validateKey(SymmetricKey symmetricKey, Algorithm algorithm) {
        ValidatedSymmetricKey validatedSymmetricKey = PrivilegedUtils.getValidatedKey(symmetricKey);
        TripleDES.validateKeySize(validatedSymmetricKey.getKeySizeInBits());
        Utils.checkKeyAlgorithm(validatedSymmetricKey, FipsTripleDES.ALGORITHM, algorithm);
        return validatedSymmetricKey;
    }

    public static final class AEADOperatorFactory
    extends GuardedAEADOperatorFactory<AuthParameters> {
        protected AEADBlockCipher createAEADCipher(boolean bl, SymmetricKey symmetricKey, AuthParameters authParameters) {
            return CipherUtils.createStandardAEADCipher(bl, TripleDES.validateKey(symmetricKey, authParameters.getAlgorithm()), FipsRegister.getProvider(FipsTripleDES.ALGORITHM), (AuthenticationParametersWithIV)authParameters);
        }
    }

    public static final class AuthParameters
    extends GeneralAuthParameters<AuthParameters> {
        private AuthParameters(GeneralAlgorithm generalAlgorithm, byte[] byArray, int n) {
            super(generalAlgorithm, 8, byArray, n);
        }

        public AuthParameters(GeneralAlgorithm generalAlgorithm) {
            this(generalAlgorithm, null, Utils.getDefaultMacSize(generalAlgorithm, 64));
        }

        @Override
        protected AuthParameters create(GeneralAlgorithm generalAlgorithm, byte[] byArray, int n) {
            return new AuthParameters(generalAlgorithm, byArray, n);
        }
    }

    public static final class KeyGenerator
    extends GuardedSymmetricKeyGenerator {
        private final GeneralAlgorithm algorithm;
        private final FipsTripleDES.KeyGenerator keyGen;

        public KeyGenerator(GeneralParameters generalParameters, int n, SecureRandom secureRandom) {
            this.algorithm = (GeneralAlgorithm)generalParameters.getAlgorithm();
            this.keyGen = new FipsTripleDES.KeyGenerator(n, secureRandom);
        }

        @Override
        public SymmetricKey doGenerateKey() {
            return new SymmetricSecretKey(this.algorithm, this.keyGen.generateKey().getKeyBytes());
        }
    }

    public static final class KeyWrapOperatorFactory
    extends GuardedKeyWrapOperatorFactory<Parameters, SymmetricKey> {
        @Override
        protected Wrapper createWrapper(boolean bl, SymmetricKey symmetricKey, Parameters parameters, SecureRandom secureRandom) {
            return CipherUtils.createStandardWrapper(bl, TripleDES.validateKey(symmetricKey, parameters.getAlgorithm()), FipsRegister.getProvider(FipsTripleDES.ALGORITHM), parameters, secureRandom);
        }
    }

    public static final class MACOperatorFactory
    extends GuardedMACOperatorFactory<AuthParameters> {
        @Override
        protected Mac createMAC(SymmetricKey symmetricKey, AuthParameters authParameters) {
            return CipherUtils.createStandardMac(TripleDES.validateKey(symmetricKey, authParameters.getAlgorithm()), FipsRegister.getProvider(FipsTripleDES.ALGORITHM), (GeneralAuthParameters)authParameters);
        }

        @Override
        protected int calculateMACSize(AuthParameters authParameters) {
            return Utils.bitsToBytes(authParameters.macLenInBits);
        }
    }

    public static final class OperatorFactory
    extends GuardedSymmetricOperatorFactory<Parameters> {
        @Override
        protected BufferedBlockCipher createCipher(boolean bl, SymmetricKey symmetricKey, Parameters parameters, SecureRandom secureRandom) {
            return CipherUtils.createStandardCipher(bl, TripleDES.validateKey(symmetricKey, parameters.getAlgorithm()), FipsRegister.getProvider(FipsTripleDES.ALGORITHM), (ParametersWithIV)parameters, secureRandom);
        }
    }

    public static final class Parameters
    extends GeneralParametersWithIV<Parameters> {
        private Parameters(GeneralAlgorithm generalAlgorithm, byte[] byArray) {
            super(generalAlgorithm, 8, generalAlgorithm.checkIv(byArray, 8));
        }

        public Parameters(GeneralAlgorithm generalAlgorithm) {
            this(generalAlgorithm, null);
        }

        @Override
        protected Parameters create(GeneralAlgorithm generalAlgorithm, byte[] byArray) {
            return new Parameters(generalAlgorithm, byArray);
        }
    }
}

