/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.remote.metadata.client;

import java.io.IOException;
import java.util.Map;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.remote.metadata.client.WriteDataObjectRequest;

public class UpdateDataObjectRequest
extends WriteDataObjectRequest<UpdateDataObjectRequest> {
    private final int retryOnConflict;
    private final ToXContentObject dataObject;

    public UpdateDataObjectRequest(String index, String id, String tenantId, Long ifSeqNo, Long ifPrimaryTerm, WriteRequest.RefreshPolicy refreshPolicy, TimeValue timeout, int retryOnConflict, ToXContentObject dataObject) {
        super(index, id, tenantId, ifSeqNo, ifPrimaryTerm, refreshPolicy, timeout, false);
        this.retryOnConflict = retryOnConflict;
        this.dataObject = dataObject;
    }

    public int retryOnConflict() {
        return this.retryOnConflict;
    }

    public ToXContentObject dataObject() {
        return this.dataObject;
    }

    @Override
    public boolean isWriteRequest() {
        return true;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends WriteDataObjectRequest.Builder<Builder> {
        private int retryOnConflict = 0;
        private ToXContentObject dataObject = null;

        public Builder retryOnConflict(int retries) {
            this.retryOnConflict = retries;
            return this;
        }

        public Builder dataObject(ToXContentObject dataObject) {
            this.dataObject = dataObject;
            return this;
        }

        public Builder dataObject(final Map<String, Object> dataObjectMap) {
            this.dataObject = new ToXContentObject(){

                public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                    return builder.map(dataObjectMap);
                }
            };
            return this;
        }

        public UpdateDataObjectRequest build() {
            WriteDataObjectRequest.validateSeqNoAndPrimaryTerm(this.ifSeqNo, this.ifPrimaryTerm, false);
            return new UpdateDataObjectRequest(this.index, this.id, this.tenantId, this.ifSeqNo, this.ifPrimaryTerm, this.refreshPolicy, this.timeout, this.retryOnConflict, this.dataObject);
        }
    }
}

