/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.protocol;

import java.io.IOException;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.STATELESS)
public final class RequestUpgrade
implements HttpRequestInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(RequestUpgrade.class);

    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull((Object)request, (String)"HTTP request");
        Args.notNull((Object)context, (String)"HTTP context");
        HttpClientContext clientContext = HttpClientContext.cast(context);
        RequestConfig requestConfig = clientContext.getRequestConfigOrDefault();
        if (requestConfig.isProtocolUpgradeEnabled()) {
            ProtocolVersion version;
            ProtocolVersion protocolVersion = version = request.getVersion() != null ? request.getVersion() : clientContext.getProtocolVersion();
            if (!request.containsHeader("Upgrade") && !request.containsHeader("Connection") && version.getMajor() == 1 && version.getMinor() >= 1) {
                String method;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Connection is upgradable: protocol version = {}", (Object)version);
                }
                if ((Method.OPTIONS.isSame(method = request.getMethod()) || Method.HEAD.isSame(method) || Method.GET.isSame(method)) && clientContext.getSSLSession() == null) {
                    LOG.debug("Connection is upgradable to TLS: method = {}", (Object)method);
                    request.addHeader("Upgrade", (Object)"TLS/1.2");
                    request.addHeader("Connection", (Object)"Upgrade");
                }
            }
        }
    }
}

