/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.rollup;

import java.lang.invoke.LambdaMetafactory;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.common.Rounding;
import org.opensearch.common.time.DateFormatter;
import org.opensearch.common.time.DateFormatters;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.query.MatchAllQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.indexmanagement.common.model.dimension.DateHistogram;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.rollup.MetadataResult;
import org.opensearch.indexmanagement.rollup.RollupMetadataException;
import org.opensearch.indexmanagement.rollup.RollupMetadataService;
import org.opensearch.indexmanagement.rollup.StartingTimeResult;
import org.opensearch.indexmanagement.rollup.model.ContinuousMetadata;
import org.opensearch.indexmanagement.rollup.model.Rollup;
import org.opensearch.indexmanagement.rollup.model.RollupMetadata;
import org.opensearch.indexmanagement.rollup.model.RollupStats;
import org.opensearch.search.SearchHit;
import org.opensearch.search.aggregations.bucket.composite.InternalComposite;
import org.opensearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.transport.RemoteTransportException;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.OpenSearchClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0086@\u00a2\u0006\u0002\u0010\u0013J\u001e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0082@\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0016\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0082@\u00a2\u0006\u0002\u0010\u0013J\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0082@\u00a2\u0006\u0002\u0010\u0013J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020 2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010#\u001a\u00020$H\u0002J \u0010)\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0016\u0010*\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0086@\u00a2\u0006\u0002\u0010\u0013J&\u0010+\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0086@\u00a2\u0006\u0002\u0010,J\u0016\u0010+\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016H\u0086@\u00a2\u0006\u0002\u0010-J*\u0010.\u001a\u00020\u00102\u0006\u0010/\u001a\u00020\u00122\u0006\u00100\u001a\u0002012\n\b\u0002\u00102\u001a\u0004\u0018\u00010\u0016H\u0086@\u00a2\u0006\u0002\u00103J\u001e\u00104\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u00105\u001a\u000206H\u0082@\u00a2\u0006\u0002\u00107R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/opensearch/indexmanagement/rollup/RollupMetadataService;", "", "client", "Lorg/opensearch/transport/client/Client;", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "<init>", "(Lorg/opensearch/transport/client/Client;Lorg/opensearch/core/xcontent/NamedXContentRegistry;)V", "getClient", "()Lorg/opensearch/transport/client/Client;", "getXContentRegistry", "()Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "init", "Lorg/opensearch/indexmanagement/rollup/MetadataResult;", "rollup", "Lorg/opensearch/indexmanagement/rollup/model/Rollup;", "(Lorg/opensearch/indexmanagement/rollup/model/Rollup;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "recoverRetryMetadata", "metadata", "Lorg/opensearch/indexmanagement/rollup/model/RollupMetadata;", "(Lorg/opensearch/indexmanagement/rollup/model/Rollup;Lorg/opensearch/indexmanagement/rollup/model/RollupMetadata;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createNonContinuousMetadata", "getUpdatedNonContinuousMetadata", "internalComposite", "Lorg/opensearch/search/aggregations/bucket/composite/InternalComposite;", "createContinuousMetadata", "getInitialStartTime", "Lorg/opensearch/indexmanagement/rollup/StartingTimeResult;", "getRoundedTime", "Ljava/time/Instant;", "timestamp", "", "dateHistogram", "Lorg/opensearch/indexmanagement/common/model/dimension/DateHistogram;", "getShiftedTime", "time", "getRoundingStrategy", "Lorg/opensearch/common/Rounding;", "getUpdatedContinuousMetadata", "getExistingMetadata", "updateMetadata", "(Lorg/opensearch/indexmanagement/rollup/model/Rollup;Lorg/opensearch/indexmanagement/rollup/model/RollupMetadata;Lorg/opensearch/search/aggregations/bucket/composite/InternalComposite;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(Lorg/opensearch/indexmanagement/rollup/model/RollupMetadata;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setFailedMetadata", "job", "reason", "", "existingMetadata", "(Lorg/opensearch/indexmanagement/rollup/model/Rollup;Ljava/lang/String;Lorg/opensearch/indexmanagement/rollup/model/RollupMetadata;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "submitMetadataUpdate", "updating", "", "(Lorg/opensearch/indexmanagement/rollup/model/RollupMetadata;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "opensearch-index-management"})
public final class RollupMetadataService {
    @NotNull
    private final Client client;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;
    private final Logger logger;

    public RollupMetadataService(@NotNull Client client, @NotNull NamedXContentRegistry xContentRegistry) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.logger = LogManager.getLogger(this.getClass());
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object init(@NotNull Rollup rollup, @NotNull Continuation<? super MetadataResult> $completion) {
        block32: {
            block31: {
                block30: {
                    block29: {
                        if (!($completion instanceof init.1)) ** GOTO lbl-1000
                        var7_3 = $completion;
                        if ((var7_3.label & -2147483648) != 0) {
                            var7_3.label -= -2147483648;
                        } else lbl-1000:
                        // 2 sources

                        {
                            $continuation = new ContinuationImpl(this, $completion){
                                Object L$0;
                                Object L$1;
                                Object L$2;
                                /* synthetic */ Object result;
                                final /* synthetic */ RollupMetadataService this$0;
                                int label;
                                {
                                    this.this$0 = this$0;
                                    super($completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object $result) {
                                    this.result = $result;
                                    this.label |= Integer.MIN_VALUE;
                                    return this.this$0.init(null, (Continuation<? super MetadataResult>)((Continuation)this));
                                }
                            };
                        }
                        $result = $continuation.result;
                        var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch ($continuation.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                if (rollup.getMetadataID() == null) break;
                                $continuation.L$0 = rollup;
                                $continuation.label = 1;
                                v0 = this.getExistingMetadata(rollup, (Continuation<? super MetadataResult>)$continuation);
                                if (v0 == var8_5) {
                                    return var8_5;
                                }
                                ** GOTO lbl23
                            }
                            case 1: {
                                rollup = (Rollup)$continuation.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl23:
                                // 2 sources

                                if ((getMetadataResult = (MetadataResult)v0) instanceof MetadataResult.Success) {
                                    v1 = ((MetadataResult.Success)getMetadataResult).getMetadata();
                                } else if (getMetadataResult instanceof MetadataResult.NoMetadata) {
                                    v1 = null;
                                } else {
                                    if (getMetadataResult instanceof MetadataResult.Failure) {
                                        return getMetadataResult;
                                    }
                                    throw new NoWhenBranchMatchedException();
                                }
                                existingMetadata = v1;
                                if (existingMetadata == null) break block29;
                                if (existingMetadata.getStatus() != RollupMetadata.Status.RETRY) break;
                                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)rollup);
                                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)existingMetadata);
                                $continuation.label = 2;
                                v2 = this.recoverRetryMetadata(rollup, existingMetadata, (Continuation<? super MetadataResult>)$continuation);
                                if (v2 == var8_5) {
                                    return var8_5;
                                }
                                ** GOTO lbl47
                            }
                            case 2: {
                                existingMetadata = (RollupMetadata)$continuation.L$1;
                                rollup = (Rollup)$continuation.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v2 = $result;
lbl47:
                                // 2 sources

                                if (!((recoverMetadataResult = (MetadataResult)v2) instanceof MetadataResult.Success)) {
                                    if (recoverMetadataResult instanceof MetadataResult.NoMetadata) {
                                        return recoverMetadataResult;
                                    }
                                    if (recoverMetadataResult instanceof MetadataResult.Failure) {
                                        return recoverMetadataResult;
                                    }
                                    throw new NoWhenBranchMatchedException();
                                }
                                recoveredMetadata = ((MetadataResult.Success)recoverMetadataResult).getMetadata();
                                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)rollup);
                                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)existingMetadata);
                                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)recoveredMetadata);
                                $continuation.label = 3;
                                v3 = this.submitMetadataUpdate(recoveredMetadata, true, (Continuation<? super MetadataResult>)$continuation);
                                if (v3 == var8_5) {
                                    return var8_5;
                                }
                                ** GOTO lbl68
                            }
                            case 3: {
                                recoveredMetadata = (RollupMetadata)$continuation.L$2;
                                existingMetadata = (RollupMetadata)$continuation.L$1;
                                rollup = (Rollup)$continuation.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v3 = $result;
lbl68:
                                // 2 sources

                                return v3;
                            }
                        }
                        return new MetadataResult.Success(existingMetadata);
                    }
                    v4 = rollup.getId();
                    v5 = Instant.now();
                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"now(...)");
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)rollup);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)existingMetadata);
                    $continuation.label = 4;
                    v6 = this.submitMetadataUpdate(new RollupMetadata(null, 0L, 0L, v4, null, v5, null, RollupMetadata.Status.FAILED, "Not able to get the rollup metadata [" + rollup.getMetadataID() + "]", new RollupStats(0L, 0L, 0L, 0L, 0L), 87, null), false, (Continuation<? super MetadataResult>)$continuation);
                    if (v6 == var8_5) {
                        return var8_5;
                    }
                    ** GOTO lbl86
                    {
                        case 4: {
                            existingMetadata = (RollupMetadata)$continuation.L$1;
                            rollup = (Rollup)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v6 = $result;
lbl86:
                            // 2 sources

                            return v6;
                        }
                    }
                    if (!rollup.getContinuous()) break block30;
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)rollup);
                    $continuation.label = 5;
                    v7 = this.createContinuousMetadata(rollup, (Continuation<? super MetadataResult>)$continuation);
                    if (v7 == var8_5) {
                        return var8_5;
                    }
                    ** GOTO lbl98
                    {
                        case 5: {
                            rollup = (Rollup)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v7 = $result;
lbl98:
                            // 2 sources

                            v8 = (MetadataResult)v7;
                            break block31;
                        }
                    }
                }
                v8 = this.createNonContinuousMetadata(rollup);
            }
            var4_8 = createdMetadataResult = v8;
            if (!(var4_8 instanceof MetadataResult.Success)) break block32;
            $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)rollup);
            $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)createdMetadataResult);
            $continuation.label = 6;
            v9 = this.submitMetadataUpdate(((MetadataResult.Success)createdMetadataResult).getMetadata(), false, (Continuation<? super MetadataResult>)$continuation);
            if (v9 == var8_5) {
                return var8_5;
            }
            ** GOTO lbl117
            {
                case 6: {
                    createdMetadataResult = (MetadataResult)$continuation.L$1;
                    rollup = (Rollup)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v9 = $result;
lbl117:
                    // 2 sources

                    return v9;
                }
            }
        }
        if (var4_8 instanceof MetadataResult.NoMetadata) {
            v10 = createdMetadataResult;
        } else if (var4_8 instanceof MetadataResult.Failure) {
            v10 = createdMetadataResult;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return v10;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object recoverRetryMetadata(Rollup rollup, RollupMetadata metadata, Continuation<? super MetadataResult> $completion) {
        if (!($completion instanceof recoverRetryMetadata.1)) ** GOTO lbl-1000
        var8_4 = $completion;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ RollupMetadataService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RollupMetadataService.access$recoverRetryMetadata(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                continuousMetadata = metadata.getContinuous();
                if (!rollup.getContinuous() || metadata.getContinuous() != null) ** GOTO lbl37
                $continuation.L$0 = rollup;
                $continuation.L$1 = metadata;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)continuousMetadata);
                $continuation.label = 1;
                v0 = this.getInitialStartTime(rollup, (Continuation<? super StartingTimeResult>)$continuation);
                if (v0 == var9_6) {
                    return var9_6;
                }
                ** GOTO lbl28
            }
            case 1: {
                continuousMetadata = (ContinuousMetadata)$continuation.L$2;
                metadata = (RollupMetadata)$continuation.L$1;
                rollup = (Rollup)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                if (!((initStartTimeResult = (StartingTimeResult)v0) instanceof StartingTimeResult.Success)) {
                    if (initStartTimeResult instanceof StartingTimeResult.NoDocumentsFound) {
                        return MetadataResult.NoMetadata.INSTANCE;
                    }
                    if (initStartTimeResult instanceof StartingTimeResult.Failure) {
                        return new MetadataResult.Failure("Failed to initialize start time for retried rollup job [" + rollup.getId() + "]", ((StartingTimeResult.Failure)initStartTimeResult).getE());
                    }
                    throw new NoWhenBranchMatchedException();
                }
                nextWindowStartTime = ((StartingTimeResult.Success)initStartTimeResult).getStartingTime();
                nextWindowEndTime = this.getShiftedTime(nextWindowStartTime, rollup);
                continuousMetadata = new ContinuousMetadata(nextWindowStartTime, nextWindowEndTime);
lbl37:
                // 2 sources

                return new MetadataResult.Success(RollupMetadata.copy$default(metadata, null, 0L, 0L, null, null, null, continuousMetadata, RollupMetadata.Status.STARTED, null, null, 831, null));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final MetadataResult createNonContinuousMetadata(Rollup rollup2) {
        String string = rollup2.getId();
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        return new MetadataResult.Success(new RollupMetadata(null, 0L, 0L, string, null, instant, null, RollupMetadata.Status.INIT, null, new RollupStats(0L, 0L, 0L, 0L, 0L), 343, null));
    }

    private final RollupMetadata getUpdatedNonContinuousMetadata(RollupMetadata metadata2, InternalComposite internalComposite) {
        Map afterKey = internalComposite.afterKey();
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        return RollupMetadata.copy$default(metadata2, null, 0L, 0L, null, afterKey, instant, null, afterKey == null ? RollupMetadata.Status.FINISHED : RollupMetadata.Status.STARTED, null, null, 847, null);
    }

    /*
     * Unable to fully structure code
     */
    private final Object createContinuousMetadata(Rollup rollup, Continuation<? super MetadataResult> $completion) {
        if (!($completion instanceof createContinuousMetadata.1)) ** GOTO lbl-1000
        var6_3 = $completion;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ RollupMetadataService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RollupMetadataService.access$createContinuousMetadata(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = rollup;
                $continuation.label = 1;
                v0 = this.getInitialStartTime(rollup, (Continuation<? super StartingTimeResult>)$continuation);
                if (v0 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                rollup = (Rollup)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                if (!((initStartTimeResult = (StartingTimeResult)v0) instanceof StartingTimeResult.Success)) {
                    if (initStartTimeResult instanceof StartingTimeResult.NoDocumentsFound) {
                        return MetadataResult.NoMetadata.INSTANCE;
                    }
                    if (initStartTimeResult instanceof StartingTimeResult.Failure) {
                        return new MetadataResult.Failure("Failed to initialize start time for rollup [" + rollup.getId() + "]", ((StartingTimeResult.Failure)initStartTimeResult).getE());
                    }
                    throw new NoWhenBranchMatchedException();
                }
                nextWindowStartTime = ((StartingTimeResult.Success)initStartTimeResult).getStartingTime();
                nextWindowEndTime = this.getShiftedTime(nextWindowStartTime, rollup);
                v1 = rollup.getId();
                v2 = Instant.now();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"now(...)");
                return new MetadataResult.Success(new RollupMetadata(null, 0L, 0L, v1, null, v2, new ContinuousMetadata(nextWindowStartTime, nextWindowEndTime), RollupMetadata.Status.INIT, null, new RollupStats(0L, 0L, 0L, 0L, 0L), 7, null));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object getInitialStartTime(Rollup rollup, Continuation<? super StartingTimeResult> $completion) throws Exception {
        if (!($completion instanceof getInitialStartTime.1)) ** GOTO lbl-1000
        var12_3 = $completion;
        if ((var12_3.label & -2147483648) != 0) {
            var12_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ RollupMetadataService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RollupMetadataService.access$getInitialStartTime(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var13_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = CollectionsKt.first(rollup.getDimensions());
                Intrinsics.checkNotNull((Object)v0, (String)"null cannot be cast to non-null type org.opensearch.indexmanagement.common.model.dimension.DateHistogram");
                dateHistogram = (DateHistogram)v0;
                searchSourceBuilder = new SearchSourceBuilder().size(1).query((QueryBuilder)new MatchAllQueryBuilder()).sort(dateHistogram.getSourceField(), SortOrder.ASC).trackTotalHits(false).fetchSource(false).docValueField(dateHistogram.getSourceField(), "strict_date_optional_time");
                var6_11 = new String[]{rollup.getSourceIndex()};
                searchRequest = new SearchRequest(var6_11).source(searchSourceBuilder).allowPartialSearchResults(false);
                $continuation.L$0 = rollup;
                $continuation.L$1 = dateHistogram;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)searchSourceBuilder);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)searchRequest);
                $continuation.label = 1;
                v1 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)this.client, (Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, getInitialStartTime$lambda$0(org.opensearch.action.search.SearchRequest org.opensearch.transport.client.Client org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/Client;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((SearchRequest)searchRequest), $continuation);
                ** if (v1 != var13_5) goto lbl28
lbl27:
                // 1 sources

                return var13_5;
lbl28:
                // 1 sources

                ** GOTO lbl38
            }
            case 1: {
                searchRequest = (SearchRequest)$continuation.L$3;
                searchSourceBuilder = (SearchSourceBuilder)$continuation.L$2;
                dateHistogram = (DateHistogram)$continuation.L$1;
                rollup = (Rollup)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl38:
                    // 2 sources

                    response = (SearchResponse)v1;
                    v2 = response.getHits().getHits();
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getHits(...)");
                    if (((Object[])v2).length == 0) {
                        return StartingTimeResult.NoDocumentsFound.INSTANCE;
                    }
                    v3 = response.getHits().getHits();
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getHits(...)");
                    v4 = (String)((SearchHit)ArraysKt.first((Object[])v3)).field(dateHistogram.getSourceField()).getValue();
                    if (v4 == null) {
                        return StartingTimeResult.NoDocumentsFound.INSTANCE;
                    }
                    firstHitTimestampAsString = v4;
                    formatter = DateFormatter.forPattern((String)"strict_date_optional_time");
                    epochMillis = DateFormatters.from((TemporalAccessor)formatter.parse(firstHitTimestampAsString), (Locale)formatter.locale()).toInstant().toEpochMilli();
                    return new StartingTimeResult.Success(this.getRoundedTime(epochMillis, dateHistogram));
                }
                catch (RemoteTransportException e) {
                    v5 = ExceptionsHelper.unwrapCause((Throwable)e);
                    Intrinsics.checkNotNull((Object)v5, (String)"null cannot be cast to non-null type java.lang.Exception");
                    unwrappedException = (Exception)v5;
                    this.logger.error("Error when getting initial start time for rollup [{}]: {}", (Object)rollup.getId(), (Object)unwrappedException);
                    return new StartingTimeResult.Failure(unwrappedException);
                }
                catch (Exception e) {
                    this.logger.error("Error when getting initial start time for rollup [{}]: {}", (Object)rollup.getId(), (Object)e);
                    return new StartingTimeResult.Failure(e);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Instant getRoundedTime(long timestamp, DateHistogram dateHistogram) {
        Rounding roundingStrategy = this.getRoundingStrategy(dateHistogram);
        long roundedMillis = roundingStrategy.prepare(timestamp, timestamp).round(timestamp);
        Instant instant = Instant.ofEpochMilli(roundedMillis);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochMilli(...)");
        return instant;
    }

    private final Instant getShiftedTime(Instant time, Rollup rollup2) {
        Object object = CollectionsKt.first(rollup2.getDimensions());
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.opensearch.indexmanagement.common.model.dimension.DateHistogram");
        DateHistogram dateHistogram = (DateHistogram)object;
        Rounding roundingStrategy = this.getRoundingStrategy(dateHistogram);
        long timeInMillis = time.toEpochMilli();
        long nextRoundedMillis = roundingStrategy.prepare(timeInMillis, timeInMillis).nextRoundingValue(timeInMillis);
        Instant instant = Instant.ofEpochMilli(nextRoundedMillis);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochMilli(...)");
        return instant;
    }

    private final Rounding getRoundingStrategy(DateHistogram dateHistogram) {
        Rounding rounding;
        String string = dateHistogram.getCalendarInterval();
        if (string == null) {
            string = dateHistogram.getFixedInterval();
        }
        Intrinsics.checkNotNull((Object)string, (String)"null cannot be cast to non-null type kotlin.String");
        String intervalString = string;
        if (DateHistogramAggregationBuilder.DATE_FIELD_UNITS.containsKey(intervalString)) {
            Object v = DateHistogramAggregationBuilder.DATE_FIELD_UNITS.get(intervalString);
            Intrinsics.checkNotNull(v);
            Rounding.DateTimeUnit intervalUnit = (Rounding.DateTimeUnit)v;
            Rounding rounding2 = Rounding.builder((Rounding.DateTimeUnit)intervalUnit).timeZone(dateHistogram.getTimezone()).build();
            Intrinsics.checkNotNull((Object)rounding2);
            rounding = rounding2;
        } else {
            TimeValue timeValue = TimeValue.parseTimeValue((String)intervalString, (String)"RollupMetadataService#getRoundingStrategy");
            Rounding rounding3 = Rounding.builder((TimeValue)timeValue).timeZone(dateHistogram.getTimezone()).build();
            Intrinsics.checkNotNull((Object)rounding3);
            rounding = rounding3;
        }
        return rounding;
    }

    private final RollupMetadata getUpdatedContinuousMetadata(Rollup rollup2, RollupMetadata metadata2, InternalComposite internalComposite) {
        Instant instant;
        Map afterKey = internalComposite.afterKey();
        if (afterKey == null) {
            ContinuousMetadata continuousMetadata = metadata2.getContinuous();
            Intrinsics.checkNotNull((Object)continuousMetadata);
            instant = this.getShiftedTime(continuousMetadata.getNextWindowStartTime(), rollup2);
        } else {
            ContinuousMetadata continuousMetadata = metadata2.getContinuous();
            Intrinsics.checkNotNull((Object)continuousMetadata);
            instant = continuousMetadata.getNextWindowStartTime();
        }
        Instant nextStart = instant;
        Instant nextEnd = afterKey == null ? this.getShiftedTime(metadata2.getContinuous().getNextWindowEndTime(), rollup2) : metadata2.getContinuous().getNextWindowEndTime();
        Map map = internalComposite.afterKey();
        Instant instant2 = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now(...)");
        return RollupMetadata.copy$default(metadata2, null, 0L, 0L, null, map, instant2, new ContinuousMetadata(nextStart, nextEnd), RollupMetadata.Status.STARTED, null, null, 783, null);
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public final Object getExistingMetadata(@NotNull Rollup rollup, @NotNull Continuation<? super MetadataResult> $completion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[SWITCH], 6[CASE]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    public final Object updateMetadata(@NotNull Rollup rollup2, @NotNull RollupMetadata metadata2, @NotNull InternalComposite internalComposite, @NotNull Continuation<? super RollupMetadata> $completion) {
        RollupMetadata updatedMetadata2 = rollup2.getContinuous() ? this.getUpdatedContinuousMetadata(rollup2, metadata2, internalComposite) : this.getUpdatedNonContinuousMetadata(metadata2, internalComposite);
        return this.updateMetadata(updatedMetadata2, $completion);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object updateMetadata(@NotNull RollupMetadata metadata, @NotNull Continuation<? super RollupMetadata> $completion) {
        if (!($completion instanceof updateMetadata.2)) ** GOTO lbl-1000
        var5_3 = $completion;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ RollupMetadataService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.updateMetadata(null, (Continuation<? super RollupMetadata>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = metadata;
                $continuation.label = 1;
                v0 = this.submitMetadataUpdate(metadata, Intrinsics.areEqual((Object)metadata.getId(), (Object)"") == false, (Continuation<? super MetadataResult>)$continuation);
                if (v0 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                metadata = (RollupMetadata)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                if (!((metadataUpdateResult = (MetadataResult)v0) instanceof MetadataResult.Success)) {
                    if (metadataUpdateResult instanceof MetadataResult.Failure) {
                        throw new RollupMetadataException("Failed to update rollup metadata [" + metadata.getId() + "]", ((MetadataResult.Failure)metadataUpdateResult).getCause());
                    }
                    if (metadataUpdateResult instanceof MetadataResult.NoMetadata) {
                        throw new RollupMetadataException("Unexpected state when updating rollup metadata [" + metadata.getId() + "]", null);
                    }
                    throw new NoWhenBranchMatchedException();
                }
                return ((MetadataResult.Success)metadataUpdateResult).getMetadata();
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object setFailedMetadata(@NotNull Rollup job, @NotNull String reason, @Nullable RollupMetadata existingMetadata, @NotNull Continuation<? super MetadataResult> $completion) {
        RollupMetadata updatedMetadata2 = null;
        if (existingMetadata == null) {
            String string = job.getId();
            RollupMetadata.Status status = RollupMetadata.Status.FAILED;
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
            Instant instant2 = instant;
            RollupStats rollupStats = new RollupStats(0L, 0L, 0L, 0L, 0L);
            updatedMetadata2 = new RollupMetadata(null, 0L, 0L, string, null, instant2, null, status, reason, rollupStats, 87, null);
        } else {
            RollupMetadata.Status status = RollupMetadata.Status.FAILED;
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
            Instant instant3 = instant;
            updatedMetadata2 = RollupMetadata.copy$default(existingMetadata, null, 0L, 0L, null, null, instant3, null, status, reason, null, 607, null);
        }
        return this.submitMetadataUpdate(updatedMetadata2, !Intrinsics.areEqual((Object)updatedMetadata2.getId(), (Object)""), $completion);
    }

    public static /* synthetic */ Object setFailedMetadata$default(RollupMetadataService rollupMetadataService, Rollup rollup2, String string, RollupMetadata rollupMetadata, Continuation continuation, int n, Object object) {
        if ((n & 4) != 0) {
            rollupMetadata = null;
        }
        return rollupMetadataService.setFailedMetadata(rollup2, string, rollupMetadata, (Continuation<? super MetadataResult>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    private final Object submitMetadataUpdate(RollupMetadata metadata, boolean updating, Continuation<? super MetadataResult> $completion) {
        if (!($completion instanceof submitMetadataUpdate.1)) ** GOTO lbl-1000
        var11_4 = $completion;
        if ((var11_4.label & -2147483648) != 0) {
            var11_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ RollupMetadataService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RollupMetadataService.access$submitMetadataUpdate(this.this$0, null, false, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var12_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                errorMessage = "An error occurred when " + (updating != false ? "updating" : "creating") + " rollup metadata";
                builder = XContentFactory.jsonBuilder().startObject().field("rollup_metadata", (ToXContent)metadata).endObject();
                indexRequest = new IndexRequest(".opendistro-ism-config").source(builder).routing(metadata.getRollupID());
                v0 = updating != false ? indexRequest.id(metadata.getId()).setIfSeqNo(metadata.getSeqNo()).setIfPrimaryTerm(metadata.getPrimaryTerm()) : indexRequest.opType(DocWriteRequest.OpType.CREATE);
                $continuation.L$0 = metadata;
                $continuation.L$1 = errorMessage;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)builder);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)indexRequest);
                $continuation.Z$0 = updating;
                $continuation.label = 1;
                v1 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)this.client, (Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, submitMetadataUpdate$lambda$3(org.opensearch.action.index.IndexRequest org.opensearch.transport.client.Client org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/Client;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((IndexRequest)indexRequest), $continuation);
                ** if (v1 != var12_6) goto lbl27
lbl26:
                // 1 sources

                return var12_6;
lbl27:
                // 1 sources

                ** GOTO lbl38
            }
            case 1: {
                updating = $continuation.Z$0;
                indexRequest = (IndexRequest)$continuation.L$3;
                builder = (XContentBuilder)$continuation.L$2;
                errorMessage = (String)$continuation.L$1;
                metadata = (RollupMetadata)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl38:
                    // 2 sources

                    response = (IndexResponse)v1;
                    status = metadata.getStatus();
                    failureReason = metadata.getFailureReason();
                    v2 = response.getResult();
                    switch (v2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[v2.ordinal()]) {
                        case 1: 
                        case 2: {
                            break;
                        }
                        case -1: 
                        case 3: 
                        case 4: 
                        case 5: {
                            status = RollupMetadata.Status.FAILED;
                            v3 = response.getResult();
                            failureReason = "The create metadata call failed with a " + (v3 != null ? v3.getLowercase() : null) + " result";
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    this.logger.debug("Metadata update successful {}", (Object)metadata);
                    v4 = response.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getId(...)");
                    return new MetadataResult.Success(RollupMetadata.copy$default(metadata, v4, response.getSeqNo(), response.getPrimaryTerm(), null, null, null, null, status, (String)failureReason, null, 632, null));
                }
                catch (RemoteTransportException e) {
                    v5 = ExceptionsHelper.unwrapCause((Throwable)e);
                    Intrinsics.checkNotNull((Object)v5, (String)"null cannot be cast to non-null type java.lang.Exception");
                    unwrappedException = (Exception)v5;
                    this.logger.error("Metadata update failed " + metadata.getRollupID(), (Throwable)unwrappedException);
                    return new MetadataResult.Failure((String)errorMessage, unwrappedException);
                }
                catch (Exception e) {
                    this.logger.error("Metadata update failed " + metadata.getRollupID(), (Throwable)e);
                    return new MetadataResult.Failure((String)errorMessage, e);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final Unit getInitialStartTime$lambda$0(SearchRequest $searchRequest, Client $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$suspendUntil.search($searchRequest, it);
        return Unit.INSTANCE;
    }

    private static final Unit getExistingMetadata$lambda$1(GetRequest $getRequest, Client $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$suspendUntil.get($getRequest, it);
        return Unit.INSTANCE;
    }

    private static final Unit submitMetadataUpdate$lambda$3(IndexRequest $indexRequest, Client $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$suspendUntil.index($indexRequest, it);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$recoverRetryMetadata(RollupMetadataService $this, Rollup rollup2, RollupMetadata metadata2, Continuation $completion) {
        return $this.recoverRetryMetadata(rollup2, metadata2, (Continuation<? super MetadataResult>)$completion);
    }

    public static final /* synthetic */ Object access$createContinuousMetadata(RollupMetadataService $this, Rollup rollup2, Continuation $completion) {
        return $this.createContinuousMetadata(rollup2, (Continuation<? super MetadataResult>)$completion);
    }

    public static final /* synthetic */ Object access$getInitialStartTime(RollupMetadataService $this, Rollup rollup2, Continuation $completion) {
        return $this.getInitialStartTime(rollup2, (Continuation<? super StartingTimeResult>)$completion);
    }

    public static final /* synthetic */ Object access$submitMetadataUpdate(RollupMetadataService $this, RollupMetadata metadata2, boolean updating, Continuation $completion) {
        return $this.submitMetadataUpdate(metadata2, updating, (Continuation<? super MetadataResult>)$completion);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DocWriteResponse.Result.values().length];
            try {
                nArray[DocWriteResponse.Result.CREATED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DocWriteResponse.Result.UPDATED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DocWriteResponse.Result.DELETED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DocWriteResponse.Result.NOOP.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DocWriteResponse.Result.NOT_FOUND.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

